/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.matrices.decomposition;

import java.io.Serializable;
import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.matrices.MatrixError;

public class CholeskyDecomposition
implements Serializable {
    private double[][] l;
    private int n;
    private boolean isspd;

    public CholeskyDecomposition(Matrix matrix) {
        double[][] a = matrix.getData();
        this.n = matrix.getRows();
        this.l = new double[this.n][this.n];
        this.isspd = matrix.getCols() == this.n;
        int j = 0;
        while (j < this.n) {
            double[] lrowj = this.l[j];
            double d = 0.0;
            int k = 0;
            while (k < j) {
                double[] lrowk = this.l[k];
                double s = 0.0;
                int i = 0;
                while (i < k) {
                    s += lrowk[i] * lrowj[i];
                    ++i;
                }
                lrowj[k] = s = (a[j][k] - s) / this.l[k][k];
                d += s * s;
                this.isspd &= a[k][j] == a[j][k];
                ++k;
            }
            this.isspd &= (d = a[j][j] - d) > 0.0;
            this.l[j][j] = Math.sqrt(Math.max(d, 0.0));
            k = j + 1;
            while (k < this.n) {
                this.l[j][k] = 0.0;
                ++k;
            }
            ++j;
        }
    }

    public final boolean isSPD() {
        return this.isspd;
    }

    public final Matrix getL() {
        return new Matrix(this.l);
    }

    public final Matrix solve(Matrix b) {
        int i;
        int j;
        if (b.getRows() != this.n) {
            throw new MatrixError("Matrix row dimensions must agree.");
        }
        if (!this.isspd) {
            throw new RuntimeException("Matrix is not symmetric positive definite.");
        }
        double[][] x = b.getArrayCopy();
        int nx = b.getCols();
        int k = 0;
        while (k < this.n) {
            j = 0;
            while (j < nx) {
                i = 0;
                while (i < k) {
                    double[] dArray = x[k];
                    int n = j;
                    dArray[n] = dArray[n] - x[i][j] * this.l[k][i];
                    ++i;
                }
                double[] dArray = x[k];
                int n = j++;
                dArray[n] = dArray[n] / this.l[k][k];
            }
            ++k;
        }
        k = this.n - 1;
        while (k >= 0) {
            j = 0;
            while (j < nx) {
                i = k + 1;
                while (i < this.n) {
                    double[] dArray = x[k];
                    int n = j;
                    dArray[n] = dArray[n] - x[i][j] * this.l[i][k];
                    ++i;
                }
                double[] dArray = x[k];
                int n = j++;
                dArray[n] = dArray[n] / this.l[k][k];
            }
            --k;
        }
        return new Matrix(x);
    }

    public double getDeterminant() {
        double result = 1.0;
        int i = 0;
        while (i < this.n) {
            result *= this.l[i][i];
            ++i;
        }
        return result * result;
    }

    public Matrix inverseCholesky() {
        double[][] li = this.lowerTriangularInverse(this.l);
        double[][] ic = new double[this.n][this.n];
        int r = 0;
        while (r < this.n) {
            int c = 0;
            while (c < this.n) {
                int i = 0;
                while (i < this.n) {
                    double[] dArray = ic[r];
                    int n = c;
                    dArray[n] = dArray[n] + li[i][r] * li[i][c];
                    ++i;
                }
                ++c;
            }
            ++r;
        }
        return new Matrix(ic);
    }

    private double[][] lowerTriangularInverse(double[][] m) {
        double[][] lti = new double[m.length][m.length];
        int j = 0;
        while (j < m.length) {
            if (m[j][j] == 0.0) {
                throw new IllegalArgumentException("Error, the matrix is not full rank");
            }
            lti[j][j] = 1.0 / m[j][j];
            int i = j + 1;
            while (i < m.length) {
                double sum = 0.0;
                int k = j;
                while (k < i) {
                    sum -= m[i][k] * lti[k][j];
                    ++k;
                }
                lti[i][j] = sum / m[i][i];
                ++i;
            }
            ++j;
        }
        return lti;
    }
}

