/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.matrices;

import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.matrices.MatrixError;
import org.encog.mathutil.matrices.decomposition.LUDecomposition;

public final class MatrixMath {
    public static Matrix add(Matrix a, Matrix b) {
        if (a.getRows() != b.getRows()) {
            throw new MatrixError("To add the matrices they must have the same number of rows and columns.  Matrix a has " + a.getRows() + " rows and matrix b has " + b.getRows() + " rows.");
        }
        if (a.getCols() != b.getCols()) {
            throw new MatrixError("To add the matrices they must have the same number of rows and columns.  Matrix a has " + a.getCols() + " cols and matrix b has " + b.getCols() + " cols.");
        }
        double[][] aa = a.getData();
        double[][] bb = b.getData();
        double[][] result = new double[a.getRows()][a.getCols()];
        int resultRow = 0;
        while (resultRow < a.getRows()) {
            int resultCol = 0;
            while (resultCol < a.getCols()) {
                result[resultRow][resultCol] = aa[resultRow][resultCol] + bb[resultRow][resultCol];
                ++resultCol;
            }
            ++resultRow;
        }
        return new Matrix(result);
    }

    public static void copy(Matrix source, Matrix target) {
        double[][] s = source.getData();
        double[][] t = target.getData();
        int row = 0;
        while (row < source.getRows()) {
            int col = 0;
            while (col < source.getCols()) {
                t[row][col] = s[row][col];
                ++col;
            }
            ++row;
        }
    }

    public static Matrix deleteCol(Matrix matrix, int deleted) {
        if (deleted >= matrix.getCols()) {
            throw new MatrixError("Can't delete column " + deleted + " from matrix, it only has " + matrix.getCols() + " columns.");
        }
        double[][] newMatrix = new double[matrix.getRows()][matrix.getCols() - 1];
        double[][] d = matrix.getData();
        int row = 0;
        while (row < matrix.getRows()) {
            int targetCol = 0;
            int col = 0;
            while (col < matrix.getCols()) {
                if (col != deleted) {
                    newMatrix[row][targetCol] = d[row][col];
                    ++targetCol;
                }
                ++col;
            }
            ++row;
        }
        return new Matrix(newMatrix);
    }

    public static Matrix deleteRow(Matrix matrix, int deleted) {
        if (deleted >= matrix.getRows()) {
            throw new MatrixError("Can't delete row " + deleted + " from matrix, it only has " + matrix.getRows() + " rows.");
        }
        double[][] newMatrix = new double[matrix.getRows() - 1][matrix.getCols()];
        double[][] d = matrix.getData();
        int targetRow = 0;
        int row = 0;
        while (row < matrix.getRows()) {
            if (row != deleted) {
                int col = 0;
                while (col < matrix.getCols()) {
                    newMatrix[targetRow][col] = d[row][col];
                    ++col;
                }
                ++targetRow;
            }
            ++row;
        }
        return new Matrix(newMatrix);
    }

    public static Matrix divide(Matrix a, double b) {
        double[][] result = new double[a.getRows()][a.getCols()];
        double[][] d = a.getData();
        int row = 0;
        while (row < a.getRows()) {
            int col = 0;
            while (col < a.getCols()) {
                result[row][col] = d[row][col] / b;
                ++col;
            }
            ++row;
        }
        return new Matrix(result);
    }

    public static double dotProduct(Matrix a, Matrix b) {
        double result;
        block7: {
            int aLength;
            double[][] bArray;
            double[][] aArray;
            block9: {
                block8: {
                    block6: {
                        int bLength;
                        if (!a.isVector() || !b.isVector()) {
                            throw new MatrixError("To take the dot product, both matrices must be vectors.");
                        }
                        aArray = a.getData();
                        bArray = b.getData();
                        aLength = aArray.length == 1 ? aArray[0].length : aArray.length;
                        int n = bLength = bArray.length == 1 ? bArray[0].length : bArray.length;
                        if (aLength != bLength) {
                            throw new MatrixError("To take the dot product, both matrices must be of the same length.");
                        }
                        result = 0.0;
                        if (aArray.length != 1 || bArray.length != 1) break block6;
                        int i = 0;
                        while (i < aLength) {
                            result += aArray[0][i] * bArray[0][i];
                            ++i;
                        }
                        break block7;
                    }
                    if (aArray.length != 1 || bArray[0].length != 1) break block8;
                    int i = 0;
                    while (i < aLength) {
                        result += aArray[0][i] * bArray[i][0];
                        ++i;
                    }
                    break block7;
                }
                if (aArray[0].length != 1 || bArray.length != 1) break block9;
                int i = 0;
                while (i < aLength) {
                    result += aArray[i][0] * bArray[0][i];
                    ++i;
                }
                break block7;
            }
            if (aArray[0].length != 1 || bArray[0].length != 1) break block7;
            int i = 0;
            while (i < aLength) {
                result += aArray[i][0] * bArray[i][0];
                ++i;
            }
        }
        return result;
    }

    public static Matrix identity(int size) {
        if (size < 1) {
            throw new MatrixError("Identity matrix must be at least of size 1.");
        }
        Matrix result = new Matrix(size, size);
        double[][] d = result.getData();
        int i = 0;
        while (i < size) {
            d[i][i] = 1.0;
            ++i;
        }
        return result;
    }

    public static Matrix multiply(Matrix a, double b) {
        double[][] result = new double[a.getRows()][a.getCols()];
        double[][] d = a.getData();
        int row = 0;
        while (row < a.getRows()) {
            int col = 0;
            while (col < a.getCols()) {
                result[row][col] = d[row][col] * b;
                ++col;
            }
            ++row;
        }
        return new Matrix(result);
    }

    public static Matrix multiply(Matrix a, Matrix b) {
        if (b.getRows() != a.getCols()) {
            throw new MatrixError("To use ordinary matrix multiplication the number of columns on the first matrix must mat the number of rows on the second.");
        }
        double[][] aData = a.getData();
        double[][] bData = b.getData();
        Matrix x = new Matrix(a.getRows(), b.getCols());
        double[][] c = x.getData();
        double[] bcolj = new double[a.getCols()];
        int j = 0;
        while (j < b.getCols()) {
            int k = 0;
            while (k < a.getCols()) {
                bcolj[k] = bData[k][j];
                ++k;
            }
            int i = 0;
            while (i < a.getRows()) {
                double[] arowi = aData[i];
                double s = 0.0;
                int k2 = 0;
                while (k2 < a.getCols()) {
                    s += arowi[k2] * bcolj[k2];
                    ++k2;
                }
                c[i][j] = s;
                ++i;
            }
            ++j;
        }
        return x;
    }

    public static Matrix subtract(Matrix a, Matrix b) {
        if (a.getRows() != b.getRows()) {
            throw new MatrixError("To subtract the matrices they must have the same number of rows and columns.  Matrix a has " + a.getRows() + " rows and matrix b has " + b.getRows() + " rows.");
        }
        if (a.getCols() != b.getCols()) {
            throw new MatrixError("To subtract the matrices they must have the same number of rows and columns.  Matrix a has " + a.getCols() + " cols and matrix b has " + b.getCols() + " cols.");
        }
        double[][] result = new double[a.getRows()][a.getCols()];
        double[][] aa = a.getData();
        double[][] bb = b.getData();
        int resultRow = 0;
        while (resultRow < a.getRows()) {
            int resultCol = 0;
            while (resultCol < a.getCols()) {
                result[resultRow][resultCol] = aa[resultRow][resultCol] - bb[resultRow][resultCol];
                ++resultCol;
            }
            ++resultRow;
        }
        return new Matrix(result);
    }

    public static Matrix transpose(Matrix input) {
        double[][] transposeMatrix = new double[input.getCols()][input.getRows()];
        double[][] d = input.getData();
        int r = 0;
        while (r < input.getRows()) {
            int c = 0;
            while (c < input.getCols()) {
                transposeMatrix[c][r] = d[r][c];
                ++c;
            }
            ++r;
        }
        return new Matrix(transposeMatrix);
    }

    public static double vectorLength(Matrix input) {
        if (!input.isVector()) {
            throw new MatrixError("Can only take the vector length of a vector.");
        }
        double[] v = input.toPackedArray();
        double rtn = 0.0;
        double[] dArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            Double element = dArray[n2];
            rtn += Math.pow(element, 2.0);
            ++n2;
        }
        return Math.sqrt(rtn);
    }

    private MatrixMath() {
    }

    public static double determinant(Matrix m) {
        return new LUDecomposition(m).det();
    }

    public static double[] multiply(Matrix a, double[] d) {
        double[] p = new double[a.getRows()];
        double[][] aData = a.getData();
        int r = 0;
        while (r < a.getRows()) {
            int i = 0;
            while (i < a.getCols()) {
                int n = r;
                p[n] = p[n] + aData[r][i] * d[i];
                ++i;
            }
            ++r;
        }
        return p;
    }
}

