/*
 * Decompiled with CFR 0.152.
 */
package org.encog.bot.browse.range;

import java.util.ArrayList;
import java.util.List;
import org.encog.bot.browse.WebPage;
import org.encog.bot.dataunit.DataUnit;
import org.encog.bot.dataunit.TextDataUnit;

public class DocumentRange {
    private int begin;
    private int end;
    private WebPage source;
    private String idAttribute;
    private String classAttribute;
    private final List<DocumentRange> elements = new ArrayList<DocumentRange>();
    private DocumentRange parent;

    public DocumentRange(WebPage theSource) {
        this.source = theSource;
    }

    public final void addElement(DocumentRange element) {
        this.elements.add(element);
        element.setParent(this);
    }

    public final int getBegin() {
        return this.begin;
    }

    public final String getClassAttribute() {
        return this.classAttribute;
    }

    public final List<DocumentRange> getElements() {
        return this.elements;
    }

    public final int getEnd() {
        return this.end;
    }

    public final String getIdAttribute() {
        return this.idAttribute;
    }

    public final DocumentRange getParent() {
        return this.parent;
    }

    public final WebPage getSource() {
        return this.source;
    }

    public final String getTextOnly() {
        StringBuilder result = new StringBuilder();
        int i = this.getBegin();
        while (i < this.getEnd()) {
            DataUnit du = this.source.getData().get(i);
            if (du instanceof TextDataUnit) {
                result.append(du.toString());
                result.append("\n");
            }
            ++i;
        }
        return result.toString();
    }

    public final void setBegin(int theBegin) {
        this.begin = theBegin;
    }

    public final void setClassAttribute(String theClassAttribute) {
        this.classAttribute = theClassAttribute;
    }

    public final void setEnd(int theEnd) {
        this.end = theEnd;
    }

    public final void setIdAttribute(String id) {
        this.idAttribute = id;
    }

    public final void setParent(DocumentRange theParent) {
        this.parent = theParent;
    }

    public final void setSource(WebPage theSource) {
        this.source = theSource;
    }
}

