/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.twoSample.medianTest;

import java.util.Arrays;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.tests.StatisticalTest;
import javanpst.utils.Operations;

public class MedianTest
extends StatisticalTest {
    private DataTable data;
    private double[] sample1;
    private double[] sample2;
    private double[] combined;
    private int n;
    private int m;
    private int t;
    private double medianValue;
    private int u;
    private int v;
    private double exactLeftTail;
    private double exactRightTail;
    private double exactDoubleTail;
    private double leftConfidence;
    private double rightConfidence;
    private double asymptoticLeftTail;
    private double asymptoticRightTail;
    private double asymptoticDoubleTail;
    private double confidence;

    public MedianTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.t = 0;
        this.u = 0;
        this.v = 0;
        this.sample1 = null;
        this.sample2 = null;
        this.exactLeftTail = -1.0;
        this.exactRightTail = -1.0;
        this.exactDoubleTail = -1.0;
        this.asymptoticLeftTail = -1.0;
        this.asymptoticRightTail = -1.0;
        this.asymptoticDoubleTail = -1.0;
    }

    public MedianTest(DataTable newData) {
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("Median test only can be employed with two samples");
            this.clearData();
            return;
        }
        int nulls = this.data.getColumnNulls(0);
        this.sample1 = new double[this.data.getRows() - nulls];
        nulls = this.data.getColumnNulls(1);
        this.sample2 = new double[this.data.getRows() - nulls];
        int counter1 = 0;
        int counter2 = 0;
        for (int i = 0; i < this.data.getRows(); ++i) {
            double value = this.data.get(i, 0);
            if (value != Double.MIN_VALUE) {
                this.sample1[counter1] = value;
                ++counter1;
            }
            if ((value = this.data.get(i, 1)) == Double.MIN_VALUE) continue;
            this.sample2[counter2] = value;
            ++counter2;
        }
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("Median test only can be employed with two samples");
            this.clearData();
            return;
        }
        int nulls = this.data.getColumnNulls(0);
        this.sample1 = new double[this.data.getRows() - nulls];
        nulls = this.data.getColumnNulls(1);
        this.sample2 = new double[this.data.getRows() - nulls];
        int counter1 = 0;
        int counter2 = 0;
        for (int i = 0; i < this.data.getRows(); ++i) {
            double value = this.data.get(i, 0);
            if (value != Double.MIN_VALUE) {
                this.sample1[counter1] = value;
                ++counter1;
            }
            if ((value = this.data.get(i, 1)) == Double.MIN_VALUE) continue;
            this.sample2[counter2] = value;
            ++counter2;
        }
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        int medianRank;
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.combined = new double[this.sample1.length + this.sample2.length];
        Arrays.sort(this.sample1);
        Arrays.sort(this.sample2);
        System.arraycopy(this.sample1, 0, this.combined, 0, this.sample1.length);
        System.arraycopy(this.sample2, 0, this.combined, this.sample1.length, this.sample2.length);
        Arrays.sort(this.combined);
        if (this.combined.length % 2 == 0) {
            medianRank = this.combined.length / 2;
            this.medianValue = (this.combined[medianRank - 1] + this.combined[medianRank]) / 2.0;
        } else {
            medianRank = (this.combined.length + 1) / 2;
            this.medianValue = this.combined[medianRank - 1];
        }
        this.n = this.sample2.length;
        this.m = this.sample1.length;
        this.t = this.combined.length % 2 == 0 ? this.combined.length / 2 : (this.combined.length - 1) / 2;
        this.u = 0;
        while (this.sample2[this.u] < this.medianValue) {
            ++this.u;
        }
        this.v = 0;
        while (this.sample1[this.v] < this.medianValue) {
            ++this.v;
        }
        this.computeStatistics();
        this.performed = true;
    }

    private void computeStatistics() {
        int i;
        System.out.println(this.m + this.n + " " + this.t);
        double denominator = Operations.combinatorial(this.m + this.n, this.t);
        double numerator = 0.0;
        double numerator1 = 0.0;
        double numerator2 = 0.0;
        int leftValue = -2;
        int rightValue = -1;
        double leftProb = 0.0;
        double rightProb = 0.0;
        double acum = 0.0;
        this.confidence = 0.0;
        int firstLimit = Math.max(0, this.t - this.n);
        int secondLimit = Math.min(this.m, this.t);
        for (i = firstLimit; i <= secondLimit; ++i) {
            if (i <= this.u && (leftProb += (numerator1 += Operations.combinatorial(this.m, i) * Operations.combinatorial(this.n, this.t - i)) / denominator) > 0.05 && leftValue == -2) {
                if (i == 0) {
                    leftValue = -1;
                    this.confidence += leftProb;
                } else {
                    leftValue = i - 1;
                    this.confidence += leftProb - numerator1 / denominator;
                }
            }
            if (i < this.u) continue;
            numerator2 += Operations.combinatorial(this.m, i) * Operations.combinatorial(this.n, this.t - i);
        }
        for (i = secondLimit; i >= firstLimit && rightValue == -1; --i) {
            if (!((rightProb += (acum += Operations.combinatorial(this.m, i) * Operations.combinatorial(this.n, this.t - i)) / denominator) > 0.05)) continue;
            if (i == secondLimit) {
                rightValue = secondLimit;
                this.confidence += rightProb;
                continue;
            }
            rightValue = i + 1;
            this.confidence += rightProb - acum / denominator;
        }
        this.confidence = 1.0 - this.confidence;
        this.exactLeftTail = numerator2 / denominator;
        this.exactRightTail = numerator1 / denominator;
        this.exactDoubleTail = Math.min(Math.min(this.exactLeftTail, this.exactRightTail) * 2.0, 1.0);
        this.leftConfidence = this.sample2[leftValue] - this.sample1[rightValue - 1];
        this.rightConfidence = this.sample2[rightValue - 1] - this.sample1[leftValue];
        NormalDistribution normal = new NormalDistribution();
        denominator = Math.sqrt((double)this.m * (double)this.n * (double)this.t * ((double)this.combined.length - (double)this.t) / ((double)this.combined.length * (double)this.combined.length * (double)this.combined.length));
        numerator = (double)this.u + 0.5 - (double)this.m * (double)this.t / (double)this.combined.length;
        this.asymptoticRightTail = normal.getTipifiedProbability(numerator / denominator, false);
        denominator = Math.sqrt((double)this.m * (double)this.n * (double)this.t * ((double)this.combined.length - (double)this.t) / ((double)this.combined.length * (double)this.combined.length * (double)this.combined.length));
        numerator = (double)this.v + 0.5 - (double)this.n * (double)this.t / (double)this.combined.length;
        this.asymptoticLeftTail = normal.getTipifiedProbability(numerator / denominator, false);
        this.asymptoticDoubleTail = Math.min(Math.min(this.asymptoticLeftTail, this.asymptoticRightTail) * 2.0, 1.0);
    }

    public double getU() {
        return this.u;
    }

    public double getV() {
        return this.v;
    }

    public double getMedian() {
        return this.medianValue;
    }

    public double getExactLeftPValue() {
        return this.exactLeftTail;
    }

    public double getExactRightPValue() {
        return this.exactRightTail;
    }

    public double getExactDoublePValue() {
        return this.exactDoubleTail;
    }

    public double getLeftPValue() {
        return this.asymptoticLeftTail;
    }

    public double getRightPValue() {
        return this.asymptoticRightTail;
    }

    public double getDoublePValue() {
        return this.asymptoticDoubleTail;
    }

    public String printConfidenceInterval() {
        String text = "";
        text = text + "[" + this.leftConfidence + "," + this.rightConfidence + "] Confidence = " + this.confidence;
        return text;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n***************************************\n";
        report = report + "Median test for 2 independent samples\n";
        report = report + "***************************************\n\n";
        report = report + "Median value: " + this.nf6.format(this.medianValue) + "\n";
        report = report + "U statistic: " + this.nf6.format(this.u) + "\n";
        report = report + "V statistic: " + this.nf6.format(this.v) + "\n\n";
        report = report + "Exact P-Value (Left tail, Y > X): " + this.nf6.format(this.exactLeftTail) + "\n";
        report = report + "Exact P-Value (Right tail, Y < X): " + this.nf6.format(this.exactRightTail) + "\n";
        report = report + "Exact P-Value (Double tail, Y != X): " + this.nf6.format(this.exactDoubleTail) + "\n\n";
        report = report + "Asymptotic P-Value (Left tail, Y > X): " + this.nf6.format(this.asymptoticLeftTail) + "\n";
        report = report + "Asymptotic P-Value (Right tail, Y > X): " + this.nf6.format(this.asymptoticRightTail) + "\n";
        report = report + "Asymptotic P-Value (Double tail, Y != X): " + this.nf6.format(this.asymptoticDoubleTail) + "\n\n";
        report = report + "Median diference = [" + this.leftConfidence + "," + this.rightConfidence + "] Confidence = " + this.nf6.format(this.confidence) + "\n";
        return report;
    }
}

