/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.scale.sukhatmeTest;

import java.util.Arrays;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.tests.StatisticalTest;

public class SukhatmeTest
extends StatisticalTest {
    private DataTable data;
    private double[] sample1;
    private double[] sample2;
    private int values1;
    private int values2;
    private int[] negative;
    private int[] positive;
    private double Tx;
    private double asymptoticLeftTail;
    private double asymptoticRightTail;
    private double asymptoticDoubleTail;
    private static final int X = 0;
    private static final int Y = 1;
    private static final int TIED_X = 2;
    private static final int TIED_Y = 3;

    public SukhatmeTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.Tx = 0.0;
        this.sample1 = null;
        this.sample2 = null;
        this.negative = null;
        this.positive = null;
        this.asymptoticLeftTail = -1.0;
        this.asymptoticRightTail = -1.0;
        this.asymptoticDoubleTail = -1.0;
    }

    public SukhatmeTest(DataTable newData) {
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("SukhatmeTest test only can be employed with two samples");
            this.clearData();
            return;
        }
        int nulls = this.data.getColumnNulls(0);
        this.values1 = this.data.getRows() - nulls;
        this.sample1 = new double[this.values1];
        nulls = this.data.getColumnNulls(1);
        this.values2 = this.data.getRows() - nulls;
        this.sample2 = new double[this.values2];
        int counter1 = 0;
        int counter2 = 0;
        for (int i = 0; i < this.data.getRows(); ++i) {
            double value = this.data.get(i, 0);
            if (value != Double.MIN_VALUE) {
                this.sample1[counter1] = value;
                ++counter1;
            }
            if ((value = this.data.get(i, 1)) == Double.MIN_VALUE) continue;
            this.sample2[counter2] = value;
            ++counter2;
        }
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("SukhatmeTest test only can be employed with two samples");
            this.clearData();
            return;
        }
        int nulls = this.data.getColumnNulls(0);
        this.values1 = this.data.getRows() - nulls;
        this.sample1 = new double[this.values1];
        nulls = this.data.getColumnNulls(1);
        this.values2 = this.data.getRows() - nulls;
        this.sample2 = new double[this.values2];
        int counter1 = 0;
        int counter2 = 0;
        for (int i = 0; i < this.data.getRows(); ++i) {
            double value = this.data.get(i, 0);
            if (value != Double.MIN_VALUE) {
                this.sample1[counter1] = value;
                ++counter1;
            }
            if ((value = this.data.get(i, 1)) == Double.MIN_VALUE) continue;
            this.sample2[counter2] = value;
            ++counter2;
        }
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        double auxValue;
        int i;
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        Arrays.sort(this.sample1);
        Arrays.sort(this.sample2);
        int countX = 0;
        int countY = 0;
        for (i = 0; i < this.sample1.length; ++i) {
            if (!(this.sample1[i] < 0.0)) continue;
            ++countX;
        }
        for (i = 0; i < this.sample2.length; ++i) {
            if (!(this.sample2[i] < 0.0)) continue;
            ++countY;
        }
        this.negative = new int[countX + countY];
        this.positive = new int[this.sample1.length - countX + (this.sample2.length - countY)];
        int pointer = 0;
        int pointer2 = 0;
        int pointer3 = 0;
        while ((this.sample1[pointer] < 0.0 || this.sample2[pointer2] < 0.0) && pointer < this.sample1.length && pointer2 < this.sample2.length) {
            if (this.sample1[pointer] < this.sample2[pointer2]) {
                this.negative[pointer3] = 0;
                ++pointer;
                ++pointer3;
                continue;
            }
            if (this.sample1[pointer] > this.sample2[pointer2]) {
                this.negative[pointer3] = 1;
                ++pointer2;
                ++pointer3;
                continue;
            }
            auxValue = this.sample1[pointer];
            while (this.sample1[pointer] == auxValue && pointer < this.sample1.length) {
                this.negative[pointer3] = 2;
                ++pointer;
                ++pointer3;
            }
            while (this.sample2[pointer2] == auxValue && pointer2 < this.sample2.length) {
                this.negative[pointer3] = 3;
                ++pointer2;
                ++pointer3;
            }
        }
        pointer3 = 0;
        while (pointer3 < this.positive.length && pointer < this.sample1.length && pointer2 < this.sample2.length) {
            if (this.sample1[pointer] < this.sample2[pointer2]) {
                this.positive[pointer3] = 0;
                ++pointer;
                ++pointer3;
                continue;
            }
            if (this.sample1[pointer] > this.sample2[pointer2]) {
                this.positive[pointer3] = 1;
                ++pointer2;
                ++pointer3;
                continue;
            }
            auxValue = this.sample1[pointer];
            while (this.sample1[pointer] == auxValue && pointer < this.sample1.length) {
                this.positive[pointer3] = 2;
                ++pointer;
                ++pointer3;
            }
            while (this.sample2[pointer2] == auxValue && pointer2 < this.sample2.length) {
                this.positive[pointer3] = 3;
                ++pointer2;
                ++pointer3;
            }
        }
        while (pointer < this.sample1.length) {
            this.positive[pointer3] = 0;
            ++pointer;
            ++pointer3;
        }
        while (pointer2 < this.sample2.length) {
            this.positive[pointer3] = 0;
            ++pointer2;
            ++pointer3;
        }
        this.Tx = 0.0;
        pointer = 0;
        for (pointer = 0; pointer < this.negative.length && this.negative[pointer] == 0; ++pointer) {
        }
        if (pointer < this.negative.length) {
            while (pointer < this.negative.length) {
                if (this.negative[pointer] == 0) {
                    this.Tx += 1.0;
                }
                if (this.negative[pointer] == 2) {
                    this.Tx += 0.5;
                }
                ++pointer;
            }
        }
        pointer = 0;
        for (pointer = this.positive.length - 1; pointer > -1 && this.positive[pointer] == 0; --pointer) {
        }
        if (pointer > -1) {
            while (pointer > -1) {
                if (this.positive[pointer] == 0) {
                    this.Tx += 1.0;
                }
                if (this.positive[pointer] == 2) {
                    this.Tx += 0.5;
                }
                --pointer;
            }
        }
        this.computePValues();
        this.performed = true;
    }

    private void computePValues() {
        NormalDistribution normal = new NormalDistribution();
        double N = this.values1 + this.values2;
        double denominator = (double)(this.values1 * this.values2) * (N + 7.0);
        denominator = Math.sqrt(denominator);
        double numerator = 4.0 * Math.sqrt(3.0) * (0.5 + this.Tx - (double)this.values1 * (double)this.values2 / 4.0);
        double z = numerator / denominator;
        this.asymptoticRightTail = 1.0 - normal.getTipifiedProbability(z, false);
        this.asymptoticLeftTail = normal.getTipifiedProbability(z, false);
        this.asymptoticDoubleTail = Math.min(Math.min(this.asymptoticLeftTail, this.asymptoticRightTail) * 2.0, 1.0);
    }

    public double getTestStatistic() {
        return this.Tx;
    }

    public double getLeftPValue() {
        return this.asymptoticLeftTail;
    }

    public double getRightPValue() {
        return this.asymptoticRightTail;
    }

    public double getDoublePValue() {
        return this.asymptoticDoubleTail;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n************\n";
        report = report + "Sukhatme test\n";
        report = report + "**************\n\n";
        report = report + "Sukhatme Statistic : " + this.nf6.format(this.Tx) + "\n\n";
        report = report + "Asymptotic P-Value (Left tail): " + this.nf6.format(this.asymptoticLeftTail) + "\n";
        report = report + "Asymptotic P-Value (Right tail): " + this.nf6.format(this.asymptoticRightTail) + "\n";
        report = report + "Asymptotic P-Value (Double tail): " + this.nf6.format(this.asymptoticDoubleTail) + "\n\n";
        return report;
    }
}

