/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.scale.david_BartonTest;

import java.util.Arrays;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.tests.StatisticalTest;

public class David_BartonTest
extends StatisticalTest {
    private DataTable data;
    private double[] sample1;
    private double[] sample2;
    private int values1;
    private int values2;
    private double[] combined;
    private int N;
    private double[] weights;
    private double sumWeights;
    private double MNx;
    private double MNy;
    private double asymptoticLeftTail;
    private double asymptoticRightTail;
    private double asymptoticDoubleTail;

    public David_BartonTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.MNx = 0.0;
        this.MNy = 0.0;
        this.sample1 = null;
        this.sample2 = null;
        this.weights = null;
        this.asymptoticLeftTail = -1.0;
        this.asymptoticRightTail = -1.0;
        this.asymptoticDoubleTail = -1.0;
    }

    public David_BartonTest(DataTable newData) {
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("David-Barton test only can be employed with two samples");
            this.clearData();
            return;
        }
        int nulls = this.data.getColumnNulls(0);
        this.values1 = this.data.getRows() - nulls;
        this.sample1 = new double[this.values1];
        nulls = this.data.getColumnNulls(1);
        this.values2 = this.data.getRows() - nulls;
        this.sample2 = new double[this.values2];
        int counter1 = 0;
        int counter2 = 0;
        for (int i = 0; i < this.data.getRows(); ++i) {
            double value = this.data.get(i, 0);
            if (value != Double.MIN_VALUE) {
                this.sample1[counter1] = value;
                ++counter1;
            }
            if ((value = this.data.get(i, 1)) == Double.MIN_VALUE) continue;
            this.sample2[counter2] = value;
            ++counter2;
        }
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("David-Barton test only can be employed with two samples");
            this.clearData();
            return;
        }
        int nulls = this.data.getColumnNulls(0);
        this.values1 = this.data.getRows() - nulls;
        this.sample1 = new double[this.values1];
        nulls = this.data.getColumnNulls(1);
        this.values2 = this.data.getRows() - nulls;
        this.sample2 = new double[this.values2];
        int counter1 = 0;
        int counter2 = 0;
        for (int i = 0; i < this.data.getRows(); ++i) {
            double value = this.data.get(i, 0);
            if (value != Double.MIN_VALUE) {
                this.sample1[counter1] = value;
                ++counter1;
            }
            if ((value = this.data.get(i, 1)) == Double.MIN_VALUE) continue;
            this.sample2[counter2] = value;
            ++counter2;
        }
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.combined = new double[this.sample1.length + this.sample2.length];
        Arrays.sort(this.sample1);
        Arrays.sort(this.sample2);
        System.arraycopy(this.sample1, 0, this.combined, 0, this.sample1.length);
        System.arraycopy(this.sample2, 0, this.combined, this.sample1.length, this.sample2.length);
        Arrays.sort(this.combined);
        this.N = this.sample1.length + this.sample2.length;
        this.weights = new double[this.N];
        this.generateWeights();
        this.MNx = 0.0;
        this.MNy = 0.0;
        int pointer2 = 0;
        for (int pointer = 0; pointer < this.sample1.length; ++pointer) {
            while (this.combined[pointer2] != this.sample1[pointer]) {
                ++pointer2;
            }
            this.MNx += this.weights[pointer2];
        }
        this.MNy = this.sumWeights - this.MNx;
        this.computePValues();
        this.performed = true;
    }

    private void generateWeights() {
        double value;
        int i;
        this.sumWeights = 0.0;
        for (i = 1; i <= (this.N + 1) / 2; ++i) {
            this.weights[i - 1] = value = (double)((this.N + 2) / 2 - i);
            this.sumWeights += value;
        }
        for (i = (this.N + 1) / 2 + 1; i <= this.N; ++i) {
            this.weights[i - 1] = value = (double)(i - (this.N + 1) / 2);
            this.sumWeights += value;
        }
    }

    private void computePValues() {
        double z;
        double m1 = this.values1;
        double m2 = this.values2;
        NormalDistribution normal = new NormalDistribution();
        boolean even = this.N % 2 == 0;
        if (even) {
            double a = m1 * m2 * ((double)(this.N * this.N) - 4.0);
            double b = 48.0 * ((double)this.N - 1.0);
            double denominator = Math.sqrt(a / b);
            double numerator = this.MNx - m1 * ((double)this.N + 2.0) / 4.0;
            z = numerator / denominator;
        } else {
            double a = m1 * m2 * (m2 + 1.0) * ((double)(this.N * this.N) + 3.0);
            double b = 48.0 * (double)(this.N * this.N);
            double denominator = Math.sqrt(a / b);
            double numerator = this.MNx - m1 * ((double)(this.N * this.N) - 1.0) / (4.0 * (double)this.N);
            z = numerator / denominator;
        }
        this.asymptoticLeftTail = normal.getTipifiedProbability(z, true);
        this.asymptoticRightTail = normal.getTipifiedProbability(z, false);
        this.asymptoticDoubleTail = 2.0 * Math.min(this.asymptoticLeftTail, this.asymptoticRightTail);
    }

    public double getTestStatistic1() {
        return this.MNx;
    }

    public double getTestStatistic2() {
        return this.MNy;
    }

    public double getLeftPValue() {
        return this.asymptoticLeftTail;
    }

    public double getRightPValue() {
        return this.asymptoticRightTail;
    }

    public double getDoublePValue() {
        return this.asymptoticDoubleTail;
    }

    public String printWeights() {
        String text = "";
        for (int i = 0; i < this.weights.length; ++i) {
            text = text + this.weights[i] + " ";
        }
        return text;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n************\n";
        report = report + "David-Barton test\n";
        report = report + "**************\n\n";
        report = report + "David-Barton Statistic X: " + this.nf6.format(this.MNx) + "\n";
        report = report + "David-Barton Statistic Y: " + this.nf6.format(this.MNy) + "\n\n";
        report = report + "Asymptotic P-Value (Left tail): " + this.nf6.format(this.asymptoticLeftTail) + "\n";
        report = report + "Asymptotic P-Value (Right tail): " + this.nf6.format(this.asymptoticRightTail) + "\n";
        report = report + "Asymptotic P-Value (Double tail): " + this.nf6.format(this.asymptoticDoubleTail) + "\n\n";
        return report;
    }
}

