/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.randomness.vonNeumannTest;

import java.util.Arrays;
import javanpst.data.structures.sequence.NumericSequence;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.distributions.tests.NMDistribution;
import javanpst.distributions.tests.RVNDistribution;
import javanpst.tests.StatisticalTest;

public class VonNeumannTest
extends StatisticalTest {
    private NMDistribution distributionNM = NMDistribution.getInstance();
    private RVNDistribution distributionRVN = RVNDistribution.getInstance();
    private NumericSequence sequence;
    private double exactLeftTail;
    private double exactRightTail;
    private double exactDoubleTail;
    private double asymptoticLeftTail;
    private double asymptoticRightTail;
    private double asymptoticDoubleTail;
    private double[] ranks;
    private double NM;
    private double RVN;

    public VonNeumannTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.sequence = new NumericSequence();
        this.performed = false;
        this.dataReady = false;
        this.NM = 0.0;
        this.RVN = 0.0;
        this.ranks = null;
        this.exactLeftTail = -1.0;
        this.exactRightTail = -1.0;
        this.exactDoubleTail = -1.0;
        this.asymptoticLeftTail = -1.0;
        this.asymptoticRightTail = -1.0;
        this.asymptoticDoubleTail = -1.0;
    }

    public VonNeumannTest(NumericSequence newSequence) {
        this.setReportFormat();
        this.sequence = new NumericSequence(newSequence);
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(NumericSequence newSequence) {
        this.sequence = new NumericSequence(newSequence);
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.computeRanks();
        double denominator = 0.0;
        double n = this.sequence.size();
        this.NM = 0.0;
        for (int i = 0; i < this.ranks.length - 1; ++i) {
            this.NM += (this.ranks[i] - this.ranks[i + 1]) * (this.ranks[i] - this.ranks[i + 1]);
            denominator += (this.ranks[i] - (n + 1.0) / 2.0) * (this.ranks[i] - (n + 1.0) / 2.0);
        }
        this.RVN = this.NM / (denominator += (this.ranks[this.ranks.length - 1] - (n + 1.0) / 2.0) * (this.ranks[this.ranks.length - 1] - (n + 1.0) / 2.0));
        if (n <= 10.0) {
            this.exactLeftTail = this.distributionNM.computeLeftProbability(this.sequence.size(), this.NM);
            this.exactRightTail = this.distributionNM.computeRightProbability(this.sequence.size(), this.NM);
        } else {
            this.exactLeftTail = this.distributionRVN.computeLeftProbability(this.sequence.size(), this.RVN);
            this.exactRightTail = this.distributionRVN.computeRightProbability(this.sequence.size(), this.RVN);
        }
        this.exactDoubleTail = Math.min(Math.min(this.exactLeftTail, this.exactRightTail) * 2.0, 1.0);
        NormalDistribution normal = new NormalDistribution();
        double variance = 4.0 * (n - 2.0) * (5.0 * n * n - 2.0 * n - 9.0) / (5.0 * n * (n + 1.0) * (n - 1.0) * (n - 1.0));
        double z = (this.RVN - 2.0) / Math.sqrt(variance);
        this.asymptoticLeftTail = normal.getTipifiedProbability(z, false);
        this.asymptoticRightTail = normal.getTipifiedProbability(z, true);
        this.asymptoticDoubleTail = Math.min(Math.min(this.asymptoticLeftTail, this.asymptoticRightTail) * 2.0, 1.0);
        this.performed = true;
    }

    private void computeRanks() {
        int ties;
        this.ranks = new double[this.sequence.size()];
        Arrays.fill(this.ranks, -1.0);
        for (int rank = 1; rank <= this.sequence.size(); rank += ties) {
            int i;
            double minValue = Double.MAX_VALUE;
            ties = 0;
            for (i = 0; i < this.sequence.size(); ++i) {
                if (this.ranks[i] != -1.0) continue;
                if (this.sequence.get(i) == minValue) {
                    ++ties;
                }
                if (!(this.sequence.get(i) < minValue)) continue;
                minValue = this.sequence.get(i);
                ties = 1;
            }
            double rankValue = ties == 1 ? (double)rank : ((double)ties + 1.0) * (double)ties / 2.0 + (double)((rank - 1) * ties / ties);
            for (i = 0; i < this.sequence.size(); ++i) {
                if (this.sequence.get(i) != minValue) continue;
                this.ranks[i] = rankValue;
            }
        }
    }

    public double getNM() {
        return this.NM;
    }

    public double getRVN() {
        return this.RVN;
    }

    public double getExactLeftPValue() {
        return this.exactLeftTail;
    }

    public double getExactRightPValue() {
        return this.exactRightTail;
    }

    public double getExactDoublePValue() {
        return this.exactDoubleTail;
    }

    public double getLeftPValue() {
        return this.asymptoticLeftTail;
    }

    public double getRightPValue() {
        return this.asymptoticRightTail;
    }

    public double getDoublePValue() {
        return this.asymptoticDoubleTail;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.sequence;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n****************************************\n";
        report = report + "Von Neumann test (ranks test of randomness)\n";
        report = report + "****************************************\n\n";
        report = report + "NM statistic: " + this.nf6.format(this.NM) + "\n";
        report = report + "RVN statistic: " + this.nf6.format(this.RVN) + "\n\n";
        report = report + "Exact P-Value (Left tail, Too few runs): " + this.nf6.format(this.exactLeftTail) + "\n";
        report = report + "Exact P-Value (Right tail, Too many runs): " + this.nf6.format(this.exactRightTail) + "\n";
        report = report + "Exact P-Value (Double tail, Non randomness): " + this.nf6.format(this.exactDoubleTail) + "\n\n";
        report = report + "Asymptotic P-Value (Left tail, Too few runs): " + this.nf6.format(this.asymptoticLeftTail) + "\n";
        report = report + "Asymptotic P-Value (Right tail, Too many runs): " + this.nf6.format(this.asymptoticRightTail) + "\n";
        report = report + "Asymptotic P-Value (Double tail, Non randomness): " + this.nf6.format(this.asymptoticDoubleTail) + "\n\n";
        return report;
    }
}

