/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.equality.JTTest;

import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.tests.StatisticalTest;

public class JTTest
extends StatisticalTest {
    private DataTable data;
    private double[][] samples;
    private double B;
    private double Z;
    private double pValue;

    public JTTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.B = 0.0;
        this.Z = 0.0;
        this.samples = null;
        this.pValue = -1.0;
    }

    public JTTest(DataTable newData) {
        int i;
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() < 3) {
            System.out.println("Extended median test only can be employed with more than two samples");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.samples = new double[this.data.getRows()][this.data.getColumns()];
        for (i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.samples[i][j] = this.data.get(i, j);
            }
        }
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        int i;
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() < 3) {
            System.out.println("Extended median test only can be employed with more than two samples");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.samples = new double[this.data.getRows()][this.data.getColumns()];
        for (i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.samples[i][j] = this.data.get(i, j);
            }
        }
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.B = 0.0;
        for (int first = 0; first < this.data.getColumns() - 1; ++first) {
            for (int second = first + 1; second < this.data.getColumns(); ++second) {
                int counter = 0;
                for (int i = 0; i < this.data.getRows(); ++i) {
                    double value = this.samples[i][second];
                    for (int j = 0; j < this.data.getRows(); ++j) {
                        if (!(value > this.samples[j][first])) continue;
                        ++counter;
                    }
                }
                this.B += (double)counter;
            }
        }
        int N = this.data.getRows() * this.data.getColumns();
        double stMean = (double)(N * N - this.data.getColumns() * this.data.getRows() * this.data.getRows()) / 4.0;
        double stDev = (double)(N * N) * ((double)(2 * N) + 3.0) - (double)(this.data.getColumns() * this.data.getRows() * this.data.getRows()) * ((double)(2 * this.data.getRows()) + 3.0);
        stDev /= 72.0;
        stDev = Math.sqrt(stDev);
        this.Z = (this.B - stMean) / stDev;
        this.computePValue();
        this.performed = true;
    }

    private void computePValue() {
        NormalDistribution normal = new NormalDistribution();
        this.pValue = 1.0 - normal.getTipifiedProbability(this.Z, false);
    }

    public double getB() {
        return this.B;
    }

    public double getZ() {
        return this.Z;
    }

    public double getPValue() {
        return this.pValue;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n***************************************\n";
        report = report + "Jonckheere and Terpstra test (JT test)\n";
        report = report + "***************************************\n\n";
        report = report + "B statistic: " + this.nf6.format(this.B) + "\n\n";
        report = report + "P-Value computed :" + this.nf6.format(this.pValue) + "\n\n";
        return report;
    }
}

