/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.countData.contingencyCoefficient;

import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.common.continuous.ChiSquareDistribution;
import javanpst.tests.StatisticalTest;

public class ContingencyCoefficient
extends StatisticalTest {
    private DataTable data;
    private double[][] contingencyTable;
    private double N;
    private double Q;
    private double pValue;
    private double C;
    private double phi;

    public ContingencyCoefficient() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.Q = 0.0;
        this.C = 0.0;
        this.phi = 0.0;
        this.contingencyTable = null;
        this.pValue = -1.0;
    }

    public ContingencyCoefficient(DataTable newData) {
        int i;
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.contingencyTable = new double[this.data.getRows()][this.data.getColumns()];
        for (i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.contingencyTable[i][j] = this.data.get(i, j);
            }
        }
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        int i;
        this.data = DataTable.newInstance(newData);
        for (i = 0; i < newData.getColumns(); ++i) {
            if (newData.getRowNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.contingencyTable = new double[this.data.getRows()][this.data.getColumns()];
        for (i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.contingencyTable[i][j] = this.data.get(i, j);
            }
        }
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        double acum;
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        double[] sumRow = new double[this.contingencyTable.length];
        double[] sumColumn = new double[this.contingencyTable[0].length];
        this.N = 0.0;
        for (int i = 0; i < this.contingencyTable.length; ++i) {
            acum = 0.0;
            for (int j = 0; j < this.contingencyTable[0].length; ++j) {
                acum += this.contingencyTable[i][j];
                this.N += this.contingencyTable[i][j];
            }
            sumRow[i] = acum;
        }
        for (int j = 0; j < this.contingencyTable[0].length; ++j) {
            acum = 0.0;
            for (int i = 0; i < this.contingencyTable.length; ++i) {
                acum += this.contingencyTable[i][j];
            }
            sumColumn[j] = acum;
        }
        this.Q = 0.0;
        for (int i = 0; i < this.contingencyTable.length; ++i) {
            for (int j = 0; j < this.contingencyTable[0].length; ++j) {
                double term = this.N * this.contingencyTable[i][j] - sumRow[i] * sumColumn[j];
                term *= term;
                this.Q += (term /= this.N * sumRow[i] * sumColumn[j]);
            }
        }
        int dF = (sumRow.length - 1) * (sumColumn.length - 1);
        this.pValue = this.computePValue(dF);
        this.C = Math.sqrt(this.Q / (this.Q + this.N));
        this.phi = Math.sqrt(this.Q / this.N);
        this.performed = true;
    }

    private double computePValue(int dF) {
        ChiSquareDistribution chi = new ChiSquareDistribution();
        chi.setDegree(dF);
        this.pValue = chi.computeCumulativeProbability(this.Q);
        return this.pValue;
    }

    public double getQ() {
        return this.Q;
    }

    public double getC() {
        return this.C;
    }

    public double getPhi() {
        return this.phi;
    }

    public double getPValue() {
        return this.pValue;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n*************\n";
        report = report + "Contingency coefficient based test\n";
        report = report + "*************\n\n";
        report = report + "Q statistic: " + this.nf6.format(this.Q) + "\n";
        report = report + "Asymptotic P-Value: " + this.nf6.format(this.pValue) + "\n\n";
        report = report + "C contingency coefficient: " + this.nf6.format(this.C) + "\n";
        report = report + "Phi contingency coefficient: " + this.nf6.format(this.phi) + "\n\n";
        report = report + "Contingency table\n\n";
        for (int i = 0; i < this.contingencyTable.length; ++i) {
            for (int j = 0; j < this.contingencyTable[0].length; ++j) {
                report = report + this.contingencyTable[i][j] + "\t";
            }
            report = report + "\n";
        }
        report = report + "\n";
        return report;
    }
}

