/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.tests;

import java.io.IOException;
import javanpst.data.distributions.incompleteTable.Incomplete2KeyTable;
import javanpst.data.readers.distributionReaders.RunsUpDownReaderFormat;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.distributions.tests.TestDistribution;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RunsUpDownDistribution
extends TestDistribution {
    private NormalDistribution normal;
    private static Incomplete2KeyTable table;
    private static double[] leftLimits;

    private RunsUpDownDistribution() {
        this.initialize();
    }

    public static RunsUpDownDistribution getInstance() {
        return SingletonHolder.distribution;
    }

    @Override
    protected void generateTables() {
        table = new Incomplete2KeyTable(26, 25);
        this.loadFiles();
        this.normal = new NormalDistribution();
    }

    @Override
    protected void loadFiles() {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            sp.parse(this.getClass().getResourceAsStream("/tables/RunsUpDown/RunsUpDown.xml"), (DefaultHandler)new RunsUpDownReaderFormat());
        }
        catch (ParserConfigurationException e) {
            System.err.println("Parser error");
        }
        catch (SAXException e2) {
            System.err.println("SAX error: " + e2.getStackTrace());
        }
        catch (IOException e3) {
            System.err.println("Input/Output error: " + e3.getMessage());
        }
    }

    public static Incomplete2KeyTable getTable() {
        return table;
    }

    public double computeExactProbability(int n, int R, boolean leftTail) {
        if (n < 3 || n > 25 || R >= n || R < 1) {
            return -1.0;
        }
        if (leftTail ? (double)R > leftLimits[n] : (double)R <= leftLimits[n]) {
            return 1.0;
        }
        double value = table.get(n, R);
        return value;
    }

    public double computeAsymptoticLeftTailProbability(int n, int R) {
        double denominator = Math.sqrt((16.0 * (double)n - 29.0) / 90.0);
        double numerator = (double)R + 0.5 - (2.0 * (double)n - 1.0) / 3.0;
        double z = numerator / denominator;
        return this.normal.getTipifiedProbability(z, false);
    }

    public double computeAsymptoticRightTailProbability(int n, int R) {
        double denominator = Math.sqrt((16.0 * (double)n - 29.0) / 90.0);
        double numerator = (double)R - 0.5 - (2.0 * (double)n - 1.0) / 3.0;
        double z = numerator / denominator;
        return this.normal.getTipifiedProbability(z, false);
    }

    public double computeAsymptoticDoubleTailProbability(int n, int R) {
        double denominator = Math.sqrt((16.0 * (double)n - 29.0) / 90.0);
        double numerator = (double)R - 0.5 - (2.0 * (double)n - 1.0) / 3.0;
        double z = numerator / denominator;
        double rightPValue = this.normal.getTipifiedProbability(z, false);
        numerator = (double)R + 0.5 - (2.0 * (double)n - 1.0) / 3.0;
        z = numerator / denominator;
        this.normal.getTipifiedProbability(z, false);
        double leftPValue = this.normal.getTipifiedProbability(z, false);
        return Math.min(Math.min(leftPValue, rightPValue) * 2.0, 1.0);
    }

    static {
        leftLimits = new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 2.0, 3.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 7.0, 8.0, 9.0, 9.0, 10.0, 11.0, 11.0, 12.0, 13.0, 13.0, 14.0, 15.0, 15.0};
    }

    private static class SingletonHolder {
        public static final RunsUpDownDistribution distribution = new RunsUpDownDistribution();

        private SingletonHolder() {
        }
    }
}

