/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.tests;

import java.io.IOException;
import javanpst.data.distributions.criticalTable.Critical1KeyTable;
import javanpst.data.distributions.incompleteTable.Incomplete3KeyTable;
import javanpst.data.readers.distributionReaders.KolmogorovTwoSampleAsymptoticalReaderFormat;
import javanpst.data.readers.distributionReaders.KolmogorovTwoSampleReaderFormat;
import javanpst.distributions.tests.TestDistribution;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class KolmogorovTwoSampleDistribution
extends TestDistribution {
    private static Incomplete3KeyTable exactTable;
    private static Critical1KeyTable table;

    private KolmogorovTwoSampleDistribution() {
        this.initialize();
    }

    public static KolmogorovTwoSampleDistribution getInstance() {
        return SingletonHolder.distribution;
    }

    @Override
    protected void generateTables() {
        double[] tags = new double[]{0.2, 0.1, 0.05, 0.02, 0.01};
        table = new Critical1KeyTable(21, tags);
        exactTable = new Incomplete3KeyTable(9, 9, 65);
        this.loadFiles();
    }

    @Override
    protected void loadFiles() {
        SAXParser sp;
        SAXParserFactory spf;
        try {
            spf = SAXParserFactory.newInstance();
            sp = spf.newSAXParser();
            sp.parse(this.getClass().getResourceAsStream("/tables/Kolmogorov/TwoSampleAsymptotical.xml"), (DefaultHandler)new KolmogorovTwoSampleAsymptoticalReaderFormat());
        }
        catch (ParserConfigurationException e) {
            System.err.println("Parser error");
        }
        catch (SAXException e2) {
            System.err.println("SAX error: " + e2.getStackTrace());
        }
        catch (IOException e3) {
            System.err.println("Input/Output error: " + e3.getMessage());
        }
        try {
            spf = SAXParserFactory.newInstance();
            sp = spf.newSAXParser();
            sp.parse(this.getClass().getResourceAsStream("/tables/Kolmogorov/TwoSample.xml"), (DefaultHandler)new KolmogorovTwoSampleReaderFormat());
        }
        catch (ParserConfigurationException e) {
            System.err.println("Parser error");
        }
        catch (SAXException e2) {
            System.err.println("SAX error: " + e2.getStackTrace());
        }
        catch (IOException e3) {
            System.err.println("Input/Output error: " + e3.getMessage());
        }
    }

    public static Critical1KeyTable getTable() {
        return table;
    }

    public static Incomplete3KeyTable getExactTable() {
        return exactTable;
    }

    public double computeExactProbability(int n, double Dn) {
        if (n < 9) {
            double nmDn = (double)(n * n) * Dn;
            int nmDnInteger = (int)nmDn;
            double pValue = exactTable.get(n, n, nmDnInteger);
            if (pValue == -1.0) {
                return 1.0;
            }
            return pValue;
        }
        return 1.0;
    }

    public double computeAsymptoticProbability(int n, double Dn) {
        double[] asymptoticValues = new double[]{1.07, 1.22, 1.36, 1.52, 1.63};
        if (n < 21) {
            double nmDn = (double)(n * n) * Dn;
            if (table.get(n, 0) == -1.0) {
                return -1.0;
            }
            for (int i = 4; i > -1; --i) {
                if (!(nmDn >= table.get(n, i))) continue;
                return table.getHeader(i);
            }
        } else {
            double size = Math.sqrt((n + n) / (n * n));
            for (int i = 4; i > -1; --i) {
                if (!(Dn >= asymptoticValues[i] / size)) continue;
                return table.getHeader(i);
            }
        }
        return 1.0;
    }

    private static class SingletonHolder {
        public static final KolmogorovTwoSampleDistribution distribution = new KolmogorovTwoSampleDistribution();

        private SingletonHolder() {
        }
    }
}

