/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.tests;

import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.distributions.tests.TestDistribution;
import javanpst.utils.Operations;

public class CDDistribution
extends TestDistribution {
    private NormalDistribution normal;

    private CDDistribution() {
        this.initialize();
    }

    public static CDDistribution getInstance() {
        return SingletonHolder.distribution;
    }

    @Override
    protected void generateTables() {
        this.normal = new NormalDistribution();
    }

    @Override
    protected void loadFiles() {
    }

    public double computeExactProbability(double W, int N, int populations, int length) {
        double pValue = (double)length / (double)N;
        pValue *= Operations.combinatorial(N - length, (int)W) * Operations.combinatorial(length - 1, populations - 1);
        return pValue /= Operations.combinatorial(N - 1, (int)W + populations - 1);
    }

    public double computeAsymptoticProbability(double W, int N, int populations, int length) {
        double stMean = (double)(N - length) * ((double)populations / ((double)length + 1.0));
        double stDev = (double)populations * ((double)(length - populations) + 1.0) * ((double)N + 1.0) * (double)(N - length);
        stDev /= ((double)length + 1.0) * ((double)length + 1.0) * ((double)length + 2.0);
        stDev = Math.sqrt(stDev);
        double Z = (W - stMean + 0.5) / stDev;
        return this.normal.getTipifiedProbability(Z, false);
    }

    private static class SingletonHolder {
        public static final CDDistribution distribution = new CDDistribution();

        private SingletonHolder() {
        }
    }
}

