/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.common.continuous;

import javanpst.distributions.common.Distribution;

public class NormalDistribution
implements Distribution {
    private double mean;
    private double sigma;

    public NormalDistribution() {
        this.mean = 0.0;
        this.sigma = 1.0;
    }

    public NormalDistribution(double mean, double sigma) {
        if (sigma > 0.0) {
            this.mean = mean;
            this.sigma = sigma;
        }
    }

    public NormalDistribution(NormalDistribution old) {
        this(old.getMean(), old.getSigma());
    }

    public void setMean(double value) {
        this.mean = value;
    }

    public void setS(double value) {
        if (value > 0.0) {
            this.sigma = value;
        }
    }

    public double getMean() {
        return this.mean;
    }

    public double getSigma() {
        return this.sigma;
    }

    @Override
    public double computeProbability(double x) {
        double value = 0.0;
        value = Math.pow(Math.E, -(x - this.mean) * (x - this.mean) / (2.0 * this.sigma * this.sigma));
        return value /= Math.sqrt(Math.PI * 2 * this.sigma * this.sigma);
    }

    @Override
    public double computeCumulativeProbability(double x) {
        double z = (x - this.mean) / this.sigma;
        double value = this.getTipifiedProbability(z, false);
        return value;
    }

    public double getTipifiedProbability(double z, boolean upper) {
        double alnorm;
        double ltone = 7.0;
        double utzero = 18.66;
        double con = 1.28;
        double a1 = 0.398942280444;
        double a2 = 0.399903438504;
        double a3 = 5.75885480458;
        double a4 = 29.8213557808;
        double a5 = 2.62433121679;
        double a6 = 48.6959930692;
        double a7 = 5.92885724438;
        double b1 = 0.398942280385;
        double b2 = 3.8052E-8;
        double b3 = 1.00000615302;
        double b4 = 3.98064794E-4;
        double b5 = 1.986153813664;
        double b6 = 0.151679116635;
        double b7 = 5.29330324926;
        double b8 = 4.8385912808;
        double b9 = 15.1508972451;
        double b10 = 0.742380924027;
        double b11 = 30.789933034;
        double b12 = 3.99019417011;
        if (z < 0.0) {
            upper = !upper;
            z = -z;
        }
        if (z <= ltone || upper && z <= utzero) {
            double y = 0.5 * z * z;
            alnorm = z > con ? b1 * Math.exp(-y) / (z - b2 + b3 / (z + b4 + b5 / (z - b6 + b7 / (z + b8 - b9 / (z + b10 + b11 / (z + b12)))))) : 0.5 - z * (a1 - a2 * y / (y + a3 - a4 / (y + a5 + a6 / (y + a7))));
        } else {
            alnorm = 0.0;
        }
        if (!upper) {
            alnorm = 1.0 - alnorm;
        }
        return alnorm;
    }

    public double inverseNormalDistribution(double p) {
        double a1 = -39.69683028665376;
        double a2 = 220.9460984245205;
        double a3 = -275.9285104469687;
        double a4 = 138.357751867269;
        double a5 = -30.66479806614716;
        double a6 = 2.506628277459239;
        double b1 = -54.47609879822406;
        double b2 = 161.5858368580409;
        double b3 = -155.6989798598866;
        double b4 = 66.80131188771972;
        double b5 = -13.28068155288572;
        double c1 = -0.007784894002430293;
        double c2 = -0.3223964580411365;
        double c3 = -2.400758277161838;
        double c4 = -2.549732539343734;
        double c5 = 4.374664141464968;
        double c6 = 2.938163982698783;
        double d1 = 0.007784695709041462;
        double d2 = 0.3224671290700398;
        double d3 = 2.445134137142996;
        double d4 = 3.754408661907416;
        double p_low = 0.02425;
        double p_high = 1.0 - p_low;
        double x = 0.0;
        if (p <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (p < p_low) {
            double q = Math.sqrt(-2.0 * Math.log(p));
            x = (((((c1 * q + c2) * q + c3) * q + c4) * q + c5) * q + c6) / ((((d1 * q + d2) * q + d3) * q + d4) * q + 1.0);
            return x;
        }
        if (p <= p_high) {
            double q = p - 0.5;
            double r = q * q;
            x = (((((a1 * r + a2) * r + a3) * r + a4) * r + a5) * r + a6) * q / (((((b1 * r + b2) * r + b3) * r + b4) * r + b5) * r + 1.0);
            return x;
        }
        if (p_high < p) {
            double q = Math.sqrt(-2.0 * Math.log(1.0 - p));
            x = -(((((c1 * q + c2) * q + c3) * q + c4) * q + c5) * q + c6) / ((((d1 * q + d2) * q + d3) * q + d4) * q + 1.0);
            return x;
        }
        return x;
    }

    public String toString() {
        String text = "";
        text = text + "Normal distribution. Mean: " + this.mean + " Sigma: " + this.sigma;
        return text;
    }
}

