/*
 * Decompiled with CFR 0.152.
 */
package javanpst.data.readers.distributionReaders;

import java.util.Arrays;
import javanpst.distributions.tests.KendallDistribution;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class KendallExactReaderFormat
extends DefaultHandler {
    int n;
    int newN;
    int counter = 0;
    double[] probs = new double[25];
    double[] keys = new double[25];
    String st;

    public KendallExactReaderFormat() {
        this.clearTable();
    }

    @Override
    public void startDocument() throws SAXException {
        Arrays.fill(this.probs, -1.0);
        Arrays.fill(this.keys, -1.0);
        this.n = 3;
    }

    @Override
    public void endDocument() throws SAXException {
        this.addRow();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equals("element")) {
            this.newN = Integer.parseInt(attributes.getValue("n"));
            if (this.newN != this.n) {
                this.addRow();
                this.counter = 0;
                Arrays.fill(this.probs, -1.0);
                Arrays.fill(this.keys, -1.0);
                this.n = this.newN;
            }
            this.keys[this.counter] = Double.parseDouble(attributes.getValue("T"));
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.st = new String(buf, offset, len);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.equals("element")) {
            this.probs[this.counter] = Double.parseDouble(this.st);
            ++this.counter;
        }
    }

    private void clearTable() {
        KendallDistribution.getExactTable().clear();
    }

    private void addRow() {
        KendallDistribution.getExactTable().addRow(this.n, this.keys, this.probs);
    }
}

