/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.tdouble;

import edu.emory.mathcs.jplasma.Barrier;
import edu.emory.mathcs.jplasma.tdouble.Dallocate;
import edu.emory.mathcs.jplasma.tdouble.Dauxiliary;
import edu.emory.mathcs.jplasma.tdouble.Dcommon;
import edu.emory.mathcs.jplasma.tdouble.DcoreControl;
import edu.emory.mathcs.jplasma.tdouble.Dglobal;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;

class Dinitialize {
    private Dinitialize() {
    }

    protected static int plasma_Init(int M, int N, int NRHS) {
        if (Dcommon.plasma_cntrl != null && Dcommon.plasma_cntrl.initialized) {
            Dauxiliary.plasma_warning("plasma_init", "PLASMA re-initialized");
            return -2;
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1024) {
            Dauxiliary.plasma_error("plasma_init", "not supporting so many cores");
            return -7;
        }
        Dcommon.plasma_cntrl = new Dglobal.Dplasma_cntrl(nthreads);
        Dcommon.plasma_aux = new Dglobal.Dplasma_aux(nthreads);
        Dcommon.plasma_args = new Dglobal.Plasma_args();
        Dcommon.plasma_cntrl.cores_max = nthreads;
        Dcommon.plasma_cntrl.cores_num = nthreads;
        int status = Dallocate.plasma_alloc_aux_work_tau();
        if (status != 0) {
            Dauxiliary.plasma_error("plasma_init", "plasma_alloc_work_tau() failed");
            return status;
        }
        int NB = Dcommon.plasma_cntrl.NB_min;
        int MT = M % NB == 0 ? M / NB : M / NB + 1;
        int NT = N % NB == 0 ? N / NB : N / NB + 1;
        int NTRHS = NRHS % NB == 0 ? NRHS / NB : NRHS / NB + 1;
        int size_elems = Math.max(MT, NT) * Math.max(NT, NTRHS);
        do {
            if ((status = Dallocate.plasma_alloc_aux_progress(size_elems)) == 0 || (size_elems = size_elems / 4 * 3) != 0) continue;
            Dauxiliary.plasma_error("plasma_init", "plasma_alloc_aux_progress() failed");
            return -6;
        } while (status != 0);
        NB = Dcommon.plasma_cntrl.NB_max;
        int IB = Dcommon.plasma_cntrl.IB_max;
        MT = M % NB == 0 ? M / NB : M / NB + 1;
        NT = N % NB == 0 ? N / NB : N / NB + 1;
        NTRHS = NRHS % NB == 0 ? NRHS / NB : NRHS / NB + 1;
        size_elems = (MT * NT + MT * NTRHS) * NB * NB + MT * NT * IB * NB;
        do {
            if ((status = Dallocate.plasma_alloc_aux_bdl(size_elems)) == 0 || (size_elems = size_elems / 4 * 3) != 0) continue;
            Dauxiliary.plasma_error("plasma_init", "plasma_alloc_aux_bld() failed");
            return -6;
        } while (status != 0);
        Barrier.plasma_barrier_init(Dcommon.plasma_cntrl.cores_num - 1);
        int cores_num = Dcommon.plasma_cntrl.cores_num;
        int[] core_num = Dcommon.plasma_cntrl.core_num;
        Future<?>[] workers = Dcommon.plasma_cntrl.workers;
        for (int core = 1; core < cores_num; ++core) {
            core_num[core] = core;
            workers[core] = ConcurrencyUtils.submit(new DcoreControl(core));
        }
        core_num[0] = 0;
        Barrier.plasma_barrier(0, cores_num);
        Dcommon.plasma_cntrl.initialized = true;
        return 0;
    }

    protected static int plasma_Finalize() {
        if (!Dcommon.plasma_cntrl.initialized) {
            Dauxiliary.plasma_warning("plasma_finalize", "PLASMA not initialized");
            return -1;
        }
        Lock lock = Dcommon.plasma_cntrl.action_mutex;
        lock.lock();
        try {
            Dcommon.plasma_cntrl.action = 1;
            Dcommon.plasma_cntrl.action_condt.signalAll();
        }
        finally {
            lock.unlock();
        }
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        int status = Dallocate.plasma_free_aux_bdl();
        if (status != 0) {
            Dauxiliary.plasma_error("plasma_finalize", "plasma_free_aux_bdl() failed");
        }
        if ((status = Dallocate.plasma_free_aux_progress()) != 0) {
            Dauxiliary.plasma_error("plasma_finalize", "plasma_free_aux_progress() failed");
        }
        if ((status = Dallocate.plasma_free_aux_work_tau()) != 0) {
            Dauxiliary.plasma_error("plasma_finalize", "plasma_free_aux_work_tau() failed");
        }
        Dcommon.plasma_cntrl.initialized = false;
        return 0;
    }
}

