/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.benchmark;

import edu.emory.mathcs.jplasma.tdouble.Dplasma;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import org.netlib.lapack.Dgesv;
import org.netlib.util.intW;

public class DgesvBenchmark {
    private static void dgesvBenchmarkJPlasma(int N, int NRHS, int NITERS, int NTHREADS) {
        ConcurrencyUtils.setNumberOfThreads(NTHREADS);
        int LDA = N;
        int LDB = N;
        double[] A = new double[N * N];
        double[] B = new double[N * NRHS];
        double avtime = 0.0;
        Dplasma.plasma_Init(N, N, 1);
        for (int k = 0; k < NITERS + 2; ++k) {
            int j;
            int i;
            for (i = 0; i < N; ++i) {
                for (j = 0; j < N; ++j) {
                    A[LDA * j + i] = 0.5 - Math.random();
                }
            }
            for (i = 0; i < N; ++i) {
                for (j = 0; j < NRHS; ++j) {
                    B[N * j + i] = Math.random();
                }
            }
            double[] L = Dplasma.plasma_Allocate_L(N, N);
            int[] IPIV = Dplasma.plasma_Allocate_IPIV(N, N);
            double temp = System.nanoTime();
            int info = Dplasma.plasma_DGESV(N, NRHS, A, 0, LDA, L, 0, IPIV, 0, B, 0, LDB);
            temp = (double)System.nanoTime() - temp;
            if (k >= 2) {
                avtime += temp;
            }
            if (info == 0) continue;
            System.err.println("failure with error " + info);
        }
        System.out.println("Average execution time of JPlasma DGESV (" + N + "x" + N + ", " + NRHS + " right-hand sides, " + NTHREADS + " threads): " + avtime / (double)NITERS / 1000000.0 + " milliseconds");
        Dplasma.plasma_Finalize();
    }

    private static void dgesvBenchmarkJLAPACK(int N, int NRHS, int NITERS) {
        int LDA = N;
        int LDB = N;
        double[] A = new double[N * N];
        double[] B = new double[N * NRHS];
        double avtime = 0.0;
        Dplasma.plasma_Init(N, N, 1);
        for (int k = 0; k < NITERS + 2; ++k) {
            int j;
            int i;
            for (i = 0; i < N; ++i) {
                for (j = 0; j < N; ++j) {
                    A[LDA * j + i] = 0.5 - Math.random();
                }
            }
            for (i = 0; i < N; ++i) {
                for (j = 0; j < NRHS; ++j) {
                    B[N * j + i] = Math.random();
                }
            }
            int[] IPIV = new int[N];
            intW info = new intW(0);
            double temp = System.nanoTime();
            Dgesv.dgesv((int)N, (int)NRHS, (double[])A, (int)0, (int)LDA, (int[])IPIV, (int)0, (double[])B, (int)0, (int)LDB, (intW)info);
            temp = (double)System.nanoTime() - temp;
            if (k >= 2) {
                avtime += temp;
            }
            if (info.val == 0) continue;
            System.err.println("failure with error " + info);
        }
        System.out.println("Average execution time of JLAPACK DGESV (" + N + "x" + N + ", " + NRHS + " right-hand sides: " + avtime / (double)NITERS / 1000000.0 + " milliseconds");
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            System.out.println("Usage: java edu.emory.mathcs.jplasma.benchmark.DgesvBenchmark N NRHS NITERS NTHREADS");
            System.exit(1);
        }
        int N = Integer.parseInt(args[0]);
        int NRHS = Integer.parseInt(args[1]);
        int NITERS = Integer.parseInt(args[2]);
        int NTHREADS = Integer.parseInt(args[3]);
        DgesvBenchmark.dgesvBenchmarkJPlasma(N, NRHS, NITERS, NTHREADS);
        System.exit(0);
    }
}

