/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.Table;
import com.google.common.collect.TreeMultiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaProperty;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.SerCategory;
import org.joda.beans.ser.SerIterable;
import org.joda.beans.ser.SerIterator;
import org.joda.beans.ser.SerIteratorFactory;

public class GuavaSerIteratorFactory
extends SerIteratorFactory {
    @Override
    public SerIterator create(Object value, MetaProperty<?> prop, Class<?> beanClass) {
        Class<?> declaredType = prop.propertyType();
        if (value instanceof BiMap) {
            Class<?> keyType = JodaBeanUtils.mapKeyType(prop, beanClass);
            Class<?> valueType = JodaBeanUtils.mapValueType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.mapValueTypeTypes(prop, beanClass);
            return GuavaSerIteratorFactory.biMap((BiMap)value, declaredType, keyType, valueType, valueTypeTypes);
        }
        if (value instanceof Multiset) {
            Class<?> valueType = JodaBeanUtils.collectionType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.collectionTypeTypes(prop, beanClass);
            return GuavaSerIteratorFactory.multiset((Multiset)value, declaredType, valueType, valueTypeTypes);
        }
        if (value instanceof Multimap) {
            Class<?> keyType = JodaBeanUtils.mapKeyType(prop, beanClass);
            Class<?> valueType = JodaBeanUtils.mapValueType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.mapValueTypeTypes(prop, beanClass);
            return GuavaSerIteratorFactory.multimap((Multimap)value, declaredType, keyType, valueType, valueTypeTypes);
        }
        if (value instanceof Table) {
            Class<?> rowType = JodaBeanUtils.extractTypeClass(prop, beanClass, 3, 0);
            Class<?> colType = JodaBeanUtils.extractTypeClass(prop, beanClass, 3, 1);
            Class<?> valueType = JodaBeanUtils.extractTypeClass(prop, beanClass, 3, 2);
            return GuavaSerIteratorFactory.table((Table)value, declaredType, rowType, colType, valueType, EMPTY_VALUE_TYPES);
        }
        return super.create(value, prop, beanClass);
    }

    @Override
    public SerIterator createChild(Object value, SerIterator parent) {
        Class<?> declaredType = parent.valueType();
        List<Class<?>> childGenericTypes = parent.valueTypeTypes();
        if (value instanceof BiMap) {
            if (childGenericTypes.size() == 2) {
                return GuavaSerIteratorFactory.biMap((BiMap)value, declaredType, childGenericTypes.get(0), childGenericTypes.get(1), EMPTY_VALUE_TYPES);
            }
            return GuavaSerIteratorFactory.biMap((BiMap)value, Object.class, Object.class, Object.class, EMPTY_VALUE_TYPES);
        }
        if (value instanceof Multimap) {
            if (childGenericTypes.size() == 2) {
                return GuavaSerIteratorFactory.multimap((Multimap)value, declaredType, childGenericTypes.get(0), childGenericTypes.get(1), EMPTY_VALUE_TYPES);
            }
            return GuavaSerIteratorFactory.multimap((Multimap)value, Object.class, Object.class, Object.class, EMPTY_VALUE_TYPES);
        }
        if (value instanceof Multiset) {
            if (childGenericTypes.size() == 1) {
                return GuavaSerIteratorFactory.multiset((Multiset)value, declaredType, childGenericTypes.get(0), EMPTY_VALUE_TYPES);
            }
            return GuavaSerIteratorFactory.multiset((Multiset)value, Object.class, Object.class, EMPTY_VALUE_TYPES);
        }
        if (value instanceof Table) {
            if (childGenericTypes.size() == 3) {
                return GuavaSerIteratorFactory.table((Table)value, declaredType, childGenericTypes.get(0), childGenericTypes.get(1), childGenericTypes.get(2), EMPTY_VALUE_TYPES);
            }
            return GuavaSerIteratorFactory.table((Table)value, Object.class, Object.class, Object.class, Object.class, EMPTY_VALUE_TYPES);
        }
        return super.createChild(value, parent);
    }

    @Override
    public SerIterable createIterable(String metaTypeDescription, JodaBeanSer settings, Map<String, Class<?>> knownTypes) {
        if (metaTypeDescription.equals("BiMap")) {
            return GuavaSerIteratorFactory.biMap(Object.class, Object.class, EMPTY_VALUE_TYPES);
        }
        if (metaTypeDescription.equals("SetMultimap")) {
            return GuavaSerIteratorFactory.setMultimap(Object.class, Object.class, EMPTY_VALUE_TYPES);
        }
        if (metaTypeDescription.equals("ListMultimap")) {
            return GuavaSerIteratorFactory.listMultimap(Object.class, Object.class, EMPTY_VALUE_TYPES);
        }
        if (metaTypeDescription.equals("Multimap")) {
            return GuavaSerIteratorFactory.listMultimap(Object.class, Object.class, EMPTY_VALUE_TYPES);
        }
        if (metaTypeDescription.equals("Multiset")) {
            return GuavaSerIteratorFactory.multiset(Object.class, EMPTY_VALUE_TYPES);
        }
        if (metaTypeDescription.equals("Table")) {
            return GuavaSerIteratorFactory.table(Object.class, Object.class, Object.class, EMPTY_VALUE_TYPES);
        }
        return super.createIterable(metaTypeDescription, settings, knownTypes);
    }

    @Override
    public SerIterable createIterable(MetaProperty<?> prop, Class<?> beanClass) {
        if (BiMap.class.isAssignableFrom(prop.propertyType())) {
            Class<?> keyType = this.defaultToObjectClass(JodaBeanUtils.mapKeyType(prop, beanClass));
            Class<?> valueType = this.defaultToObjectClass(JodaBeanUtils.mapValueType(prop, beanClass));
            List<Class<?>> valueTypeTypes = JodaBeanUtils.mapValueTypeTypes(prop, beanClass);
            return GuavaSerIteratorFactory.biMap(keyType, valueType, valueTypeTypes);
        }
        if (SortedMultiset.class.isAssignableFrom(prop.propertyType())) {
            Class<?> valueType = this.defaultToObjectClass(JodaBeanUtils.collectionType(prop, beanClass));
            List<Class<?>> valueTypeTypes = JodaBeanUtils.collectionTypeTypes(prop, beanClass);
            return GuavaSerIteratorFactory.sortedMultiset(valueType, valueTypeTypes);
        }
        if (Multiset.class.isAssignableFrom(prop.propertyType())) {
            Class<?> valueType = this.defaultToObjectClass(JodaBeanUtils.collectionType(prop, beanClass));
            List<Class<?>> valueTypeTypes = JodaBeanUtils.collectionTypeTypes(prop, beanClass);
            return GuavaSerIteratorFactory.multiset(valueType, valueTypeTypes);
        }
        if (SetMultimap.class.isAssignableFrom(prop.propertyType())) {
            Class<?> keyType = this.defaultToObjectClass(JodaBeanUtils.mapKeyType(prop, beanClass));
            Class<?> valueType = this.defaultToObjectClass(JodaBeanUtils.mapValueType(prop, beanClass));
            List<Class<?>> valueTypeTypes = JodaBeanUtils.mapValueTypeTypes(prop, beanClass);
            return GuavaSerIteratorFactory.setMultimap(keyType, valueType, valueTypeTypes);
        }
        if (ListMultimap.class.isAssignableFrom(prop.propertyType())) {
            Class<?> keyType = this.defaultToObjectClass(JodaBeanUtils.mapKeyType(prop, beanClass));
            Class<?> valueType = this.defaultToObjectClass(JodaBeanUtils.mapValueType(prop, beanClass));
            List<Class<?>> valueTypeTypes = JodaBeanUtils.mapValueTypeTypes(prop, beanClass);
            return GuavaSerIteratorFactory.listMultimap(keyType, valueType, valueTypeTypes);
        }
        if (Multimap.class.isAssignableFrom(prop.propertyType())) {
            Class<?> keyType = this.defaultToObjectClass(JodaBeanUtils.mapKeyType(prop, beanClass));
            Class<?> valueType = this.defaultToObjectClass(JodaBeanUtils.mapValueType(prop, beanClass));
            List<Class<?>> valueTypeTypes = JodaBeanUtils.mapValueTypeTypes(prop, beanClass);
            return GuavaSerIteratorFactory.listMultimap(keyType, valueType, valueTypeTypes);
        }
        if (Table.class.isAssignableFrom(prop.propertyType())) {
            Class<?> rowType = this.defaultToObjectClass(JodaBeanUtils.extractTypeClass(prop, beanClass, 3, 0));
            Class<?> colType = this.defaultToObjectClass(JodaBeanUtils.extractTypeClass(prop, beanClass, 3, 1));
            Class<?> valueType = this.defaultToObjectClass(JodaBeanUtils.extractTypeClass(prop, beanClass, 3, 2));
            return GuavaSerIteratorFactory.table(rowType, colType, valueType, EMPTY_VALUE_TYPES);
        }
        if (ImmutableList.class.isAssignableFrom(prop.propertyType())) {
            Class<?> valueType = JodaBeanUtils.collectionType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.collectionTypeTypes(prop, beanClass);
            return GuavaSerIteratorFactory.immutableList(valueType, valueTypeTypes);
        }
        if (ImmutableSortedSet.class.isAssignableFrom(prop.propertyType())) {
            Class<?> valueType = JodaBeanUtils.collectionType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.collectionTypeTypes(prop, beanClass);
            return GuavaSerIteratorFactory.immutableSortedSet(valueType, valueTypeTypes);
        }
        if (ImmutableSet.class.isAssignableFrom(prop.propertyType())) {
            Class<?> valueType = JodaBeanUtils.collectionType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.collectionTypeTypes(prop, beanClass);
            return GuavaSerIteratorFactory.immutableSet(valueType, valueTypeTypes);
        }
        if (ImmutableMap.class.isAssignableFrom(prop.propertyType())) {
            Class<?> keyType = JodaBeanUtils.mapKeyType(prop, beanClass);
            Class<?> valueType = JodaBeanUtils.mapValueType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.mapValueTypeTypes(prop, beanClass);
            return GuavaSerIteratorFactory.immutableMap(keyType, valueType, valueTypeTypes);
        }
        return super.createIterable(prop, beanClass);
    }

    public static final SerIterable biMap(Class<?> keyType, Class<?> valueType, List<Class<?>> valueTypeTypes) {
        HashBiMap map = HashBiMap.create();
        return GuavaSerIteratorFactory.map(keyType, valueType, valueTypeTypes, (Map<Object, Object>)map);
    }

    public static final SerIterable multiset(Class<?> valueType, List<Class<?>> valueTypeTypes) {
        HashMultiset coll = HashMultiset.create();
        return GuavaSerIteratorFactory.multiset(valueType, valueTypeTypes, (Multiset<Object>)coll);
    }

    public static final SerIterable sortedMultiset(Class<?> valueType, List<Class<?>> valueTypeTypes) {
        Ordering natural = Ordering.natural();
        TreeMultiset coll = TreeMultiset.create((Comparator)natural);
        return GuavaSerIteratorFactory.multiset(valueType, valueTypeTypes, (Multiset<Object>)coll);
    }

    private static SerIterable multiset(final Class<?> valueType, final List<Class<?>> valueTypeTypes, final Multiset<Object> coll) {
        return new SerIterable(){

            @Override
            public SerIterator iterator() {
                return GuavaSerIteratorFactory.multiset(coll, Object.class, valueType, valueTypeTypes);
            }

            @Override
            public void add(Object key, Object column, Object value, int count) {
                if (key != null) {
                    throw new IllegalArgumentException("Unexpected key");
                }
                coll.add(value, count);
            }

            @Override
            public Object build() {
                return coll;
            }

            @Override
            public SerCategory category() {
                return SerCategory.COUNTED;
            }

            @Override
            public Class<?> valueType() {
                return valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return valueTypeTypes;
            }
        };
    }

    public static final SerIterator multiset(final Multiset<?> multiset, final Class<?> declaredType, final Class<?> valueType, final List<Class<?>> valueTypeTypes) {
        return new SerIterator(){
            private final Iterator it;
            private Multiset.Entry current;
            {
                this.it = multiset.entrySet().iterator();
            }

            @Override
            public String metaTypeName() {
                return "Multiset";
            }

            @Override
            public boolean metaTypeRequired() {
                return !Multiset.class.isAssignableFrom(declaredType);
            }

            @Override
            public SerCategory category() {
                return SerCategory.COUNTED;
            }

            @Override
            public int size() {
                return multiset.entrySet().size();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public void next() {
                this.current = (Multiset.Entry)this.it.next();
            }

            @Override
            public int count() {
                return this.current.getCount();
            }

            @Override
            public Class<?> valueType() {
                return valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return valueTypeTypes;
            }

            @Override
            public Object value() {
                return this.current.getElement();
            }
        };
    }

    public static final SerIterable listMultimap(Class<?> keyType, Class<?> valueType, List<Class<?>> valueTypeTypes) {
        ArrayListMultimap map = ArrayListMultimap.create();
        return new SerIterable((ListMultimap)map, keyType, valueType, valueTypeTypes){
            final /* synthetic */ ListMultimap val$map;
            final /* synthetic */ Class val$keyType;
            final /* synthetic */ Class val$valueType;
            final /* synthetic */ List val$valueTypeTypes;
            {
                this.val$map = listMultimap;
                this.val$keyType = clazz;
                this.val$valueType = clazz2;
                this.val$valueTypeTypes = list;
            }

            @Override
            public SerIterator iterator() {
                return GuavaSerIteratorFactory.multimap(this.val$map, Object.class, this.val$keyType, this.val$valueType, this.val$valueTypeTypes);
            }

            @Override
            public void add(Object key, Object column, Object value, int count) {
                if (key == null) {
                    throw new IllegalArgumentException("Missing key");
                }
                if (count != 1) {
                    throw new IllegalArgumentException("Unexpected count");
                }
                this.val$map.put(key, value);
            }

            @Override
            public Object build() {
                return this.val$map;
            }

            @Override
            public SerCategory category() {
                return SerCategory.MAP;
            }

            @Override
            public Class<?> keyType() {
                return this.val$keyType;
            }

            @Override
            public Class<?> valueType() {
                return this.val$valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return this.val$valueTypeTypes;
            }
        };
    }

    public static final SerIterable setMultimap(Class<?> keyType, Class<?> valueType, List<Class<?>> valueTypeTypes) {
        HashMultimap map = HashMultimap.create();
        return new SerIterable((SetMultimap)map, keyType, valueType, valueTypeTypes){
            final /* synthetic */ SetMultimap val$map;
            final /* synthetic */ Class val$keyType;
            final /* synthetic */ Class val$valueType;
            final /* synthetic */ List val$valueTypeTypes;
            {
                this.val$map = setMultimap;
                this.val$keyType = clazz;
                this.val$valueType = clazz2;
                this.val$valueTypeTypes = list;
            }

            @Override
            public SerIterator iterator() {
                return GuavaSerIteratorFactory.multimap(this.val$map, Object.class, this.val$keyType, this.val$valueType, this.val$valueTypeTypes);
            }

            @Override
            public void add(Object key, Object column, Object value, int count) {
                if (key == null) {
                    throw new IllegalArgumentException("Missing key");
                }
                if (count != 1) {
                    throw new IllegalArgumentException("Unexpected count");
                }
                this.val$map.put(key, value);
            }

            @Override
            public Object build() {
                return this.val$map;
            }

            @Override
            public SerCategory category() {
                return SerCategory.MAP;
            }

            @Override
            public Class<?> keyType() {
                return this.val$keyType;
            }

            @Override
            public Class<?> valueType() {
                return this.val$valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return this.val$valueTypeTypes;
            }
        };
    }

    public static final SerIterator multimap(final Multimap<?, ?> map, final Class<?> declaredType, final Class<?> keyType, final Class<?> valueType, final List<Class<?>> valueTypeTypes) {
        return new SerIterator(){
            private final Iterator it;
            private Map.Entry current;
            {
                this.it = map.entries().iterator();
            }

            @Override
            public String metaTypeName() {
                if (map instanceof SetMultimap) {
                    return "SetMultimap";
                }
                if (map instanceof ListMultimap) {
                    return "ListMultimap";
                }
                return "Multimap";
            }

            @Override
            public boolean metaTypeRequired() {
                if (map instanceof SetMultimap) {
                    return !SetMultimap.class.isAssignableFrom(declaredType);
                }
                if (map instanceof ListMultimap) {
                    return !ListMultimap.class.isAssignableFrom(declaredType);
                }
                return !Multimap.class.isAssignableFrom(declaredType);
            }

            @Override
            public SerCategory category() {
                return SerCategory.MAP;
            }

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public void next() {
                this.current = (Map.Entry)this.it.next();
            }

            @Override
            public Class<?> keyType() {
                return keyType;
            }

            @Override
            public Object key() {
                return this.current.getKey();
            }

            @Override
            public Class<?> valueType() {
                return valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return valueTypeTypes;
            }

            @Override
            public Object value() {
                return this.current.getValue();
            }
        };
    }

    public static final SerIterable table(Class<?> rowType, Class<?> colType, Class<?> valueType, List<Class<?>> valueTypeTypes) {
        HashBasedTable table = HashBasedTable.create();
        return new SerIterable((Table)table, rowType, colType, valueType, valueTypeTypes){
            final /* synthetic */ Table val$table;
            final /* synthetic */ Class val$rowType;
            final /* synthetic */ Class val$colType;
            final /* synthetic */ Class val$valueType;
            final /* synthetic */ List val$valueTypeTypes;
            {
                this.val$table = table;
                this.val$rowType = clazz;
                this.val$colType = clazz2;
                this.val$valueType = clazz3;
                this.val$valueTypeTypes = list;
            }

            @Override
            public SerIterator iterator() {
                return GuavaSerIteratorFactory.table(this.val$table, Object.class, this.val$rowType, this.val$colType, this.val$valueType, this.val$valueTypeTypes);
            }

            @Override
            public void add(Object row, Object column, Object value, int count) {
                if (row == null) {
                    throw new IllegalArgumentException("Missing row");
                }
                if (column == null) {
                    throw new IllegalArgumentException("Missing column");
                }
                if (count != 1) {
                    throw new IllegalArgumentException("Unexpected count");
                }
                this.val$table.put(row, column, value);
            }

            @Override
            public Object build() {
                return this.val$table;
            }

            @Override
            public SerCategory category() {
                return SerCategory.TABLE;
            }

            @Override
            public Class<?> keyType() {
                return this.val$rowType;
            }

            @Override
            public Class<?> columnType() {
                return this.val$colType;
            }

            @Override
            public Class<?> valueType() {
                return this.val$valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return this.val$valueTypeTypes;
            }
        };
    }

    public static final SerIterator table(final Table<?, ?, ?> table, final Class<?> declaredType, final Class<?> rowType, final Class<?> colType, final Class<?> valueType, final List<Class<?>> valueTypeTypes) {
        return new SerIterator(){
            private final Iterator it;
            private Table.Cell current;
            {
                this.it = table.cellSet().iterator();
            }

            @Override
            public String metaTypeName() {
                return "Table";
            }

            @Override
            public boolean metaTypeRequired() {
                return !Table.class.isAssignableFrom(declaredType);
            }

            @Override
            public SerCategory category() {
                return SerCategory.TABLE;
            }

            @Override
            public int size() {
                return table.size();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public void next() {
                this.current = (Table.Cell)this.it.next();
            }

            @Override
            public Class<?> keyType() {
                return rowType;
            }

            @Override
            public Object key() {
                return this.current.getRowKey();
            }

            @Override
            public Class<?> columnType() {
                return colType;
            }

            @Override
            public Object column() {
                return this.current.getColumnKey();
            }

            @Override
            public Class<?> valueType() {
                return valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return valueTypeTypes;
            }

            @Override
            public Object value() {
                return this.current.getValue();
            }
        };
    }

    public static final SerIterator biMap(final BiMap<?, ?> map, final Class<?> declaredType, final Class<?> keyType, final Class<?> valueType, final List<Class<?>> valueTypeTypes) {
        return new SerIterator(){
            private final Iterator it;
            private Map.Entry current;
            {
                this.it = map.entrySet().iterator();
            }

            @Override
            public String metaTypeName() {
                return "BiMap";
            }

            @Override
            public boolean metaTypeRequired() {
                if ((declaredType == Map.class || declaredType == ImmutableMap.class) && map.size() < 2) {
                    return false;
                }
                return !BiMap.class.isAssignableFrom(declaredType);
            }

            @Override
            public SerCategory category() {
                return SerCategory.MAP;
            }

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public void next() {
                this.current = (Map.Entry)this.it.next();
            }

            @Override
            public Class<?> keyType() {
                return keyType;
            }

            @Override
            public Object key() {
                return this.current.getKey();
            }

            @Override
            public Class<?> valueType() {
                return valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return valueTypeTypes;
            }

            @Override
            public Object value() {
                return this.current.getValue();
            }
        };
    }

    public static final SerIterable immutableList(final Class<?> valueType, final List<Class<?>> valueTypeTypes) {
        final ArrayList coll = new ArrayList();
        return new SerIterable(){

            @Override
            public SerIterator iterator() {
                return SerIteratorFactory.collection(coll, Object.class, valueType, valueTypeTypes);
            }

            @Override
            public void add(Object key, Object column, Object value, int count) {
                if (key != null) {
                    throw new IllegalArgumentException("Unexpected key");
                }
                for (int i = 0; i < count; ++i) {
                    coll.add(value);
                }
            }

            @Override
            public Object build() {
                return ImmutableList.copyOf((Collection)coll);
            }

            @Override
            public Class<?> valueType() {
                return valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return valueTypeTypes;
            }
        };
    }

    public static final SerIterable immutableSortedSet(final Class<?> valueType, final List<Class<?>> valueTypeTypes) {
        final LinkedHashSet coll = new LinkedHashSet();
        return new SerIterable(){

            @Override
            public SerIterator iterator() {
                return SerIteratorFactory.collection(coll, Object.class, valueType, valueTypeTypes);
            }

            @Override
            public void add(Object key, Object column, Object value, int count) {
                if (key != null) {
                    throw new IllegalArgumentException("Unexpected key");
                }
                for (int i = 0; i < count; ++i) {
                    coll.add(value);
                }
            }

            @Override
            public Object build() {
                return ImmutableSortedSet.copyOf((Collection)coll);
            }

            @Override
            public Class<?> valueType() {
                return valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return valueTypeTypes;
            }
        };
    }

    public static final SerIterable immutableSet(final Class<?> valueType, final List<Class<?>> valueTypeTypes) {
        final LinkedHashSet coll = new LinkedHashSet();
        return new SerIterable(){

            @Override
            public SerIterator iterator() {
                return SerIteratorFactory.collection(coll, Object.class, valueType, valueTypeTypes);
            }

            @Override
            public void add(Object key, Object column, Object value, int count) {
                if (key != null) {
                    throw new IllegalArgumentException("Unexpected key");
                }
                for (int i = 0; i < count; ++i) {
                    coll.add(value);
                }
            }

            @Override
            public Object build() {
                return ImmutableSet.copyOf((Collection)coll);
            }

            @Override
            public Class<?> valueType() {
                return valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return valueTypeTypes;
            }
        };
    }

    static SerIterable immutableMap(final Class<?> keyType, final Class<?> valueType, final List<Class<?>> valueTypeTypes) {
        final LinkedHashMap map = new LinkedHashMap();
        return new SerIterable(){

            @Override
            public SerIterator iterator() {
                return SerIteratorFactory.map(map, Object.class, keyType, valueType, valueTypeTypes);
            }

            @Override
            public void add(Object key, Object column, Object value, int count) {
                if (key == null) {
                    throw new IllegalArgumentException("Missing key");
                }
                if (count != 1) {
                    throw new IllegalArgumentException("Unexpected count");
                }
                map.put(key, value);
            }

            @Override
            public Object build() {
                return ImmutableMap.copyOf((Map)map);
            }

            @Override
            public SerCategory category() {
                return SerCategory.MAP;
            }

            @Override
            public Class<?> keyType() {
                return keyType;
            }

            @Override
            public Class<?> valueType() {
                return valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return valueTypeTypes;
            }
        };
    }
}

