/*
 * Decompiled with CFR 0.152.
 */
package recunn.matrix;

import java.io.Serializable;
import java.util.Random;

public class Matrix
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int rows;
    public int cols;
    public double[] w;
    public double[] dw;
    public double[] stepCache;

    public String toString() {
        String result = "";
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                result = result + String.format("%.4f", this.getW(r, c)) + "\t";
            }
            result = result + "\n";
        }
        return result;
    }

    public Matrix clone() {
        Matrix result = new Matrix(this.rows, this.cols);
        for (int i = 0; i < this.w.length; ++i) {
            result.w[i] = this.w[i];
            result.dw[i] = this.dw[i];
            result.stepCache[i] = this.stepCache[i];
        }
        return result;
    }

    public void resetDw() {
        for (int i = 0; i < this.dw.length; ++i) {
            this.dw[i] = 0.0;
        }
    }

    public void resetStepCache() {
        for (int i = 0; i < this.stepCache.length; ++i) {
            this.stepCache[i] = 0.0;
        }
    }

    public static Matrix transpose(Matrix m) {
        Matrix result = new Matrix(m.cols, m.rows);
        for (int r = 0; r < m.rows; ++r) {
            for (int c = 0; c < m.cols; ++c) {
                result.setW(c, r, m.getW(r, c));
            }
        }
        return result;
    }

    public static Matrix rand(int rows, int cols, double initParamsStdDev, Random rng) {
        Matrix result = new Matrix(rows, cols);
        for (int i = 0; i < result.w.length; ++i) {
            result.w[i] = rng.nextGaussian() * initParamsStdDev;
        }
        return result;
    }

    public static Matrix ident(int dim) {
        Matrix result = new Matrix(dim, dim);
        for (int i = 0; i < dim; ++i) {
            result.setW(i, i, 1.0);
        }
        return result;
    }

    public static Matrix uniform(int rows, int cols, double s) {
        Matrix result = new Matrix(rows, cols);
        for (int i = 0; i < result.w.length; ++i) {
            result.w[i] = s;
        }
        return result;
    }

    public static Matrix ones(int rows, int cols) {
        return Matrix.uniform(rows, cols, 1.0);
    }

    public static Matrix negones(int rows, int cols) {
        return Matrix.uniform(rows, cols, -1.0);
    }

    public Matrix(int dim) {
        this.rows = dim;
        this.cols = 1;
        this.w = new double[this.rows * this.cols];
        this.dw = new double[this.rows * this.cols];
        this.stepCache = new double[this.rows * this.cols];
    }

    public Matrix(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.w = new double[rows * cols];
        this.dw = new double[rows * cols];
        this.stepCache = new double[rows * cols];
    }

    public Matrix(double[] vector) {
        this.rows = vector.length;
        this.cols = 1;
        this.w = vector;
        this.dw = new double[vector.length];
        this.stepCache = new double[vector.length];
    }

    private int index(int row, int col) {
        int ix = this.cols * row + col;
        return ix;
    }

    private double getW(int row, int col) {
        return this.w[this.index(row, col)];
    }

    private void setW(int row, int col, double val) {
        this.w[this.index((int)row, (int)col)] = val;
    }
}

