/*
 * Decompiled with CFR 0.152.
 */
package recunn.examples;

import java.util.Random;
import recunn.datasets.TextGeneration;
import recunn.datastructs.DataSet;
import recunn.model.NeuralNetwork;
import recunn.trainer.Trainer;
import recunn.util.NeuralNetworkHelper;

public class ExamplePaulGraham {
    public static void main(String[] args) throws Exception {
        String textSource = "PaulGraham";
        TextGeneration data = new TextGeneration("datasets/text/" + textSource + ".txt");
        String savePath = "saved_models/" + textSource + ".ser";
        boolean initFromSaved = true;
        boolean overwriteSaved = true;
        TextGeneration.reportSequenceLength = 100;
        TextGeneration.singleWordAutocorrect = false;
        int bottleneckSize = 10;
        int hiddenDimension = 200;
        int hiddenLayers = 1;
        double learningRate = 0.001;
        double initParamsStdDev = 0.08;
        Random rng = new Random();
        NeuralNetwork lstm = NeuralNetworkHelper.makeLstmWithInputBottleneck(data.inputDimension, bottleneckSize, hiddenDimension, hiddenLayers, data.outputDimension, ((DataSet)data).getModelOutputUnitToUse(), initParamsStdDev, rng);
        int reportEveryNthEpoch = 10;
        int trainingEpochs = 1000;
        Trainer.train(trainingEpochs, learningRate, lstm, data, reportEveryNthEpoch, initFromSaved, overwriteSaved, savePath, rng);
        System.out.println("done.");
    }
}

