/*
 * Decompiled with CFR 0.152.
 */
package recunn.examples;

import java.util.Random;
import recunn.datasets.TextGenerationUnbroken;
import recunn.datastructs.DataSet;
import recunn.model.NeuralNetwork;
import recunn.trainer.Trainer;
import recunn.util.NeuralNetworkHelper;

public class ExampleLilDicky {
    public static void main(String[] args) throws Exception {
        Random rng = new Random();
        int totalSequences = 2000;
        int sequenceMinLength = 10;
        int sequenceMaxLength = 100;
        String textSource = "LilDicky";
        TextGenerationUnbroken data = new TextGenerationUnbroken("datasets/text/" + textSource + ".txt", totalSequences, sequenceMinLength, sequenceMaxLength, rng);
        String savePath = "saved_models/" + textSource + ".ser";
        boolean initFromSaved = true;
        boolean overwriteSaved = true;
        TextGenerationUnbroken.reportSequenceLength = 500;
        int bottleneckSize = 10;
        int hiddenDimension = 200;
        int hiddenLayers = 1;
        double learningRate = 0.001;
        double initParamsStdDev = 0.08;
        NeuralNetwork lstm = NeuralNetworkHelper.makeLstmWithInputBottleneck(data.inputDimension, bottleneckSize, hiddenDimension, hiddenLayers, data.outputDimension, ((DataSet)data).getModelOutputUnitToUse(), initParamsStdDev, rng);
        int reportEveryNthEpoch = 10;
        int trainingEpochs = 1000;
        Trainer.train(trainingEpochs, learningRate, lstm, data, reportEveryNthEpoch, initFromSaved, overwriteSaved, savePath, rng);
        System.out.println("done.");
    }
}

