/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.worker.impl.povray;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.homedns.dade.jcgrid.WorkRequest;

public class POVWorkRequest
extends WorkRequest {
    private static final long serialVersionUID = 2L;
    private String iniFileName;
    private int width;
    private int height;
    private int startCol;
    private int endCol;
    private int startRow;
    private int endRow;
    private boolean animationEnabled;
    private int frame;

    public POVWorkRequest(String name, int id, String iniName, int w, int h, int sc, int ec, int sr, int er) {
        super(name, id);
        this.iniFileName = iniName;
        this.width = w;
        this.height = h;
        this.startCol = sc;
        this.endCol = ec;
        this.startRow = sr;
        this.endRow = er;
        this.animationEnabled = false;
        this.frame = 0;
    }

    public int fragmentPerFrame(int wStep, int hStep) {
        int col = this.endCol - this.startCol + 1;
        int row = this.endRow - this.startRow + 1;
        int wCount = col / wStep;
        if (col % wStep != 0) {
            ++wCount;
        }
        int hCount = row / hStep;
        if (row % hStep != 0) {
            ++hCount;
        }
        return wCount * hCount;
    }

    public POVWorkRequest[] split(int wStep, int hStep) {
        return this.split(0, wStep, hStep);
    }

    public POVWorkRequest[] split(int RIDBase, int wStep, int hStep) {
        int col = this.endCol - this.startCol + 1;
        int row = this.endRow - this.startRow + 1;
        int wCount = col / wStep;
        if (col % wStep != 0) {
            ++wCount;
        }
        int hCount = row / hStep;
        if (row % hStep != 0) {
            ++hCount;
        }
        int count = wCount * hCount;
        POVWorkRequest[] res = new POVWorkRequest[count];
        int i = 0;
        for (int h = 0; h < hCount; ++h) {
            int fh = h == hCount - 1 ? row - h * hStep - 1 : hStep - 1;
            for (int w = 0; w < wCount; ++w) {
                int fw = w == wCount - 1 ? col - w * wStep - 1 : wStep - 1;
                res[i] = new POVWorkRequest(super.getSessionName(), RIDBase + 1 + i, this.iniFileName, this.width, this.height, w * wStep + this.startCol, w * wStep + this.startCol + fw, h * hStep + this.startRow, h * hStep + this.startRow + fh);
                if (this.animationEnabled) {
                    res[i].setAnimationEnabled(true);
                    res[i].setFrame(this.frame);
                }
                ++i;
            }
        }
        return res;
    }

    public POVWorkRequest[] split(int startFrame, int endFrame, int wStep, int hStep) {
        return this.split(0, startFrame, endFrame, wStep, hStep);
    }

    public POVWorkRequest[] split(int RIDBase, int startFrame, int endFrame, int wStep, int hStep) {
        POVWorkRequest[] reqs;
        this.setAnimationEnabled(true);
        Vector<POVWorkRequest> v = new Vector<POVWorkRequest>();
        this.frame = startFrame;
        while (this.frame <= endFrame) {
            reqs = this.split(RIDBase, wStep, hStep);
            RIDBase += reqs.length;
            v.addAll(Arrays.asList(reqs));
            ++this.frame;
        }
        reqs = new POVWorkRequest[v.size()];
        int j = 0;
        Iterator i = v.iterator();
        while (i.hasNext()) {
            reqs[j++] = (POVWorkRequest)i.next();
        }
        return reqs;
    }

    public String getINIFileName() {
        return this.iniFileName;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getStartCol() {
        return this.startCol;
    }

    public int getEndCol() {
        return this.endCol;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public void setAnimationEnabled(boolean v) {
        this.animationEnabled = v;
    }

    public boolean isAnimationEnabled() {
        return this.animationEnabled;
    }

    public void setFrame(int f) {
        this.frame = f;
    }

    public int getFrame() {
        return this.frame;
    }
}

