/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.worker.impl.mandel;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.homedns.dade.jcgrid.worker.impl.mandel.MandelWorkRequest;
import org.homedns.dade.jcgrid.worker.impl.mandel.MandelWorkResult;

public class MandelRenderingFrame {
    public static final int COLOR_TABLE_TYPE_RED = 0;
    public static final int COLOR_TABLE_TYPE_MISC = 1;
    private BufferedImage renderingFrameBuffer;
    private Graphics2D renderingFrameBufferG2D;
    private int colorTableType = 0;
    private Color[] colorTable;

    public MandelRenderingFrame(int width, int height, int iter) {
        this.renderingFrameBuffer = new BufferedImage(width, height, 5);
        this.renderingFrameBufferG2D = this.renderingFrameBuffer.createGraphics();
        for (int y = 0; y < this.renderingFrameBuffer.getHeight(); y += 10) {
            for (int x = 0; x < this.renderingFrameBuffer.getWidth(); x += 10) {
                if ((x / 10 + y / 10) % 2 == 0) {
                    this.renderingFrameBufferG2D.setColor(Color.BLACK);
                } else {
                    this.renderingFrameBufferG2D.setColor(Color.WHITE);
                }
                this.renderingFrameBufferG2D.fillRect(x, y, 10, 10);
            }
        }
        this.setMaxIter(iter);
    }

    public BufferedImage getBufferedImage() {
        return this.renderingFrameBuffer;
    }

    public Graphics2D getGraphics2D() {
        return this.renderingFrameBufferG2D;
    }

    public void setColorTableType(int type) {
        this.colorTableType = type;
    }

    public void setMaxIter(int maxIter) {
        float db;
        float dg;
        float dr;
        float b;
        float g;
        float r;
        this.colorTable = new Color[maxIter];
        if (this.colorTableType == 1) {
            r = 1.0f;
            g = 0.0f;
            b = 0.0f;
            dr = 0.23f;
            dg = 0.37f;
            db = 0.41f;
        } else {
            r = 1.0f;
            g = 0.0f;
            b = 0.0f;
            dr = 0.11f;
            dg = 0.001f;
            db = 0.001f;
        }
        for (int i = 0; i < maxIter - 1; ++i) {
            this.colorTable[i] = new Color(r, g, b);
            r += dr;
            g += dg;
            b += db;
            if ((double)r > 1.0) {
                r = (float)((double)r - 1.0);
            }
            if ((double)g > 1.0) {
                g = (float)((double)g - 1.0);
            }
            if (!((double)b > 1.0)) continue;
            b = (float)((double)b - 1.0);
        }
        this.colorTable[maxIter - 1] = Color.BLACK;
    }

    public void addFragmentResult(MandelWorkRequest req, MandelWorkResult res, MandelRenderingFrame frame) {
        int height = this.renderingFrameBuffer.getHeight() - 1;
        for (int y = 0; y < req.getYStep(); ++y) {
            for (int x = 0; x < req.getXStep(); ++x) {
                this.renderingFrameBufferG2D.setColor(this.colorTable[res.getIter()[x][y] % this.colorTable.length]);
                this.renderingFrameBufferG2D.fillRect(x + req.getXOffset(), height - (y + req.getYOffset()), 1, 1);
            }
        }
    }
}

