/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.server;

import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.server.AdminHandlerThread;
import org.homedns.dade.jcgrid.server.ClientHandlerThread;
import org.homedns.dade.jcgrid.server.GridNodeServerConfig;
import org.homedns.dade.jcgrid.server.GridServer;
import org.homedns.dade.jcgrid.server.HandlerThread;
import org.homedns.dade.jcgrid.server.WorkerHandlerThread;

public class MainDemon
extends Thread {
    protected static final String className = MainDemon.class.getName();
    protected static Logger log = Logger.getLogger((String)className);
    protected static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    private GridServer gridServer;
    private ServerSocket socket;
    private String handlerType;
    static /* synthetic */ Class class$java$net$Socket;
    static /* synthetic */ Class class$org$homedns$dade$jcgrid$server$GridServer;

    public MainDemon(GridServer server, String type) throws Exception {
        int port;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start MainDemon(" + server + ")"));
        }
        this.gridServer = server;
        this.handlerType = type;
        if (this.handlerType.equals("CLIENT")) {
            port = this.gridServer.getNodeConfig().getGridConfig().getServerClientPort();
        } else if (this.handlerType.equals("WORKER")) {
            port = this.gridServer.getNodeConfig().getGridConfig().getServerWorkerPort();
        } else if (this.handlerType.equals("ADMIN")) {
            port = this.gridServer.getNodeConfig().getGridConfig().getServerAdminPort();
        } else {
            throw new Exception("Unknown handler type: " + this.handlerType);
        }
        if (server.getNodeConfig().getGridConfig().getUseSecureConnection()) {
            SSLServerSocketFactory sslSrvFact = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            this.socket = sslSrvFact.createServerSocket(port);
        } else {
            this.socket = new ServerSocket(port);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End MainDemon()");
        }
    }

    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start run()");
        }
        while (!this.isInterrupted()) {
            try {
                HandlerThread ht;
                long maxConn;
                int count;
                Socket hSocket = this.socket.accept();
                SocketAddress sa = hSocket.getRemoteSocketAddress();
                if (sa != null && sa instanceof InetSocketAddress) {
                    InetSocketAddress isa = (InetSocketAddress)sa;
                    log.warn((Object)("Connection from " + isa.getAddress() + ":" + isa.getPort()));
                } else {
                    log.warn((Object)"Connection from unknown");
                }
                if (this.handlerType.equals("CLIENT") && (long)(count = this.gridServer.getClientHandlers().getConnectedHandlerCount()) > (maxConn = (long)((GridNodeServerConfig)this.gridServer.getNodeConfig()).getMaxConnections())) {
                    log.warn((Object)"Too many connections");
                    break;
                }
                if (this.handlerType.equals("CLIENT")) {
                    Class registered = this.gridServer.getRegisteredClientHandler();
                    ht = registered == null ? new ClientHandlerThread(this.gridServer, hSocket) : (HandlerThread)registered.getConstructor(class$org$homedns$dade$jcgrid$server$GridServer == null ? MainDemon.class$("org.homedns.dade.jcgrid.server.GridServer") : class$org$homedns$dade$jcgrid$server$GridServer, class$java$net$Socket == null ? MainDemon.class$("java.net.Socket") : class$java$net$Socket).newInstance(this.gridServer, hSocket);
                } else if (this.handlerType.equals("WORKER")) {
                    ht = new WorkerHandlerThread(this.gridServer, hSocket);
                } else if (this.handlerType.equals("ADMIN")) {
                    ht = new AdminHandlerThread(this.gridServer, hSocket);
                } else {
                    throw new Exception("Unknown handler type: " + this.handlerType);
                }
                ht.start();
            }
            catch (Exception ex) {
                log.warn((Object)"Error in MainDemon.run()", (Throwable)ex);
                try {
                    MainDemon.sleep(500L);
                }
                catch (InterruptedException iex) {
                    break;
                }
            }
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End run()");
        }
    }
}

