/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.GridConfig;

public class guiJCGridConfig
extends JDialog {
    private static final String className = guiJCGridConfig.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    private static final long serialVersionUID = 1L;
    private GridConfig gridConfig;
    private JButton bApply;
    private JButton bDefaultAdminPort;
    private JButton bDefaultClientPort;
    private JButton bDefaultPwd;
    private JButton bDefaultUseCompression;
    private JButton bDefaultUseEnc;
    private JButton bDefaultWorkerPort;
    private JCheckBox cbUseCompression;
    private JCheckBox cbUseEnc;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JPanel pSettings;
    private JPasswordField pfPwd;
    private JTextField tAdminPort;
    private JTextField tClientPort;
    private JTextField tServerName;
    private JTextField tWorkerPort;

    public guiJCGridConfig(GridConfig cfg, Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.refreshConfig(cfg);
    }

    public void refreshConfig(GridConfig cfg) {
        this.gridConfig = cfg;
        this.tServerName.setText(this.gridConfig.getServerAddress());
        this.tClientPort.setText(Integer.toString(this.gridConfig.getServerClientPort()));
        this.tWorkerPort.setText(Integer.toString(this.gridConfig.getServerWorkerPort()));
        this.tAdminPort.setText(Integer.toString(this.gridConfig.getServerAdminPort()));
        this.cbUseCompression.setSelected(this.gridConfig.getUseCompression());
        this.cbUseEnc.setSelected(this.gridConfig.getUseSecureConnection());
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.jLabel10 = new JLabel();
        this.tServerName = new JTextField();
        this.jLabel11 = new JLabel();
        this.tClientPort = new JTextField();
        this.bDefaultClientPort = new JButton();
        this.jLabel12 = new JLabel();
        this.tWorkerPort = new JTextField();
        this.bDefaultWorkerPort = new JButton();
        this.jLabel13 = new JLabel();
        this.tAdminPort = new JTextField();
        this.bDefaultAdminPort = new JButton();
        this.jLabel14 = new JLabel();
        this.cbUseEnc = new JCheckBox();
        this.bDefaultUseEnc = new JButton();
        this.jLabel15 = new JLabel();
        this.cbUseCompression = new JCheckBox();
        this.bDefaultUseCompression = new JButton();
        this.jLabel16 = new JLabel();
        this.bDefaultPwd = new JButton();
        this.pfPwd = new JPasswordField();
        this.bApply = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("JCGrid Settings");
        this.setDefaultCloseOperation(0);
        this.pSettings.setLayout(new GridBagLayout());
        this.pSettings.setBorder(new TitledBorder("JCGrid Settings"));
        this.jLabel10.setHorizontalAlignment(4);
        this.jLabel10.setText("Host name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pSettings.add((Component)this.jLabel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pSettings.add((Component)this.tServerName, gridBagConstraints);
        this.jLabel11.setHorizontalAlignment(4);
        this.jLabel11.setText("Client port:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pSettings.add((Component)this.jLabel11, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pSettings.add((Component)this.tClientPort, gridBagConstraints);
        this.bDefaultClientPort.setText("Default");
        this.bDefaultClientPort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiJCGridConfig.this.bDefaultClientPortActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pSettings.add((Component)this.bDefaultClientPort, gridBagConstraints);
        this.jLabel12.setHorizontalAlignment(4);
        this.jLabel12.setText("Worker port:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pSettings.add((Component)this.jLabel12, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pSettings.add((Component)this.tWorkerPort, gridBagConstraints);
        this.bDefaultWorkerPort.setText("Default");
        this.bDefaultWorkerPort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiJCGridConfig.this.bDefaultWorkerPortActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pSettings.add((Component)this.bDefaultWorkerPort, gridBagConstraints);
        this.jLabel13.setHorizontalAlignment(4);
        this.jLabel13.setText("Admin port:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pSettings.add((Component)this.jLabel13, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pSettings.add((Component)this.tAdminPort, gridBagConstraints);
        this.bDefaultAdminPort.setText("Default");
        this.bDefaultAdminPort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiJCGridConfig.this.bDefaultAdminPortActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pSettings.add((Component)this.bDefaultAdminPort, gridBagConstraints);
        this.jLabel14.setHorizontalAlignment(4);
        this.jLabel14.setText("Enable encryption:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pSettings.add((Component)this.jLabel14, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pSettings.add((Component)this.cbUseEnc, gridBagConstraints);
        this.bDefaultUseEnc.setText("Default");
        this.bDefaultUseEnc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiJCGridConfig.this.bDefaultUseEncActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pSettings.add((Component)this.bDefaultUseEnc, gridBagConstraints);
        this.jLabel15.setHorizontalAlignment(4);
        this.jLabel15.setText("Enable compression:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pSettings.add((Component)this.jLabel15, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pSettings.add((Component)this.cbUseCompression, gridBagConstraints);
        this.bDefaultUseCompression.setText("Default");
        this.bDefaultUseCompression.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiJCGridConfig.this.bDefaultUseCompressionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pSettings.add((Component)this.bDefaultUseCompression, gridBagConstraints);
        this.jLabel16.setHorizontalAlignment(4);
        this.jLabel16.setText("Server password:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pSettings.add((Component)this.jLabel16, gridBagConstraints);
        this.bDefaultPwd.setText("Default");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pSettings.add((Component)this.bDefaultPwd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pSettings.add((Component)this.pfPwd, gridBagConstraints);
        this.bApply.setText("Apply");
        this.bApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiJCGridConfig.this.bApplyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pSettings.add((Component)this.bApply, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pSettings, gridBagConstraints);
        this.setBounds(10, 10, 400, 300);
    }

    private void bApplyActionPerformed(ActionEvent evt) {
        String hostName = this.tServerName.getText().trim();
        if (hostName.equals("")) {
            JOptionPane.showMessageDialog(this, "You have to set the JCGrid Server host name.", "Settings error", 0);
            return;
        }
        int clientPort = -1;
        try {
            clientPort = Integer.parseInt(this.tClientPort.getText());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Syntax error in the JCGrid Server port.", "Settings error", 0);
            return;
        }
        if (clientPort <= 1024) {
            JOptionPane.showMessageDialog(this, "JCGrid client port must be greater than 1024.", "Settings error", 0);
            return;
        }
        int workerPort = -1;
        try {
            workerPort = Integer.parseInt(this.tWorkerPort.getText());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Syntax error in the JCGrid worker port.", "Settings error", 0);
            return;
        }
        if (workerPort <= 1024) {
            JOptionPane.showMessageDialog(this, "JCGrid worker port must be greater than 1024.", "Settings error", 0);
            return;
        }
        int adminPort = -1;
        try {
            adminPort = Integer.parseInt(this.tAdminPort.getText());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Syntax error in the JCGrid admin. port.", "Settings error", 0);
            return;
        }
        if (adminPort <= 1024) {
            JOptionPane.showMessageDialog(this, "JCGrid admin. port must be greater than 1024.", "Settings error", 0);
            return;
        }
        boolean useComp = this.cbUseCompression.isSelected();
        boolean useEnc = this.cbUseEnc.isSelected();
        this.gridConfig.setServerAddress(hostName);
        this.gridConfig.setServerClientPort(clientPort);
        this.gridConfig.setServerWorkerPort(workerPort);
        this.gridConfig.setServerAdminPort(adminPort);
        this.gridConfig.setUseCompression(useComp);
        this.gridConfig.setUseSecureConnection(useEnc);
    }

    private void bDefaultUseCompressionActionPerformed(ActionEvent evt) {
        this.cbUseCompression.setSelected(false);
    }

    private void bDefaultUseEncActionPerformed(ActionEvent evt) {
        this.cbUseEnc.setSelected(false);
    }

    private void bDefaultAdminPortActionPerformed(ActionEvent evt) {
        this.tAdminPort.setText(Integer.toString(10103));
    }

    private void bDefaultWorkerPortActionPerformed(ActionEvent evt) {
        this.tWorkerPort.setText(Integer.toString(10102));
    }

    private void bDefaultClientPortActionPerformed(ActionEvent evt) {
        this.tClientPort.setText(Integer.toString(10101));
    }
}

