/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.GridStats;
import org.homedns.dade.jcgrid.WorkerStats;
import org.homedns.dade.jcgrid.admin.GridAdmin;
import org.homedns.dade.jcgrid.admin.GridNodeAdminConfig;

public class guiJCGridAdminStatus
extends JDialog {
    private static final String className = guiJCGridAdminStatus.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    private static final long serialVersionUID = 1L;
    private JTable tStats;
    private GridNodeAdminConfig adminConfig;
    private JButton bRefresh;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel lHostName;
    private JLabel lHostPort;
    private JLabel lPing;
    private JLabel lQueueSize;
    private JLabel lSessionName;
    private JLabel lWorkerCount;
    private JPanel pServer;
    private JPanel pWorkers;
    private JScrollPane sPane;
    static /* synthetic */ Class class$java$lang$Object;

    public guiJCGridAdminStatus(GridNodeAdminConfig cfg, Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.tStats = null;
        this.refreshInfo(cfg);
    }

    public void refreshInfo(GridNodeAdminConfig cfg) {
        try {
            this.adminConfig = cfg;
            this.lHostName.setText(this.adminConfig.getGridConfig().getServerAddress());
            this.lHostPort.setText(Integer.toString(this.adminConfig.getGridConfig().getServerAdminPort()));
            this.lSessionName.setText(this.adminConfig.getSessionName());
            GridAdmin ga = new GridAdmin();
            ga.setNodeConfig(this.adminConfig);
            ga.start();
            long pingTime = ga.ping();
            this.lPing.setText(pingTime + "ms");
            GridStats gs = ga.getGridStats();
            this.lWorkerCount.setText(Integer.toString(gs.getWorkerCount()));
            this.lQueueSize.setText(Integer.toString(gs.getWorkRequestsQueueSize()));
            Vector stats = ga.getWorkerStats();
            if (this.tStats != null) {
                this.sPane.remove(this.tStats);
            }
            if (stats != null) {
                WorkerStatsModel model = new WorkerStatsModel(stats);
                this.tStats = new JTable();
                this.tStats.setModel(model);
                this.sPane.setViewportView(this.tStats);
                TableColumn column = null;
                Component comp = null;
                int headerWidth = 0;
                int cellWidth = 0;
                TableCellRenderer headerRenderer = this.tStats.getTableHeader().getDefaultRenderer();
                for (int i = 0; i < model.getColumnCount(); ++i) {
                    column = this.tStats.getColumnModel().getColumn(i);
                    comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
                    headerWidth = comp.getPreferredSize().width;
                    if (model.getRowCount() > 0) {
                        comp = this.tStats.getDefaultRenderer(model.getColumnClass(i)).getTableCellRendererComponent(this.tStats, model.getValueAt(0, i), false, false, 0, i);
                        cellWidth = comp.getPreferredSize().width;
                    } else {
                        cellWidth = 0;
                    }
                    column.setPreferredWidth(Math.max(headerWidth, cellWidth));
                }
            }
            ga.stop();
            this.repaint();
        }
        catch (Exception ex) {
            log.warn((Object)"Error refreshing server information", (Throwable)ex);
            JOptionPane.showMessageDialog(this, "Error refreshing server information.", "Admin error", 0);
        }
    }

    private void initComponents() {
        this.pServer = new JPanel();
        this.jLabel10 = new JLabel();
        this.lHostName = new JLabel();
        this.jLabel11 = new JLabel();
        this.lHostPort = new JLabel();
        this.jLabel13 = new JLabel();
        this.lSessionName = new JLabel();
        this.jLabel12 = new JLabel();
        this.lPing = new JLabel();
        this.jLabel14 = new JLabel();
        this.lWorkerCount = new JLabel();
        this.jLabel15 = new JLabel();
        this.lQueueSize = new JLabel();
        this.pWorkers = new JPanel();
        this.sPane = new JScrollPane();
        this.bRefresh = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("JCGrid Server Status");
        this.setDefaultCloseOperation(2);
        this.pServer.setLayout(new GridBagLayout());
        this.pServer.setBorder(new TitledBorder("JCGrid Server"));
        this.jLabel10.setHorizontalAlignment(4);
        this.jLabel10.setText("Server host name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pServer.add((Component)this.jLabel10, gridBagConstraints);
        this.lHostName.setHorizontalAlignment(2);
        this.lHostName.setText("...");
        this.lHostName.setForeground(SystemColor.activeCaption);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pServer.add((Component)this.lHostName, gridBagConstraints);
        this.jLabel11.setHorizontalAlignment(4);
        this.jLabel11.setText("Admin. server port:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pServer.add((Component)this.jLabel11, gridBagConstraints);
        this.lHostPort.setHorizontalAlignment(2);
        this.lHostPort.setText("...");
        this.lHostPort.setForeground(SystemColor.activeCaption);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pServer.add((Component)this.lHostPort, gridBagConstraints);
        this.jLabel13.setHorizontalAlignment(4);
        this.jLabel13.setText("Admin. session name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pServer.add((Component)this.jLabel13, gridBagConstraints);
        this.lSessionName.setHorizontalAlignment(2);
        this.lSessionName.setText("...");
        this.lSessionName.setForeground(SystemColor.activeCaption);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pServer.add((Component)this.lSessionName, gridBagConstraints);
        this.jLabel12.setHorizontalAlignment(4);
        this.jLabel12.setText("Ping time:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pServer.add((Component)this.jLabel12, gridBagConstraints);
        this.lPing.setHorizontalAlignment(2);
        this.lPing.setText("...");
        this.lPing.setForeground(SystemColor.activeCaption);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pServer.add((Component)this.lPing, gridBagConstraints);
        this.jLabel14.setHorizontalAlignment(4);
        this.jLabel14.setText("Grid worker count:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pServer.add((Component)this.jLabel14, gridBagConstraints);
        this.lWorkerCount.setHorizontalAlignment(2);
        this.lWorkerCount.setText("...");
        this.lWorkerCount.setForeground(SystemColor.activeCaption);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pServer.add((Component)this.lWorkerCount, gridBagConstraints);
        this.jLabel15.setHorizontalAlignment(4);
        this.jLabel15.setText("Grid work request queue size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pServer.add((Component)this.jLabel15, gridBagConstraints);
        this.lQueueSize.setHorizontalAlignment(2);
        this.lQueueSize.setText("...");
        this.lQueueSize.setForeground(SystemColor.activeCaption);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pServer.add((Component)this.lQueueSize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.pServer, gridBagConstraints);
        this.pWorkers.setLayout(new GridBagLayout());
        this.pWorkers.setBorder(new TitledBorder("JCGrid Workers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pWorkers.add((Component)this.sPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pWorkers, gridBagConstraints);
        this.bRefresh.setText("Refresh");
        this.bRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiJCGridAdminStatus.this.bRefreshActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.bRefresh, gridBagConstraints);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 400) / 2, (screenSize.height - 300) / 2, 400, 300);
    }

    private void bRefreshActionPerformed(ActionEvent evt) {
        this.refreshInfo(this.adminConfig);
    }

    private class WorkerStatsModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private String[] columnNames = new String[]{"Node name", "Status", "Working for", "Work started", "Units done", "Unit/sec"};
        private Object[][] data;

        public WorkerStatsModel(Vector stats) {
            this.data = new Object[stats.size()][this.columnNames.length];
            int j = 0;
            Iterator i = stats.iterator();
            while (i.hasNext()) {
                WorkerStats ws = (WorkerStats)i.next();
                this.data[j][0] = ws.getName();
                if (ws.getStatus() == 1) {
                    this.data[j][1] = "Busy";
                    this.data[j][2] = ws.getWorkingFor();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                    this.data[j][3] = sdf.format(new Date(ws.getWorkingStarted()));
                } else {
                    this.data[j][1] = "Free";
                    this.data[j][2] = "";
                    this.data[j][3] = "";
                }
                this.data[j][4] = Long.toString(ws.getUnitDone());
                this.data[j][5] = Double.toString(ws.getUnitSec());
                ++j;
            }
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            if (this.data.length > 0) {
                return this.getValueAt(0, c).getClass();
            }
            return class$java$lang$Object == null ? (class$java$lang$Object = guiJCGridAdminStatus.class$("java.lang.Object")) : class$java$lang$Object;
        }
    }
}

