/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.cmd.povray;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.client.GridClient;
import org.homedns.dade.jcgrid.client.GridNodeClientConfig;
import org.homedns.dade.jcgrid.cmd.povray.guiPOVRenderingPannel;
import org.homedns.dade.jcgrid.worker.impl.povray.POVRenderingClient;
import org.homedns.dade.jcgrid.worker.impl.povray.POVRenderingClientFeedback;
import org.homedns.dade.jcgrid.worker.impl.povray.POVRenderingFrame;
import org.homedns.dade.jcgrid.worker.impl.povray.POVWorkRequest;
import org.homedns.dade.jcgrid.worker.impl.povray.POVWorkResult;

public class guiRenderingSetting
extends JDialog {
    private static final String className = guiRenderingSetting.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    private static final long serialVersionUID = 1L;
    private GridNodeClientConfig clientConfig;
    private guiPOVRenderingPannel pPic;
    private POVRenderingClient rendThread;
    private JButton bAutoSessionName;
    private JButton bClearImage;
    private JButton bDefaultFragSize;
    private JButton bDefaultImageSize;
    private JButton bDefaultStartEnd;
    private JButton bINIFile;
    private JButton bStartStop;
    private JButton bWorkDir;
    private JLabel jLabel1;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel lRenderTime;
    private JPanel pImage;
    private JPanel pRendering;
    private JPanel pScene;
    private JProgressBar pbStatus;
    private JTextField tEndX;
    private JTextField tEndY;
    private JTextField tFragmentSize;
    private JTextField tHeight;
    private JTextField tINIFile;
    private JTextField tSessionName;
    private JTextField tStartX;
    private JTextField tStartY;
    private JTextField tWidth;
    private JTextField tWorkDir;

    public guiRenderingSetting(GridNodeClientConfig cfg, Frame parent, boolean modal, guiPOVRenderingPannel rendPannel) {
        super(parent, modal);
        this.clientConfig = cfg;
        this.pPic = rendPannel;
        this.rendThread = null;
        this.initComponents();
    }

    public void saveSettings(String fileName) {
        try {
            Properties prop = this.clientConfig.toProperties();
            prop.put("povray.scene.sessionname", this.tSessionName.getText().trim());
            prop.put("povray.scene.workingdirectory", this.tWorkDir.getText().trim());
            prop.put("povray.scene.inifile", this.tINIFile.getText().trim());
            prop.put("povray.image.width", this.tWidth.getText().trim());
            prop.put("povray.image.height", this.tHeight.getText().trim());
            prop.put("povray.image.fragment", this.tFragmentSize.getText().trim());
            prop.put("povray.image.startcolumn", this.tStartX.getText().trim());
            prop.put("povray.image.endcolumn", this.tEndX.getText().trim());
            prop.put("povray.image.startrow", this.tStartY.getText().trim());
            prop.put("povray.image.endrow", this.tEndY.getText().trim());
            prop.store(new FileOutputStream(new File(fileName)), "JCGrid GUI Client Settings");
        }
        catch (Exception ex) {
            log.warn((Object)"Error while saving settings.", (Throwable)ex);
            JOptionPane.showMessageDialog(this, "Error while saving settings.", "IO error", 0);
        }
    }

    public GridNodeClientConfig loadSettings(String fileName) {
        try {
            Properties prop = new Properties();
            prop.load(new FileInputStream(new File(fileName)));
            this.clientConfig = new GridNodeClientConfig(prop);
            this.tSessionName.setText(prop.getProperty("povray.scene.sessionname", ""));
            this.tWorkDir.setText(prop.getProperty("povray.scene.workingdirectory", ""));
            this.tINIFile.setText(prop.getProperty("povray.scene.inifile", ""));
            this.tWidth.setText(prop.getProperty("povray.image.width", ""));
            this.tHeight.setText(prop.getProperty("povray.image.height", ""));
            this.tFragmentSize.setText(prop.getProperty("povray.image.fragment", ""));
            this.tStartX.setText(prop.getProperty("povray.image.startcolumn", ""));
            this.tEndX.setText(prop.getProperty("povray.image.endcolumn", ""));
            this.tStartY.setText(prop.getProperty("povray.image.startrow", ""));
            this.tEndY.setText(prop.getProperty("povray.image.endrow", ""));
        }
        catch (Exception ex) {
            log.warn((Object)"Error while loading settings.", (Throwable)ex);
            JOptionPane.showMessageDialog(this, "Error while loading settings.", "IO error", 0);
            return null;
        }
        return this.clientConfig;
    }

    public String getSessionName() {
        String sessionName = this.tSessionName.getText().trim();
        if (!sessionName.matches("[a-zA-Z0-9_]+")) {
            JOptionPane.showMessageDialog(this, "Syntax error in the session name.", "Settings error", 0);
            return null;
        }
        return sessionName;
    }

    private void initComponents() {
        this.pScene = new JPanel();
        this.jLabel9 = new JLabel();
        this.tSessionName = new JTextField();
        this.bAutoSessionName = new JButton();
        this.jLabel8 = new JLabel();
        this.tWorkDir = new JTextField();
        this.bWorkDir = new JButton();
        this.jLabel12 = new JLabel();
        this.tINIFile = new JTextField();
        this.bINIFile = new JButton();
        this.pImage = new JPanel();
        this.jLabel1 = new JLabel();
        this.tWidth = new JTextField();
        this.jLabel2 = new JLabel();
        this.tHeight = new JTextField();
        this.bDefaultImageSize = new JButton();
        this.jLabel3 = new JLabel();
        this.tFragmentSize = new JTextField();
        this.bDefaultFragSize = new JButton();
        this.jLabel4 = new JLabel();
        this.tStartX = new JTextField();
        this.jLabel5 = new JLabel();
        this.tEndX = new JTextField();
        this.jLabel6 = new JLabel();
        this.tStartY = new JTextField();
        this.jLabel7 = new JLabel();
        this.tEndY = new JTextField();
        this.bDefaultStartEnd = new JButton();
        this.bClearImage = new JButton();
        this.pRendering = new JPanel();
        this.bStartStop = new JButton();
        this.pbStatus = new JProgressBar();
        this.jLabel13 = new JLabel();
        this.lRenderTime = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Rendering settings");
        this.setDefaultCloseOperation(0);
        this.setName("dSetting");
        this.pScene.setLayout(new GridBagLayout());
        this.pScene.setBorder(new TitledBorder("Scene"));
        this.jLabel9.setHorizontalAlignment(4);
        this.jLabel9.setText("Session name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pScene.add((Component)this.jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pScene.add((Component)this.tSessionName, gridBagConstraints);
        this.bAutoSessionName.setText("Auto");
        this.bAutoSessionName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiRenderingSetting.this.bAutoSessionNameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pScene.add((Component)this.bAutoSessionName, gridBagConstraints);
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText("Working directory:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pScene.add((Component)this.jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pScene.add((Component)this.tWorkDir, gridBagConstraints);
        this.bWorkDir.setText("Select");
        this.bWorkDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiRenderingSetting.this.bWorkDirActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pScene.add((Component)this.bWorkDir, gridBagConstraints);
        this.jLabel12.setHorizontalAlignment(4);
        this.jLabel12.setText("INI file:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pScene.add((Component)this.jLabel12, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pScene.add((Component)this.tINIFile, gridBagConstraints);
        this.bINIFile.setText("Default");
        this.bINIFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiRenderingSetting.this.bINIFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pScene.add((Component)this.bINIFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pScene, gridBagConstraints);
        this.pImage.setLayout(new GridBagLayout());
        this.pImage.setBorder(new TitledBorder("Image"));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pImage.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pImage.add((Component)this.tWidth, gridBagConstraints);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Height:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pImage.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pImage.add((Component)this.tHeight, gridBagConstraints);
        this.bDefaultImageSize.setText("Default");
        this.bDefaultImageSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiRenderingSetting.this.bDefaultImageSizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pImage.add((Component)this.bDefaultImageSize, gridBagConstraints);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Fragment size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pImage.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pImage.add((Component)this.tFragmentSize, gridBagConstraints);
        this.bDefaultFragSize.setText("Default");
        this.bDefaultFragSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiRenderingSetting.this.bDefaultFragSizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pImage.add((Component)this.bDefaultFragSize, gridBagConstraints);
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Start column:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pImage.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pImage.add((Component)this.tStartX, gridBagConstraints);
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("End column:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pImage.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pImage.add((Component)this.tEndX, gridBagConstraints);
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText("Start row:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pImage.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pImage.add((Component)this.tStartY, gridBagConstraints);
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText("End row:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pImage.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pImage.add((Component)this.tEndY, gridBagConstraints);
        this.bDefaultStartEnd.setText("Default");
        this.bDefaultStartEnd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiRenderingSetting.this.bDefaultStartEndActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pImage.add((Component)this.bDefaultStartEnd, gridBagConstraints);
        this.bClearImage.setText("Clear image");
        this.bClearImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiRenderingSetting.this.bClearImageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pImage.add((Component)this.bClearImage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pImage, gridBagConstraints);
        this.pRendering.setLayout(new GridBagLayout());
        this.pRendering.setBorder(new TitledBorder("Rendering"));
        this.bStartStop.setText("Start rendering");
        this.bStartStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiRenderingSetting.this.bStartStopActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pRendering.add((Component)this.bStartStop, gridBagConstraints);
        this.pbStatus.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pRendering.add((Component)this.pbStatus, gridBagConstraints);
        this.jLabel13.setHorizontalAlignment(4);
        this.jLabel13.setText("Last rendering time:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pRendering.add((Component)this.jLabel13, gridBagConstraints);
        this.lRenderTime.setHorizontalAlignment(2);
        this.lRenderTime.setForeground(SystemColor.activeCaption);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pRendering.add((Component)this.lRenderTime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pRendering, gridBagConstraints);
        this.setBounds(50, 50, 400, 500);
    }

    private void bAutoSessionNameActionPerformed(ActionEvent evt) {
        this.clientConfig.autoSessioName();
        this.tSessionName.setText(this.clientConfig.getSessionName());
    }

    private void bDefaultFragSizeActionPerformed(ActionEvent evt) {
        this.tFragmentSize.setText("64");
    }

    private void bClearImageActionPerformed(ActionEvent evt) {
        this.pPic.clearImage();
    }

    private void bDefaultImageSizeActionPerformed(ActionEvent evt) {
        this.tWidth.setText(Integer.toString(this.pPic.getWidth()));
        this.tHeight.setText(Integer.toString(this.pPic.getHeight()));
    }

    private void bINIFileActionPerformed(ActionEvent evt) {
        this.tINIFile.setText("jcgrid.ini");
    }

    private void bDefaultStartEndActionPerformed(ActionEvent evt) {
        int width = -1;
        try {
            width = Integer.parseInt(this.tWidth.getText());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Syntax error in the image width.", "Settings error", 0);
            return;
        }
        if (width < 16 || width > 2048) {
            JOptionPane.showMessageDialog(this, "The image width must be between 16 and 2048.", "Settings error", 0);
            return;
        }
        int height = -1;
        try {
            height = Integer.parseInt(this.tHeight.getText());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Syntax error in the image height.", "Settings error", 0);
            return;
        }
        if (height < 16 || height > 2048) {
            JOptionPane.showMessageDialog(this, "The image height must be between 16 and 2048.", "Settings error", 0);
            return;
        }
        this.tStartX.setText("1");
        this.tStartY.setText("1");
        this.tEndX.setText(Integer.toString(width));
        this.tEndY.setText(Integer.toString(height));
    }

    private void bStartStopActionPerformed(ActionEvent evt) {
        if (this.rendThread == null) {
            String sessionName = this.getSessionName();
            if (sessionName == null) {
                return;
            }
            String workDir = this.tWorkDir.getText().trim();
            File fWorkDir = new File(workDir);
            if (!fWorkDir.exists()) {
                JOptionPane.showMessageDialog(this, "The working directory doesn't exists.", "Settings error", 0);
                return;
            }
            if (!fWorkDir.isDirectory()) {
                JOptionPane.showMessageDialog(this, "The working directory isn't a directory.", "Settings error", 0);
                return;
            }
            String iniFile = this.tINIFile.getText();
            try {
                File inif = new File(workDir + File.separator + iniFile);
                if (!inif.exists() || !inif.isFile()) {
                    JOptionPane.showMessageDialog(this, "The INI file doesn't exists or isn't a normal file.", "Settings error", 0);
                    return;
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "The INI file must be in the working directory.", "Settings error", 0);
                return;
            }
            int width = -1;
            try {
                width = Integer.parseInt(this.tWidth.getText());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Syntax error in the image width.", "Settings error", 0);
                return;
            }
            if (width < 16 || width > 2048) {
                JOptionPane.showMessageDialog(this, "The image width must be between 16 and 2048.", "Settings error", 0);
                return;
            }
            int height = -1;
            try {
                height = Integer.parseInt(this.tHeight.getText());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Syntax error in the image height.", "Settings error", 0);
                return;
            }
            if (height < 16 || height > 2048) {
                JOptionPane.showMessageDialog(this, "The image height must be between 16 and 2048.", "Settings error", 0);
                return;
            }
            int fragSize = -1;
            try {
                fragSize = Integer.parseInt(this.tFragmentSize.getText());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Syntax error in the fragment size.", "Settings error", 0);
                return;
            }
            if (fragSize < 8 || fragSize > width) {
                JOptionPane.showMessageDialog(this, "The image fragment size must be between 8 and " + width + ".", "Settings error", 0);
                return;
            }
            if (this.tStartX.getText().trim().equals("")) {
                this.tStartX.setText("1");
            }
            int startX = -1;
            try {
                startX = Integer.parseInt(this.tStartX.getText());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Syntax error in the start column.", "Settings error", 0);
                return;
            }
            if (startX < 1 || startX > width) {
                JOptionPane.showMessageDialog(this, "The image start column must be between 1 and " + width + ".", "Settings error", 0);
                return;
            }
            if (this.tEndX.getText().trim().equals("")) {
                this.tEndX.setText(Integer.toString(width));
            }
            int endX = -1;
            try {
                endX = Integer.parseInt(this.tEndX.getText());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Syntax error in the end column.", "Settings error", 0);
                return;
            }
            if (endX < startX + 8 || endX > width) {
                JOptionPane.showMessageDialog(this, "The image end column must be between " + (startX + 8) + " and " + width + ".", "Settings error", 0);
                return;
            }
            if (this.tStartY.getText().trim().equals("")) {
                this.tStartY.setText("1");
            }
            int startY = -1;
            try {
                startY = Integer.parseInt(this.tStartY.getText());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Syntax error in the start row.", "Settings error", 0);
                return;
            }
            if (startY < 1 || startY > height) {
                JOptionPane.showMessageDialog(this, "The image start row must be between 1 and " + height + ".", "Settings error", 0);
                return;
            }
            if (this.tEndY.getText().trim().equals("")) {
                this.tEndY.setText(Integer.toString(height));
            }
            int endY = -1;
            try {
                endY = Integer.parseInt(this.tEndY.getText());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Syntax error in the end row.", "Settings error", 0);
                return;
            }
            if (endX < startY + 8 || endY > height) {
                JOptionPane.showMessageDialog(this, "The image end row must be between " + (startY + 8) + " and " + height + ".", "Settings error", 0);
                return;
            }
            this.pPic.resizeImage(width, height);
            GridClient gc = new GridClient();
            gc.setNodeConfig(this.clientConfig);
            GridNodeClientConfig config = (GridNodeClientConfig)gc.getNodeConfig();
            try {
                config.setSessionName(sessionName);
                config.setWorkingDir(workDir);
                POVWorkRequest povwr = new POVWorkRequest(config.getSessionName(), 0, iniFile, width, height, startX - 1, endX - 1, startY - 1, endY - 1);
                this.rendThread = new POVRenderingClient(config, new RenderingThreadFeedback(), povwr, fragSize);
                this.rendThread.start();
            }
            catch (Exception ex) {
                log.warn((Object)"Error starting the rendering", (Throwable)ex);
                JOptionPane.showMessageDialog(this, "Error starting the rendering.", "Rendering error", 0);
                this.rendThread = null;
            }
        } else {
            try {
                this.rendThread.interrupt();
                this.rendThread.join();
            }
            catch (Exception ex) {
                log.warn((Object)"Error stopping the rendering", (Throwable)ex);
                JOptionPane.showMessageDialog(this, "Error stopping the rendering.", "Rendering error", 0);
                this.rendThread = null;
            }
        }
        if (this.rendThread == null) {
            this.bStartStop.setText("Start rendering");
        } else {
            this.bStartStop.setText("Stop rendering");
        }
    }

    private void bWorkDirActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        int res = chooser.showOpenDialog(this);
        if (res == 0) {
            this.tWorkDir.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private class RenderingThreadFeedback
    implements POVRenderingClientFeedback {
        public void error(String msg, Exception ex) {
            log.warn((Object)msg, (Throwable)ex);
            JOptionPane.showMessageDialog(guiRenderingSetting.this, msg, "Rendering error", 0);
        }

        public void receivedFragmentResult(POVWorkRequest req, POVWorkResult res, int idx, POVRenderingFrame frame) {
            guiRenderingSetting.this.pPic.updateImage(frame);
        }

        public void renderingBegin() {
            guiRenderingSetting.this.pbStatus.setValue(guiRenderingSetting.this.pbStatus.getMinimum());
        }

        public void renderingEnd() {
            guiRenderingSetting.this.rendThread = null;
            guiRenderingSetting.this.bStartStop.setText("Start rendering");
        }

        public void sendingFrgamentRequest(POVWorkRequest req) {
        }

        public void setProgressMaximum(int max) {
            guiRenderingSetting.this.pbStatus.setMaximum(max);
        }

        public void setProgressMinimum(int min) {
            guiRenderingSetting.this.pbStatus.setMinimum(min);
        }

        public void setProgressValue(int val) {
            guiRenderingSetting.this.pbStatus.setValue(val);
        }

        public void setRenderingTime(POVWorkRequest req, long msdt) {
            double dt = (double)msdt / 1000.0;
            double pixsec = (double)(req.getWidth() * req.getHeight()) / dt;
            DecimalFormat df = new DecimalFormat("0.00");
            if (dt > 0.0) {
                guiRenderingSetting.this.lRenderTime.setText(df.format(dt / 60.0) + " min (" + df.format(pixsec) + "pixel/sec)");
            } else {
                guiRenderingSetting.this.lRenderTime.setText("N/A");
            }
        }

        public void completeFrame(int idx, POVRenderingFrame frame) {
            guiRenderingSetting.this.pPic.updateImage(frame);
        }
    }
}

