/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.cmd.mandel;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.GridConfig;
import org.homedns.dade.jcgrid.GridNodeGenericConfig;
import org.homedns.dade.jcgrid.Version;
import org.homedns.dade.jcgrid.cmd.MainCmd;
import org.homedns.dade.jcgrid.worker.GridNodeWorkerConfig;
import org.homedns.dade.jcgrid.worker.GridWorker;
import org.homedns.dade.jcgrid.worker.impl.mandel.MandelWorker;

public class JCGridWorker {
    private static final String className = JCGridWorker.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));

    public static void main(String[] args) {
        try {
            int i;
            MainCmd.setUpLog4J("worker", true);
            log.warn((Object)"-----------------------------------------------");
            log.warn((Object)("-- JCGridWorker MandelGrid v" + Version.RELEASE));
            log.warn((Object)"-----------------------------------------------");
            GridNodeWorkerConfig config = new GridNodeWorkerConfig();
            GridConfig gc = config.getGridConfig();
            gc.setServerAddress("dade.homedns.org");
            gc.setServerClientPort(10201);
            gc.setServerWorkerPort(10202);
            gc.setServerAdminPort(10203);
            gc.setUseCompression(true);
            gc.setUseVFS(false);
            config.autoSessioName();
            Options options = new Options();
            try {
                CommandLine cmd = MainCmd.parseCommonOptions(options, config, args);
                if (cmd.getArgs().length > 0) {
                    throw new Exception("Unknown command line option");
                }
            }
            catch (Exception ex) {
                log.warn((Object)"Error while parsing command line", (Throwable)ex);
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("JCGridWorker", options);
                System.exit(0);
            }
            GridWorker[] gw = new GridWorker[config.getWorkerCount()];
            for (i = 0; i < config.getWorkerCount(); ++i) {
                gw[i] = new GridWorker();
                gw[i].setNodeConfig((GridNodeGenericConfig)config.clone());
                ((GridNodeGenericConfig)gw[i].getNodeConfig()).setSessionName(config.getSessionName() + "_" + i);
                ((GridNodeGenericConfig)gw[i].getNodeConfig()).setWorkingDir(config.getWorkingDir() + "_" + i);
                gw[i].setWorker(new MandelWorker());
                gw[i].start();
                log.warn((Object)("Running worker " + i + "..."));
            }
            for (i = 0; i < config.getWorkerCount(); ++i) {
                gw[i].waitShutdown();
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Error", (Throwable)ex);
            System.exit(0);
        }
    }
}

