/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.cmd.dummy;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.GridNodeGenericConfig;
import org.homedns.dade.jcgrid.Version;
import org.homedns.dade.jcgrid.client.GridClient;
import org.homedns.dade.jcgrid.cmd.MainCmd;
import org.homedns.dade.jcgrid.message.GridMessageWorkRequest;
import org.homedns.dade.jcgrid.message.GridMessageWorkResult;
import org.homedns.dade.jcgrid.worker.impl.dummy.DummyWorkRequest;
import org.homedns.dade.jcgrid.worker.impl.dummy.DummyWorkResult;

public class JCGridClient {
    private static final String className = JCGridClient.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    private static final int WORKREQUEST_COUNT = 100;

    public static void main(String[] args) {
        try {
            int i;
            MainCmd.setUpLog4J("client", true);
            log.warn((Object)"-----------------------------------------------");
            log.warn((Object)("-- JCGridClient Dummy v" + Version.RELEASE));
            log.warn((Object)"-----------------------------------------------");
            GridClient gc = new GridClient();
            Options options = new Options();
            try {
                CommandLine cmd = MainCmd.parseCommonOptions(options, gc.getNodeConfig(), args);
                if (cmd.getArgs().length > 0) {
                    throw new Exception("Unknown command line option");
                }
            }
            catch (Exception ex) {
                log.warn((Object)"Error while parsing command line", (Throwable)ex);
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("JCGridClient", options);
                System.exit(0);
            }
            gc.start();
            log.warn((Object)"Sending work requests...");
            boolean[] resultReceived = new boolean[100];
            DummyWorkRequest[] dwr = new DummyWorkRequest[100];
            for (i = 0; i < 100; ++i) {
                resultReceived[i] = false;
                dwr[i] = new DummyWorkRequest(((GridNodeGenericConfig)gc.getNodeConfig()).getSessionName(), i);
                gc.send(new GridMessageWorkRequest(dwr[i]));
            }
            log.warn((Object)"Receiving work results...");
            for (i = 0; i < 100; ++i) {
                GridMessageWorkResult gmwr = (GridMessageWorkResult)gc.recv(0);
                DummyWorkResult dwres = (DummyWorkResult)gmwr.getWorkResult();
                int id = dwres.getRID();
                resultReceived[id] = true;
                if (dwres.getNumber() == dwr[id].getNumber()) continue;
                log.warn((Object)("Message " + id + " match failed !"));
            }
            boolean res = true;
            for (int i2 = 0; i2 < 100; ++i2) {
                res = res && resultReceived[i2];
            }
            gc.stop();
            if (res) {
                log.warn((Object)"Test completed.");
            } else {
                log.warn((Object)"Test failed.");
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Error", (Throwable)ex);
            System.exit(0);
        }
    }
}

