/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.xml.sax;

import java.io.IOException;
import java.io.Writer;
import javolution37.javolution.lang.Reusable;
import javolution37.javolution.lang.Text;
import javolution37.javolution.util.FastTable;
import javolution37.javolution.xml.sax.Attributes;
import javolution37.javolution.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class WriterHandler
implements ContentHandler,
Reusable {
    private static final int BUFFER_LENGTH = 2048;
    private Writer _writer;
    private CharSequence _prolog = Text.EMPTY;
    private CharSequence _indent = Text.EMPTY;
    private FastTable _prefixMappings = new FastTable();
    private int _nesting = -1;
    private boolean _isTagOpen;
    private final char[] _buffer = new char[2048];
    private int _index;

    public WriterHandler setWriter(Writer writer) {
        this._writer = writer;
        return this;
    }

    public void setIndent(CharSequence indent) {
        this._indent = indent;
    }

    public void setProlog(CharSequence prolog) {
        this._prolog = prolog;
    }

    @Override
    public void reset() {
        this._writer = null;
        this._indent = Text.EMPTY;
        this._prolog = Text.EMPTY;
        this._prefixMappings.clear();
        this._nesting = -1;
        this._isTagOpen = false;
        this._index = 0;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
        if (this._writer == null) {
            throw new SAXException("Writer not set");
        }
        try {
            this.writeNoEscape(this._prolog);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.flushBuffer();
            this._writer.close();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startPrefixMapping(CharSequence prefix, CharSequence uri) throws SAXException {
        this._prefixMappings.addLast(prefix);
        this._prefixMappings.addLast(uri);
    }

    @Override
    public void endPrefixMapping(CharSequence prefix) throws SAXException {
    }

    @Override
    public void startElement(CharSequence uri, CharSequence localName, CharSequence qName, Attributes atts) throws SAXException {
        try {
            if (this._isTagOpen) {
                this.writeNoEscape(">\n");
                this._isTagOpen = false;
            }
            ++this._nesting;
            this.indent();
            this.writeNoEscape('<');
            this.writeNoEscape(qName);
            if (this._prefixMappings.size() > 0) {
                this.writeNamespaces();
            }
            int attsLength = atts.getLength();
            for (int i = 0; i < attsLength; ++i) {
                CharSequence attName = atts.getQName(i);
                CharSequence attValue = atts.getValue(i);
                this.writeNoEscape(' ');
                this.writeNoEscape(attName);
                this.writeNoEscape('=');
                this.writeNoEscape('\"');
                this.write(attValue);
                this.writeNoEscape('\"');
            }
            this._isTagOpen = true;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void indent() throws IOException {
        int length = this._indent.length();
        if (length > 0) {
            for (int i = 0; i < this._nesting; ++i) {
                this.writeNoEscape(this._indent);
            }
        }
    }

    private void writeNamespaces() throws IOException {
        int i = 0;
        int length = this._prefixMappings.size();
        while (i < length) {
            CharSequence prefix = (CharSequence)this._prefixMappings.get(i++);
            CharSequence prefixUri = (CharSequence)this._prefixMappings.get(i++);
            if (prefix.length() == 0) {
                this.writeNoEscape(" xmlns=\"");
                this.write(prefixUri);
                this.writeNoEscape('\"');
                continue;
            }
            this.writeNoEscape(" xmlns:");
            this.writeNoEscape(prefix);
            this.writeNoEscape('=');
            this.writeNoEscape('\"');
            this.write(prefixUri);
            this.writeNoEscape('\"');
        }
        this._prefixMappings.clear();
    }

    @Override
    public void endElement(CharSequence uri, CharSequence localName, CharSequence qName) throws SAXException {
        try {
            if (this._isTagOpen) {
                this.writeNoEscape("/>\n");
                this._isTagOpen = false;
            } else {
                this.indent();
                this.writeNoEscape('<');
                this.writeNoEscape('/');
                this.writeNoEscape(qName);
                this.writeNoEscape('>');
                this.writeNoEscape('\n');
            }
            --this._nesting;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (this._isTagOpen) {
                this.writeNoEscape('>');
                this._isTagOpen = false;
            }
            this.writeNoEscape("<![CDATA[");
            this.flushBuffer();
            this._writer.write(ch, start, length);
            this.writeNoEscape("]]>\n");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(CharSequence target, CharSequence data) throws SAXException {
    }

    @Override
    public void skippedEntity(CharSequence name) throws SAXException {
    }

    private void write(Object obj) throws IOException {
        if (obj instanceof String) {
            this.write((String)obj);
        } else {
            this.writeNonString((CharSequence)obj);
        }
    }

    private void write(String str) throws IOException {
        int length = str.length();
        int i = 0;
        block7: while (i < length) {
            char c;
            if ((c = str.charAt(i++)) >= '@' || c == ' ') {
                this._buffer[this._index] = c;
                if (++this._index != 2048) continue;
                this.flushBuffer();
                continue;
            }
            switch (c) {
                case '<': {
                    this.writeNoEscape("&lt;");
                    continue block7;
                }
                case '>': {
                    this.writeNoEscape("&gt;");
                    continue block7;
                }
                case '\'': {
                    this.writeNoEscape("&apos;");
                    continue block7;
                }
                case '\"': {
                    this.writeNoEscape("&quot;");
                    continue block7;
                }
                case '&': {
                    this.writeNoEscape("&amp;");
                    continue block7;
                }
            }
            if (c >= ' ') {
                this.writeNoEscape(c);
                continue;
            }
            this.writeNoEscape("&#");
            this.writeNoEscape((char)(48 + c / 10));
            this.writeNoEscape((char)(48 + c % 10));
            this.writeNoEscape(';');
        }
    }

    private void writeNonString(CharSequence csq) throws IOException {
        int length = csq.length();
        int i = 0;
        block7: while (i < length) {
            char c;
            if ((c = csq.charAt(i++)) >= '@' || c == ' ') {
                this._buffer[this._index] = c;
                if (++this._index != 2048) continue;
                this.flushBuffer();
                continue;
            }
            switch (c) {
                case '<': {
                    this.writeNoEscape("&lt;");
                    continue block7;
                }
                case '>': {
                    this.writeNoEscape("&gt;");
                    continue block7;
                }
                case '\'': {
                    this.writeNoEscape("&apos;");
                    continue block7;
                }
                case '\"': {
                    this.writeNoEscape("&quot;");
                    continue block7;
                }
                case '&': {
                    this.writeNoEscape("&amp;");
                    continue block7;
                }
            }
            if (c >= ' ') {
                this.writeNoEscape(c);
                continue;
            }
            this.writeNoEscape("&#");
            this.writeNoEscape((char)(48 + c / 10));
            this.writeNoEscape((char)(48 + c % 10));
            this.writeNoEscape(';');
        }
    }

    private void writeNoEscape(Object obj) throws IOException {
        if (obj instanceof String) {
            this.writeNoEscape((String)obj);
        } else {
            this.writeNoEscapeNonString((CharSequence)obj);
        }
    }

    private void writeNoEscape(String str) throws IOException {
        int i = 0;
        int n = str.length();
        while (i < n) {
            this._buffer[this._index] = str.charAt(i++);
            if (++this._index != 2048) continue;
            this.flushBuffer();
        }
    }

    private void writeNoEscapeNonString(CharSequence csq) throws IOException {
        int i = 0;
        int n = csq.length();
        while (i < n) {
            this._buffer[this._index] = csq.charAt(i++);
            if (++this._index != 2048) continue;
            this.flushBuffer();
        }
    }

    private final void writeNoEscape(char c) throws IOException {
        this._buffer[this._index] = c;
        if (++this._index == 2048) {
            this.flushBuffer();
        }
    }

    private void flushBuffer() throws IOException {
        this._writer.write(this._buffer, 0, this._index);
        this._index = 0;
    }
}

