/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.xml;

import java.io.IOException;
import java.io.OutputStream;
import javolution37.javolution.lang.Reusable;
import javolution37.javolution.xml.ObjectWriter;

public class XmlOutputStream<T>
extends OutputStream
implements Reusable {
    static final byte END_XML = -2;
    private OutputStream _outputStream;
    private final ObjectWriter<T> _objectWriter;
    private final OutputStreamProxy _outputStreamProxy = new OutputStreamProxy();

    public XmlOutputStream() {
        this(new ObjectWriter());
    }

    public XmlOutputStream(ObjectWriter<T> writer) {
        this._objectWriter = writer;
    }

    public XmlOutputStream setOutputStream(OutputStream out) {
        if (this._outputStream != null) {
            throw new IllegalStateException("Stream not closed or reset");
        }
        this._outputStream = out;
        return this;
    }

    public void writeObject(T obj) throws IOException {
        if (this._outputStream == null) {
            throw new IOException("Stream closed");
        }
        this._objectWriter.write(obj, this._outputStreamProxy);
        this._outputStream.write(-2);
        this._outputStream.flush();
    }

    @Override
    public void write(int b) throws IOException {
        if (this._outputStream == null) {
            throw new IOException("Stream closed");
        }
        this._outputStream.write(b);
    }

    @Override
    public void flush() throws IOException {
        if (this._outputStream == null) {
            throw new IOException("Stream closed");
        }
        this._outputStream.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this._outputStream == null) {
            throw new IOException("Stream closed");
        }
        this._outputStream.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this._outputStream != null) {
            this._outputStream.close();
            this.reset();
        }
    }

    @Override
    public void reset() {
        this._objectWriter.reset();
        this._outputStream = null;
    }

    private final class OutputStreamProxy
    extends OutputStream {
        private OutputStreamProxy() {
        }

        @Override
        public void flush() throws IOException {
            XmlOutputStream.this._outputStream.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            XmlOutputStream.this._outputStream.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            XmlOutputStream.this._outputStream.write(b);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

