/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.xml;

import java.io.IOException;
import java.util.NoSuchElementException;
import javolution37.javolution.lang.Text;
import javolution37.javolution.lang.TextBuilder;
import javolution37.javolution.lang.TypeFormat;
import javolution37.javolution.util.FastComparator;
import javolution37.javolution.util.FastList;
import javolution37.javolution.util.FastMap;
import javolution37.javolution.util.FastTable;
import javolution37.javolution.xml.CharacterData;
import javolution37.javolution.xml.FormatAttributes;
import javolution37.javolution.xml.ObjectWriter;
import javolution37.javolution.xml.XmlException;
import javolution37.javolution.xml.XmlFormat;
import javolution37.javolution.xml.pull.XmlPullParser;
import javolution37.javolution.xml.pull.XmlPullParserException;
import javolution37.javolution.xml.pull.XmlPullParserImpl;
import javolution37.javolution.xml.sax.Attributes;
import javolution37.javolution.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class XmlElement {
    ContentHandler _formatHandler;
    final XmlPullParserImpl _parser;
    private Object _object;
    private Class _objectClass;
    private boolean _isParserAtNext;
    private boolean _isClosure;
    final FormatAttributes _formatAttributes;
    private final TextBuilder _textBuilder = new TextBuilder();
    private CharSequence _elemName;
    final FastTable _packagePrefixes = new FastTable();
    boolean _areReferencesEnabled;
    boolean _expandReferences = false;
    boolean _isClassIdentifierEnabled;
    private final FastMap _idToObject;
    private final FastMap _objectToId;
    private final FastTable _formatStack;
    private final FastList _formatContent = new FastList(){

        @Override
        public void addLast(Object obj) {
            XmlElement.this.add(obj);
        }
    };
    private final FastTable _parseContents;
    private int _parseContentIndex;

    XmlElement(XmlPullParserImpl parser) {
        if (parser != null) {
            this._parser = parser;
            this._parseContents = new FastTable();
            this._formatAttributes = null;
            this._idToObject = new FastMap();
            this._objectToId = null;
            this._formatStack = null;
        } else {
            this._parser = null;
            this._parseContents = null;
            this._formatAttributes = new FormatAttributes();
            this._idToObject = null;
            this._objectToId = new FastMap().setKeyComparator(FastComparator.IDENTITY);
            this._formatStack = (FastTable)new FastTable().setValueComparator(FastComparator.IDENTITY);
        }
    }

    public <T> T object() throws XmlException {
        if (this._object == null) {
            if (this._objectClass == null) {
                throw new XmlException("Object type unknown, cannot use reflection");
            }
            try {
                this._object = this._objectClass.newInstance();
            }
            catch (IllegalAccessException e2) {
                throw new XmlException(this._objectClass + " default constructor inaccessible");
            }
            catch (InstantiationException e3) {
                throw new XmlException(this._objectClass + " default constructor throws an exception");
            }
        }
        return (T)this._object;
    }

    public Class objectClass() {
        return this._objectClass;
    }

    public ContentHandler formatter() {
        return this._formatHandler;
    }

    public void add(Object obj) {
        try {
            if (obj == null) {
                obj = XmlFormat.NULL;
            }
            if (this._elemName != null) {
                this.flushStart();
            }
            if (obj instanceof CharacterData) {
                CharacterData charData = (CharacterData)obj;
                this._formatHandler.characters(charData.getChars(), charData.offset(), charData.length());
                return;
            }
            this._objectClass = obj.getClass();
            Class<?> cls = this._objectClass;
            XmlFormat<?> xmlFormat = XmlFormat.getInstance(cls);
            String defaultName = xmlFormat.defaultName();
            if (defaultName != null) {
                this._objectClass = obj.getClass();
                String alias = XmlFormat.aliasFor(this._objectClass);
                if (this._isClassIdentifierEnabled) {
                    this._formatAttributes.addAttribute("j:class", alias != null ? XmlElement.toCharSeq(alias) : XmlElement.toCharSeq(this._objectClass.getName()));
                }
                CharSequence elemName = this._elemName = XmlElement.toCharSeq(defaultName);
                this.format(obj, xmlFormat);
                if (this._elemName != null) {
                    this.flushStart();
                }
                this._formatHandler.endElement(Text.EMPTY, elemName, elemName);
                return;
            }
            CharSequence elemName = this._elemName = this.qNameFor(cls);
            this.format(obj, xmlFormat);
            if (this._elemName != null) {
                this.flushStart();
            }
            if (elemName == this._textBuilder) {
                elemName = this.qNameFor(cls);
            }
            this._formatHandler.endElement(Text.EMPTY, elemName, elemName);
        }
        catch (SAXException e) {
            throw new XmlException(e);
        }
    }

    public void add(Object obj, String qName) {
        if (obj == null) {
            return;
        }
        try {
            if (this._elemName != null) {
                this.flushStart();
            }
            this._objectClass = obj.getClass();
            String alias = XmlFormat.aliasFor(this._objectClass);
            if (this._isClassIdentifierEnabled) {
                this._formatAttributes.addAttribute("j:class", alias != null ? XmlElement.toCharSeq(alias) : XmlElement.toCharSeq(this._objectClass.getName()));
            }
            CharSequence elemName = this._elemName = XmlElement.toCharSeq(qName);
            this.format(obj, XmlFormat.getInstance(this._objectClass));
            if (this._elemName != null) {
                this.flushStart();
            }
            this._formatHandler.endElement(Text.EMPTY, elemName, elemName);
        }
        catch (SAXException e) {
            throw new XmlException(e);
        }
    }

    public void add(Object obj, String qName, Class clazz) {
        if (obj == null) {
            return;
        }
        try {
            if (this._elemName != null) {
                this.flushStart();
            }
            CharSequence elemName = this._elemName = XmlElement.toCharSeq(qName);
            this.format(obj, XmlFormat.getInstance(clazz));
            if (this._elemName != null) {
                this.flushStart();
            }
            this._formatHandler.endElement(Text.EMPTY, elemName, elemName);
        }
        catch (SAXException e) {
            throw new XmlException(e);
        }
    }

    public TextBuilder newAttribute(String name) {
        if (this._formatAttributes == null || this._elemName == null) {
            this.attributeSettingError();
        }
        return this._formatAttributes.newAttribute(name);
    }

    public void setAttribute(String name, CharSequence value) {
        if (this._formatAttributes == null || this._elemName == null) {
            this.attributeSettingError();
        }
        if (value == null) {
            return;
        }
        this._formatAttributes.addAttribute(name, value);
    }

    public void setAttribute(String name, String value) {
        if (this._formatAttributes == null || this._elemName == null) {
            this.attributeSettingError();
        }
        if (value == null) {
            return;
        }
        CharSequence csqValue = XmlElement.toCharSeq(value);
        this._formatAttributes.addAttribute(name, csqValue);
    }

    public void setAttribute(String name, boolean value) {
        this.newAttribute(name).append(value);
    }

    public void setAttribute(String name, int value) {
        this.newAttribute(name).append(value);
    }

    public void setAttribute(String name, long value) {
        this.newAttribute(name).append(value);
    }

    public void setAttribute(String name, float value) {
        this.newAttribute(name).append(value);
    }

    public void setAttribute(String name, double value) {
        this.newAttribute(name).append(value);
    }

    public void setAttribute(String name, Boolean value) {
        if (value == null) {
            return;
        }
        this.newAttribute(name).append(value);
    }

    public void setAttribute(String name, Byte value) {
        if (value == null) {
            return;
        }
        this.newAttribute(name).append(value.byteValue());
    }

    public void setAttribute(String name, Short value) {
        if (value == null) {
            return;
        }
        this.newAttribute(name).append(value.shortValue());
    }

    public void setAttribute(String name, Integer value) {
        if (value == null) {
            return;
        }
        this.newAttribute(name).append(value);
    }

    public void setAttribute(String name, Long value) {
        if (value == null) {
            return;
        }
        this.newAttribute(name).append(value);
    }

    public void setAttribute(String name, Float value) {
        if (value == null) {
            return;
        }
        this.newAttribute(name).append(value.floatValue());
    }

    public void setAttribute(String name, Double value) {
        if (value == null) {
            return;
        }
        this.newAttribute(name).append(value);
    }

    public void removeAttribute(String name) {
        int index;
        if (this._formatAttributes == null || this._elemName == null) {
            this.attributeSettingError();
        }
        if ((index = this._formatAttributes.getIndex(name)) >= 0) {
            this._formatAttributes.remove(index);
        }
    }

    public XmlPullParser parser() {
        return this._parser;
    }

    public boolean hasNext() {
        if (!this._isParserAtNext) {
            this.nextToken();
            this._isParserAtNext = true;
        }
        return !this._isClosure;
    }

    public <T> T getNext() {
        try {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this._isParserAtNext = false;
            if (this._parser.getEventType() == 2) {
                CharSequence className = this._parser.getSaxAttributes().getValue("j:class");
                if (className == null) {
                    CharSequence uri = this._parser.getNamespace();
                    CharSequence name = this._parser.getName();
                    this._objectClass = uri.length() > 0 && !uri.equals(ObjectWriter.JAVOLUTION_URI) ? XmlFormat.classFor(uri, name) : XmlFormat.classFor(name);
                } else {
                    this._objectClass = XmlFormat.classFor(className);
                }
                XmlFormat xmlFormat = XmlFormat.getInstance(this._objectClass);
                ++this._parseContentIndex;
                Object obj = this.parse(xmlFormat);
                --this._parseContentIndex;
                if (this.hasNext()) {
                    this.incompleteReadError();
                }
                this._isParserAtNext = false;
                return (T)obj;
            }
            CharacterData cdata = CharacterData.valueOf(this._parser.getText());
            return (T)cdata;
        }
        catch (XmlPullParserException e) {
            throw new XmlException(e);
        }
    }

    public <T> T get(String qName) {
        try {
            if (this.hasNext() && this._parser.getEventType() == 2 && this._parser.getQName().equals(qName)) {
                this._isParserAtNext = false;
                CharSequence name = this._parser.getSaxAttributes().getValue("j:class");
                if (name == null) {
                    throw new XmlException("\"j:class\" attribute missing");
                }
                this._objectClass = XmlFormat.classFor(name);
                XmlFormat xmlFormat = XmlFormat.getInstance(this._objectClass);
                ++this._parseContentIndex;
                Object obj = this.parse(xmlFormat);
                --this._parseContentIndex;
                if (this.hasNext()) {
                    this.incompleteReadError();
                }
                this._isParserAtNext = false;
                return (T)obj;
            }
            return null;
        }
        catch (XmlPullParserException e) {
            throw new XmlException(e);
        }
    }

    public <T> T get(String qName, Class clazz) {
        try {
            if (this.hasNext() && this._parser.getEventType() == 2 && this._parser.getQName().equals(qName)) {
                this._isParserAtNext = false;
                this._objectClass = clazz;
                XmlFormat xmlFormat = XmlFormat.getInstance(clazz);
                ++this._parseContentIndex;
                Object obj = this.parse(xmlFormat);
                --this._parseContentIndex;
                if (this.hasNext()) {
                    this.incompleteReadError();
                }
                this._isParserAtNext = false;
                return (T)obj;
            }
            return null;
        }
        catch (XmlPullParserException e) {
            throw new XmlException(e);
        }
    }

    public Attributes getAttributes() {
        if (this._formatAttributes != null) {
            return this._formatAttributes;
        }
        if (this._isParserAtNext) {
            throw new XmlException("Attributes should be read before any content");
        }
        return this._parser.getSaxAttributes();
    }

    public CharSequence getAttribute(String name) {
        return this.getAttributes().getValue(name);
    }

    public boolean isAttribute(String name) {
        return this.getAttributes().getIndex(name) >= 0;
    }

    public CharSequence getAttribute(String name, CharSequence defaultValue) {
        CharSequence value = this.getAttributes().getValue(name);
        return value != null ? value : defaultValue;
    }

    public String getAttribute(String name, String defaultValue) {
        CharSequence value = this.getAttributes().getValue(name);
        return value != null ? value.toString() : defaultValue;
    }

    public boolean getAttribute(String name, boolean defaultValue) {
        CharSequence value = this.getAttributes().getValue(name);
        return value != null ? TypeFormat.parseBoolean(value) : defaultValue;
    }

    public int getAttribute(String name, int defaultValue) {
        CharSequence value = this.getAttributes().getValue(name);
        return value != null ? TypeFormat.parseInt(value) : defaultValue;
    }

    public long getAttribute(String name, long defaultValue) {
        CharSequence value = this.getAttributes().getValue(name);
        return value != null ? TypeFormat.parseLong(value) : defaultValue;
    }

    public float getAttribute(String name, float defaultValue) {
        CharSequence value = this.getAttributes().getValue(name);
        return value != null ? (float)TypeFormat.parseDouble(value) : defaultValue;
    }

    public double getAttribute(String name, double defaultValue) {
        CharSequence value = this.getAttributes().getValue(name);
        return value != null ? TypeFormat.parseDouble(value) : defaultValue;
    }

    public Boolean getAttribute(String name, Boolean defaultValue) {
        CharSequence value = this.getAttributes().getValue(name);
        return value != null ? new Boolean(TypeFormat.parseBoolean(value)) : defaultValue;
    }

    public Byte getAttribute(String name, Byte defaultValue) {
        CharSequence value = this.getAttributes().getValue(name);
        return value != null ? new Byte(TypeFormat.parseByte(value)) : defaultValue;
    }

    public Short getAttribute(String name, Short defaultValue) {
        CharSequence value = this.getAttributes().getValue(name);
        return value != null ? new Short(TypeFormat.parseShort(value)) : defaultValue;
    }

    public Integer getAttribute(String name, Integer defaultValue) {
        CharSequence value = this.getAttributes().getValue(name);
        return value != null ? new Integer(TypeFormat.parseInt(value)) : defaultValue;
    }

    public Long getAttribute(String name, Long defaultValue) {
        CharSequence value = this.getAttributes().getValue(name);
        return value != null ? new Long(TypeFormat.parseLong(value)) : defaultValue;
    }

    public Float getAttribute(String name, Float defaultValue) {
        CharSequence value = this.getAttributes().getValue(name);
        return value != null ? new Float(TypeFormat.parseFloat(value)) : defaultValue;
    }

    public Double getAttribute(String name, Double defaultValue) {
        CharSequence value = this.getAttributes().getValue(name);
        return value != null ? new Double(TypeFormat.parseDouble(value)) : defaultValue;
    }

    void reset() {
        this._elemName = null;
        this._isClosure = false;
        this._object = null;
        this._objectClass = null;
        this._textBuilder.reset();
        if (this._parser != null) {
            this._parser.reset();
            for (int i = 0; i < this._parseContents.size(); ++i) {
                FastList list = (FastList)this._parseContents.get(i);
                list.reset();
            }
            this._parseContentIndex = 0;
            this._isParserAtNext = false;
            this._idToObject.clear();
        } else {
            this._formatAttributes.reset();
            this._formatContent.reset();
            this._formatHandler = null;
            this._objectToId.clear();
            this._formatStack.clear();
        }
    }

    private void flushStart() throws SAXException {
        this._formatHandler.startElement(Text.EMPTY, this._elemName, this._elemName, this._formatAttributes);
        this._formatAttributes.reset();
        this._elemName = null;
    }

    private int nextToken() {
        try {
            while (true) {
                int event = this._parser.nextToken();
                switch (event) {
                    case 2: 
                    case 5: {
                        this._isClosure = false;
                        return event;
                    }
                    case 1: 
                    case 3: {
                        this._isClosure = true;
                        return event;
                    }
                    case 4: {
                        if (this._parser.isWhitespace()) break;
                        this._isClosure = false;
                        return event;
                    }
                }
            }
        }
        catch (XmlPullParserException e) {
            throw new XmlException(e);
        }
        catch (IOException e) {
            throw new XmlException(e);
        }
    }

    private void attributeSettingError() {
        if (this._formatAttributes == null) {
            throw new XmlException("Attributes cannot be set during parsing");
        }
        if (this._elemName == null) {
            throw new XmlException("Attributes should be set before adding nested elements");
        }
        throw new XmlException();
    }

    private void incompleteReadError() throws XmlPullParserException {
        if (this._parser.getEventType() == 2) {
            throw new XmlException("Incomplete read error (nested " + this._parser.getQName() + " has not been read)");
        }
        throw new XmlException("Incomplete read error (character datahas not been read)");
    }

    private CharSequence qNameFor(Class cls) {
        String alias = XmlFormat.aliasFor(cls);
        String className = alias != null ? alias : cls.getName();
        String matchPfx = null;
        String matchPkg = "";
        int i = 0;
        while (i < this._packagePrefixes.size()) {
            String pkg;
            String pfx = (String)this._packagePrefixes.get(i++);
            if (!className.startsWith(pkg = (String)this._packagePrefixes.get(i++)) || pkg.length() < matchPkg.length() || alias != null && !pfx.equals("j")) continue;
            matchPfx = pfx;
            matchPkg = pkg;
        }
        if (matchPfx != null) {
            this._textBuilder.reset();
            if (matchPfx.length() > 0) {
                this._textBuilder.append(matchPfx).append(':');
            }
            if (matchPkg.length() > 0) {
                this._textBuilder.append(className, matchPkg.length() + 1, className.length());
            } else {
                this._textBuilder.append(className);
            }
            return this._textBuilder;
        }
        return XmlElement.toCharSeq(className);
    }

    private static CharSequence toCharSeq(Object str) {
        if (str instanceof CharSequence) {
            return (CharSequence)str;
        }
        return Text.valueOf((String)str);
    }

    private Object parse(XmlFormat xmlFormat) {
        if (this._areReferencesEnabled && xmlFormat.identifier(false) != null) {
            CharSequence ref = this.getAttribute(xmlFormat.identifier(true));
            if (ref != null) {
                Object obj = this._idToObject.get(ref);
                if (obj == null) {
                    throw new IllegalStateException("Reference " + ref + " not found.");
                }
                int depth = this._parser.getDepth();
                while (this.nextToken() != 3 && this._parser.getDepth() <= depth) {
                }
                this._isParserAtNext = true;
                return obj;
            }
            this._object = xmlFormat.allocate(this);
            Object obj = this._object;
            CharSequence id = this.getAttribute(xmlFormat.identifier(false));
            if (id != null) {
                if (obj != null) {
                    this._idToObject.put(Text.valueOf(id), obj);
                    if (xmlFormat.parse(this) != obj) {
                        throw new XmlException("Parse should return xml.object() when allocate(xml) != null");
                    }
                    return obj;
                }
                obj = xmlFormat.parse(this);
                this._idToObject.put(Text.valueOf(id), obj);
                return obj;
            }
            this._areReferencesEnabled = false;
            obj = xmlFormat.parse(this);
            this._areReferencesEnabled = true;
            return obj;
        }
        this._object = null;
        this._object = xmlFormat.allocate(this);
        Object obj = this._object;
        if (obj != null) {
            if (xmlFormat.parse(this) != obj) {
                throw new XmlException("Parse should return xml.object() when allocate(xml) != null");
            }
            return obj;
        }
        return xmlFormat.parse(this);
    }

    private void format(Object obj, XmlFormat xmlFormat) {
        if (this._areReferencesEnabled && xmlFormat.identifier(false) != null) {
            Text ref = (Text)this._objectToId.get(obj);
            if (ref != null) {
                this.setAttribute(xmlFormat.identifier(true), ref);
            } else {
                Text id = Text.valueOf(this._objectToId.size());
                this._objectToId.put(obj, id);
                this.setAttribute(xmlFormat.identifier(false), id);
            }
            if (ref == null || this._expandReferences && !this._formatStack.contains(obj)) {
                this._formatStack.addLast(obj);
                xmlFormat.format(obj, this);
                this._formatStack.removeLast();
            }
            return;
        }
        xmlFormat.format(obj, this);
    }

    public FastList getContent() {
        if (this._parser != null) {
            while (this._parseContents.size() <= this._parseContentIndex) {
                this._parseContents.add(new FastList());
            }
            FastList content = (FastList)this._parseContents.get(this._parseContentIndex);
            while (this.hasNext()) {
                content.add(this.getNext());
            }
            return content;
        }
        return this._formatContent;
    }

    public void add(Object obj, String qName, XmlFormat xmlFormat) {
        if (obj == null) {
            return;
        }
        try {
            if (this._elemName != null) {
                this.flushStart();
            }
            CharSequence elemName = this._elemName = XmlElement.toCharSeq(qName);
            this.format(obj, xmlFormat);
            if (this._elemName != null) {
                this.flushStart();
            }
            this._formatHandler.endElement(Text.EMPTY, elemName, elemName);
        }
        catch (SAXException e) {
            throw new XmlException(e);
        }
    }

    public <T> T get(String qName, XmlFormat xmlFormat) {
        try {
            if (this.hasNext() && this._parser.getEventType() == 2 && this._parser.getQName().equals(qName)) {
                this._isParserAtNext = false;
                ++this._parseContentIndex;
                Object obj = this.parse(xmlFormat);
                --this._parseContentIndex;
                if (this.hasNext()) {
                    this.incompleteReadError();
                }
                this._isParserAtNext = false;
                return (T)obj;
            }
            return null;
        }
        catch (XmlPullParserException e) {
            throw new XmlException(e);
        }
    }
}

