/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.util;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javolution37.javolution.lang.Text;
import javolution37.javolution.realtime.LogContext;

public class StandardLog
extends LogContext {
    private Logger _logger;

    public StandardLog() {
        this(Logger.getLogger(""));
    }

    public StandardLog(Logger logger) {
        this._logger = logger;
    }

    public final Logger getLogger() {
        return this._logger;
    }

    public static boolean isLoggable(Level level) {
        LogContext log = LogContext.current();
        if (log instanceof StandardLog) {
            return ((StandardLog)log)._logger.isLoggable(level);
        }
        if (level.intValue() >= Level.WARNING.intValue()) {
            return log.isWarningLogged();
        }
        if (level.intValue() >= Level.INFO.intValue()) {
            return log.isInfoLogged();
        }
        return false;
    }

    public static void log(LogRecord record) {
        LogContext log = LogContext.current();
        if (log instanceof StandardLog) {
            ((StandardLog)log)._logger.log(record);
        } else {
            Throwable error = record.getThrown();
            if (error != null) {
                log.logError(error, StandardLog.toCharSeq(record.getMessage()));
            } else if (record.getLevel().intValue() > Level.WARNING.intValue()) {
                log.logWarning(StandardLog.toCharSeq(record.getMessage()));
            } else if (record.getLevel().intValue() > Level.INFO.intValue()) {
                log.logInfo(StandardLog.toCharSeq(record.getMessage()));
            }
        }
    }

    public static void severe(String msg) {
        LogContext log = LogContext.current();
        if (log instanceof StandardLog) {
            ((StandardLog)log)._logger.severe(msg);
        } else {
            log.logWarning(StandardLog.toCharSeq(msg));
        }
    }

    public static void warning(String msg) {
        LogContext log = LogContext.current();
        log.logWarning(StandardLog.toCharSeq(msg));
    }

    public static void info(String msg) {
        LogContext log = LogContext.current();
        log.logInfo(StandardLog.toCharSeq(msg));
    }

    public static void config(String msg) {
        LogContext log = LogContext.current();
        if (log instanceof StandardLog) {
            ((StandardLog)log)._logger.config(msg);
        }
    }

    public static void fine(String msg) {
        LogContext log = LogContext.current();
        if (log instanceof StandardLog) {
            ((StandardLog)log)._logger.fine(msg);
        }
    }

    public static void finer(String msg) {
        LogContext log = LogContext.current();
        if (log instanceof StandardLog) {
            ((StandardLog)log)._logger.finer(msg);
        }
    }

    public static void finest(String msg) {
        LogContext log = LogContext.current();
        if (log instanceof StandardLog) {
            ((StandardLog)log)._logger.finest(msg);
        }
    }

    public static void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        LogContext log = LogContext.current();
        if (log instanceof StandardLog) {
            ((StandardLog)log)._logger.throwing(sourceClass, sourceMethod, thrown);
        } else {
            log.logError(thrown, null);
        }
    }

    public static void entering(String sourceClass, String sourceMethod) {
        LogContext log = LogContext.current();
        if (log instanceof StandardLog) {
            ((StandardLog)log)._logger.entering(sourceClass, sourceMethod);
        }
    }

    public static void exiting(String sourceClass, String sourceMethod) {
        LogContext log = LogContext.current();
        if (log instanceof StandardLog) {
            ((StandardLog)log)._logger.exiting(sourceClass, sourceMethod);
        }
    }

    @Override
    public boolean isInfoLogged() {
        return this._logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isWarningLogged() {
        return this._logger.isLoggable(Level.WARNING);
    }

    @Override
    public boolean isErrorLogged() {
        return this._logger.isLoggable(Level.SEVERE);
    }

    @Override
    public void logInfo(CharSequence message) {
        this._logger.info(message.toString());
    }

    @Override
    public void logWarning(CharSequence message) {
        this._logger.warning(message.toString());
    }

    @Override
    public void logError(Throwable error, CharSequence message) {
        String msg = message == null ? error.getMessage() : message.toString();
        msg = msg == null ? error.getClass().getName() : error.getClass().getName() + " - " + msg;
        this._logger.severe(msg);
    }

    private static CharSequence toCharSeq(Object str) {
        if (str instanceof CharSequence) {
            return (CharSequence)str;
        }
        return Text.valueOf((String)str);
    }
}

