/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.realtime;

import javolution37.javolution.JavolutionError;

public abstract class ObjectPool<T> {
    public static final ObjectPool NULL = new ObjectPool(){

        @Override
        public int size() {
            return 0;
        }

        public Object next() {
            return null;
        }

        public void recycle(Object obj) {
        }

        @Override
        protected void recycleAll() {
        }

        @Override
        protected void clearAll() {
        }
    };
    ObjectPool<T> outer;
    Thread user;
    boolean inUse;

    protected ObjectPool() {
    }

    public final Thread getUser() {
        return this.user;
    }

    public final boolean isLocal() {
        if (this.inUse) {
            if (this.user == null) {
                return false;
            }
            if (this.user == Thread.currentThread()) {
                return true;
            }
            throw new JavolutionError("Concurrent access to local pool detected");
        }
        throw new JavolutionError("Access to inner pool or unused pool detected");
    }

    public final boolean inUse() {
        return this.inUse;
    }

    public final ObjectPool<T> getOuter() {
        return this.outer;
    }

    public abstract int size();

    public abstract T next();

    public abstract void recycle(T var1);

    protected abstract void recycleAll();

    protected abstract void clearAll();
}

