/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.realtime;

import java.io.Serializable;
import javolution37.javolution.lang.Reference;
import javolution37.javolution.realtime.Context;
import javolution37.javolution.realtime.LocalContext;
import javolution37.javolution.util.FastMap;

public class LocalReference<T>
implements Reference<T>,
Serializable {
    private T _defaultValue;
    private boolean _hasBeenLocallyOverriden;

    public LocalReference() {
        this(null);
    }

    public LocalReference(T defaultValue) {
        this._defaultValue = defaultValue;
    }

    @Override
    public final T get() {
        return this._hasBeenLocallyOverriden ? this.retrieveValue() : this._defaultValue;
    }

    private T retrieveValue() {
        LocalContext ctx = Context.current().inheritedLocalContext;
        while (ctx != null) {
            Object value = ctx._references.get(this);
            if (value != null) {
                return (T)value;
            }
            ctx = ctx.getOuter().inheritedLocalContext;
        }
        return this._defaultValue;
    }

    @Override
    public void set(T value) {
        LocalContext ctx = Context.current().inheritedLocalContext;
        if (ctx != null) {
            FastMap references = ctx._references;
            references.put(this, value);
            this._hasBeenLocallyOverriden = true;
            return;
        }
        this._defaultValue = value;
    }

    public T getDefault() {
        return this._defaultValue;
    }

    public T getLocal() {
        LocalContext ctx = Context.current().inheritedLocalContext;
        return (T)(ctx != null ? ctx._references.get(this) : this._defaultValue);
    }

    public void setDefault(T defaultValue) {
        this._defaultValue = defaultValue;
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

