/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.lang;

import java.lang.reflect.InvocationTargetException;
import javolution37.javolution.JavolutionError;
import javolution37.javolution.util.StandardLog;

public final class Reflection {
    private Reflection() {
    }

    public static Class getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e0) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return Class.forName(name, true, cl);
            }
            catch (ClassNotFoundException e1) {
                try {
                    ClassLoader cl = ClassLoader.getSystemClassLoader();
                    return Class.forName(name, true, cl);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        catch (Throwable error) {
            StandardLog.error(error);
            return null;
        }
        StandardLog.warning(name + " not found");
        return null;
    }

    public static Constructor getConstructor(String signature) {
        int argStart = signature.indexOf(40) + 1;
        if (argStart < 0) {
            throw new IllegalArgumentException("Parenthesis '(' not found");
        }
        int argEnd = signature.indexOf(41);
        if (argEnd < 0) {
            throw new IllegalArgumentException("Parenthesis ')' not found");
        }
        String className = signature.substring(0, argStart - 1);
        Class theClass = Reflection.getClass(className);
        if (theClass == null) {
            return null;
        }
        String args = signature.substring(argStart, argEnd);
        if (args.length() == 0) {
            return new DefaultConstructor(theClass);
        }
        Class[] argsTypes = Reflection.classesFor(args);
        if (argsTypes != null) {
            try {
                return new ReflectConstructor(theClass.getConstructor(argsTypes), signature);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return null;
    }

    public static Method getMethod(String signature) {
        int argStart = signature.indexOf(40) + 1;
        if (argStart < 0) {
            throw new IllegalArgumentException("Parenthesis '(' not found");
        }
        int argEnd = signature.indexOf(41);
        if (argEnd < 0) {
            throw new IllegalArgumentException("Parenthesis ')' not found");
        }
        int nameStart = signature.substring(0, argStart).lastIndexOf(46) + 1;
        try {
            String className = signature.substring(0, nameStart - 1);
            Class theClass = Reflection.getClass(className);
            if (theClass == null) {
                return null;
            }
            String methodName = signature.substring(nameStart, argStart - 1);
            String args = signature.substring(argStart, argEnd);
            Class[] argsTypes = Reflection.classesFor(args);
            if (argsTypes == null) {
                return null;
            }
            return new ReflectMethod(theClass.getMethod(methodName, argsTypes), signature);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Class[] classesFor(String args) {
        if ((args = args.trim()).length() == 0) {
            return new Class[0];
        }
        int semiColons = 0;
        for (int i = 0; i < args.length(); ++i) {
            if (args.charAt(i) != ',') continue;
            ++semiColons;
        }
        Class[] classes = new Class[semiColons + 1];
        int index = 0;
        for (int i = 0; i < semiColons; ++i) {
            int sep = args.indexOf(44, index);
            classes[i] = Reflection.classFor(args.substring(index, sep).trim());
            if (classes[i] == null) {
                return null;
            }
            index = sep + 1;
        }
        classes[semiColons] = Reflection.classFor(args.substring(index).trim());
        if (classes[semiColons] == null) {
            return null;
        }
        return classes;
    }

    private static Class classFor(String className) {
        int arrayIndex = className.indexOf("[]");
        if (arrayIndex >= 0) {
            if (className.indexOf("[][]") >= 0) {
                if (className.indexOf("[][][]") >= 0) {
                    if (className.indexOf("[][][][]") >= 0) {
                        throw new UnsupportedOperationException("The maximum array dimension is 3");
                    }
                    return Reflection.getClass("[[[" + Reflection.descriptorFor(className.substring(0, arrayIndex)));
                }
                return Reflection.getClass("[[" + Reflection.descriptorFor(className.substring(0, arrayIndex)));
            }
            return Reflection.getClass("[" + Reflection.descriptorFor(className.substring(0, arrayIndex)));
        }
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        if (className.equals("char")) {
            return Character.TYPE;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        return Reflection.getClass(className);
    }

    private static String descriptorFor(String className) {
        if (className.equals("boolean")) {
            return "Z";
        }
        if (className.equals("byte")) {
            return "B";
        }
        if (className.equals("char")) {
            return "C";
        }
        if (className.equals("short")) {
            return "S";
        }
        if (className.equals("int")) {
            return "I";
        }
        if (className.equals("long")) {
            return "J";
        }
        if (className.equals("float")) {
            return "F";
        }
        if (className.equals("double")) {
            return "D";
        }
        return "L" + className.replace('.', '/') + ";";
    }

    public static abstract class Method {
        private static final Object[] NO_ARG = new Object[0];
        private final Object[] array1 = new Object[1];
        private final Object[] array2 = new Object[2];
        private final Object[] array3 = new Object[3];
        private final Object[] array4 = new Object[4];

        protected abstract Object execute(Object var1, Object[] var2);

        public final Object invoke(Object thisObject) {
            return this.execute(thisObject, NO_ARG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object invoke(Object thisObject, Object arg0) {
            Method method = this;
            synchronized (method) {
                this.array1[0] = arg0;
                return this.execute(thisObject, this.array1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object invoke(Object thisObject, Object arg0, Object arg1) {
            Method method = this;
            synchronized (method) {
                this.array2[0] = arg0;
                this.array2[1] = arg1;
                return this.execute(thisObject, this.array2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object invoke(Object thisObject, Object arg0, Object arg1, Object arg2) {
            Method method = this;
            synchronized (method) {
                this.array3[0] = arg0;
                this.array3[1] = arg1;
                this.array3[2] = arg2;
                return this.execute(thisObject, this.array3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object invoke(Object thisObject, Object arg0, Object arg1, Object arg2, Object arg3) {
            Method method = this;
            synchronized (method) {
                this.array4[0] = arg0;
                this.array4[1] = arg1;
                this.array4[2] = arg2;
                this.array4[3] = arg3;
                return this.execute(thisObject, this.array4);
            }
        }
    }

    public static abstract class Constructor {
        private static final Object[] NO_ARG = new Object[0];
        private final Object[] array1 = new Object[1];
        private final Object[] array2 = new Object[2];
        private final Object[] array3 = new Object[3];
        private final Object[] array4 = new Object[4];

        protected abstract Object allocate(Object[] var1);

        public final Object newInstance() {
            return this.allocate(NO_ARG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object newInstance(Object arg0) {
            Constructor constructor = this;
            synchronized (constructor) {
                this.array1[0] = arg0;
                return this.allocate(this.array1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object newInstance(Object arg0, Object arg1) {
            Constructor constructor = this;
            synchronized (constructor) {
                this.array2[0] = arg0;
                this.array2[1] = arg1;
                return this.allocate(this.array2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object newInstance(Object arg0, Object arg1, Object arg2) {
            Constructor constructor = this;
            synchronized (constructor) {
                this.array3[0] = arg0;
                this.array3[1] = arg1;
                this.array3[2] = arg2;
                return this.allocate(this.array3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object newInstance(Object arg0, Object arg1, Object arg2, Object arg3) {
            Constructor constructor = this;
            synchronized (constructor) {
                this.array4[0] = arg0;
                this.array4[1] = arg1;
                this.array4[2] = arg2;
                this.array4[3] = arg3;
                return this.allocate(this.array4);
            }
        }
    }

    private static final class ReflectMethod
    extends Method {
        private final java.lang.reflect.Method _value;
        private final String _signature;

        public ReflectMethod(java.lang.reflect.Method value, String signature) {
            this._value = value;
            this._signature = signature;
        }

        @Override
        public Object execute(Object that, Object[] args) {
            try {
                return this._value.invoke(that, args);
            }
            catch (IllegalArgumentException e) {
                throw new JavolutionError("Illegal argument for " + this._signature + " method", e);
            }
            catch (IllegalAccessException e) {
                throw new JavolutionError("Illegal access error for " + this._signature + " method", e);
            }
            catch (InvocationTargetException e) {
                throw new JavolutionError("Invocation exception for " + this._signature + " method", (InvocationTargetException)e.getTargetException());
            }
        }

        public String toString() {
            return this._signature + " method";
        }
    }

    private static final class ReflectConstructor
    extends Constructor {
        private final java.lang.reflect.Constructor _value;
        private final String _signature;

        public ReflectConstructor(java.lang.reflect.Constructor value, String signature) {
            this._value = value;
            this._signature = signature;
        }

        @Override
        public Object allocate(Object[] args) {
            try {
                return this._value.newInstance(args);
            }
            catch (IllegalArgumentException e) {
                throw new JavolutionError("Illegal argument for " + this._signature + " constructor", e);
            }
            catch (InstantiationException e) {
                throw new JavolutionError("Instantiation error for " + this._signature + " constructor", e);
            }
            catch (IllegalAccessException e) {
                throw new JavolutionError("Illegal access error for " + this._signature + " constructor", e);
            }
            catch (InvocationTargetException e) {
                throw new JavolutionError("Invocation exception  for " + this._signature + " constructor", (InvocationTargetException)e.getTargetException());
            }
        }

        public String toString() {
            return this._signature + " constructor";
        }
    }

    private static class DefaultConstructor
    extends Constructor {
        final Class _class;

        DefaultConstructor(Class cl) {
            this._class = cl;
        }

        @Override
        public Object allocate(Object[] args) {
            try {
                return this._class.newInstance();
            }
            catch (InstantiationException e) {
                throw new JavolutionError("Instantiation error for " + this._class.getName() + " default constructor", e);
            }
            catch (IllegalAccessException e) {
                throw new JavolutionError("Illegal access error for " + this._class.getName() + " constructor", e);
            }
        }

        public String toString() {
            return this._class + " default constructor";
        }
    }
}

