/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.util;

import java.util.Date;
import java.util.GregorianCalendar;

public class DateDiff {
    private static final double DAY_MILLIS = 8.64054E7;
    private static final double WEEK_MILLIS = 6.048378E8;
    private static final double MONTH_MILLIS = 2.62989955845E9;
    private static final double YEAR_MILLIS = 3.157253316E10;

    public static int getDateDiff(int calUnit, Date d1, Date d2) {
        boolean neg = false;
        if (d1.after(d2)) {
            Date temp = d1;
            d1 = d2;
            d2 = temp;
            neg = true;
        }
        int estimate = DateDiff.getEstDiff(calUnit, d1, d2);
        GregorianCalendar c1 = new GregorianCalendar();
        c1.setTime(d1);
        GregorianCalendar c2 = new GregorianCalendar();
        c2.setTime(d2);
        c1.add(calUnit, estimate - 2);
        int i = estimate - 1;
        while (true) {
            c1.add(calUnit, 1);
            if (c1.after(c2)) {
                return neg ? 1 - i : i - 1;
            }
            ++i;
        }
    }

    private static int getEstDiff(int calUnit, Date d1, Date d2) {
        long diff = d2.getTime() - d1.getTime();
        switch (calUnit) {
            case 5: 
            case 8: {
                return (int)((double)diff / 8.64054E7 + 0.5);
            }
            case 3: {
                return (int)((double)diff / 6.048378E8 + 0.5);
            }
            case 2: {
                return (int)((double)diff / 2.62989955845E9 + 0.5);
            }
            case 1: {
                return (int)((double)diff / 3.157253316E10 + 0.5);
            }
        }
        return 0;
    }
}

