/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.ts;

import com.jstatcom.ts.DefaultTSKeyListener;
import com.jstatcom.ts.DefaultTSListPopup;
import com.jstatcom.ts.DefaultTSMouseListener;
import com.jstatcom.ts.TS;
import com.jstatcom.ts.TSHolder;
import java.awt.Component;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public final class TSList
extends JList
implements PropertyChangeListener {
    private JPopupMenu tSListPopup = DefaultTSListPopup.getSharedInstance();
    private KeyListener tSKeyListener = DefaultTSKeyListener.getSharedInstance();
    private MouseListener tSMouseListener = DefaultTSMouseListener.getSharedInstance();
    private MouseListener triggerPopUp = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            int index;
            if (SwingUtilities.isRightMouseButton(e) && !TSList.this.isSelectedIndex(index = TSList.this.locationToIndex(e.getPoint()))) {
                TSList.this.setSelectedIndex(index);
            }
            if (TSList.this.tSListPopup != null) {
                TSList.this.tSListPopup.processMouseEvent(e, null, null);
            }
        }
    };
    private static final ListCellRenderer defaultTSListCellRenderer = new DefaultTSListCellRenderer();

    public TSList() {
        this.setModel(TSHolder.getInstance().getAsListModel());
        this.setCellRenderer(defaultTSListCellRenderer);
        this.addMouseListener(this.triggerPopUp);
        this.addKeyListener(this.tSKeyListener);
        this.addMouseListener(this.tSMouseListener);
        TSHolder.getInstance().addPropertyChangeListener(this);
        this.setFixedCellHeight(16);
    }

    public TS[] getSelectedTS() {
        Object[] selection = this.getSelectedValues();
        TS[] ts = new TS[selection.length];
        for (int i = 0; i < selection.length; ++i) {
            ts[i] = TSHolder.getInstance().getTS((String)selection[i]);
        }
        return ts;
    }

    public KeyListener getTSKeyListener() {
        return this.tSKeyListener;
    }

    public JPopupMenu getTSListPopup() {
        return this.tSListPopup;
    }

    public MouseListener getTSMouseListener() {
        return this.tSMouseListener;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof TSHolder && evt.getPropertyName() == "TS_ADDED") {
            TSHolder.getInstance().getTS((String)evt.getNewValue()).addPropertyChangeListener(this);
            this.clearSelection();
        }
        if (evt.getSource() instanceof TSHolder && evt.getPropertyName() == "TS_REMOVED") {
            this.clearSelection();
        }
        if (evt.getSource() instanceof TSHolder && evt.getPropertyName() == "ALL_TS_REMOVED") {
            this.clearSelection();
        }
        if (evt.getSource() instanceof TS && evt.getPropertyName() == "TS_TYPE_CHANGED" && this.isVisible()) {
            this.repaint();
        }
    }

    public void setTSKeyListener(KeyListener newTSKeyListener) {
        if (this.tSKeyListener != null) {
            this.removeKeyListener(this.tSKeyListener);
        }
        this.tSKeyListener = newTSKeyListener;
        if (this.tSKeyListener != null) {
            this.addKeyListener(this.tSKeyListener);
        }
    }

    public void setTSListPopup(JPopupMenu newTsListPopup) {
        this.tSListPopup = newTsListPopup;
    }

    public void setTSMouseListener(MouseListener newTSMouseListener) {
        if (this.tSMouseListener != null) {
            this.removeMouseListener(this.tSMouseListener);
        }
        this.tSMouseListener = newTSMouseListener;
        if (this.tSMouseListener != null) {
            this.addMouseListener(this.tSMouseListener);
        }
    }

    public static class DefaultTSListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String name = value.toString();
            TS ts = TSHolder.getInstance().getTS(name);
            if (ts != null) {
                this.setIcon(ts.type().getIcon());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setText(name);
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            return this;
        }
    }
}

