/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.ts;

import com.jstatcom.component.StdMessages;
import com.jstatcom.component.TopFrameReference;
import com.jstatcom.component.VarNameSelector;
import com.jstatcom.ts.TS;
import com.jstatcom.ts.TSDate;
import com.jstatcom.ts.TSDateRange;
import com.jstatcom.ts.TSDateRangeSelector;
import com.jstatcom.ts.TSDateSelector;
import com.jstatcom.ts.TSHolder;
import com.jstatcom.ts.TSList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import org.apache.log4j.Logger;

public final class TSDummyDialog
extends JDialog {
    private static final Logger log = Logger.getLogger(TSDummyDialog.class);
    private JPanel ivjJDialogContentPane = null;
    private JLabel ivjJLabel1 = null;
    private JLabel ivjJLabel2 = null;
    private JLabel ivjJLabel3 = null;
    private JLabel ivjJLabel5 = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JButton ivjCancel = null;
    private JButton ivjOK = null;
    private JPanel ivjJPanel1 = null;
    private VarNameSelector ivjShiftName = null;
    private VarNameSelector ivjImpulseName = null;
    private JPanel ivjCreateDummies = null;
    private TSDateSelector ivjTSDateSelectorImpulse = null;
    private TSDateRangeSelector ivjTSDateRangeSelShift = null;
    private JCheckBox ivjImpulseCheck = null;
    private JCheckBox ivjShiftCheck = null;
    private JCheckBox trendShiftCheck = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private TSDateRangeSelector trendShiftRange = null;
    private VarNameSelector trendShiftName = null;

    public TSDummyDialog() {
        this.initialize();
    }

    public TSDummyDialog(JFrame owner, boolean modal) {
        super((Frame)owner, modal);
        this.initialize();
    }

    private void cancel_ActionEvents() {
        this.setVisible(false);
    }

    private void connEtoC1() {
        try {
            this.oK_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2() {
        try {
            this.cancel_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP1SetTarget() {
        try {
            this.getTSDateSelectorImpulse().setEnabled(this.getImpulseCheck().isSelected());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP2SetTarget() {
        try {
            this.getImpulseName().setEnabled(this.getImpulseCheck().isSelected());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP3SetTarget() {
        try {
            this.getTSDateRangeSelShift().setEnabled(this.getShiftCheck().isSelected());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP4SetTarget() {
        try {
            this.getShiftName().setEnabled(this.getShiftCheck().isSelected());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JButton getCancel() {
        if (this.ivjCancel == null) {
            try {
                this.ivjCancel = new JButton();
                this.ivjCancel.setName("Cancel");
                this.ivjCancel.setPreferredSize(new Dimension(85, 27));
                this.ivjCancel.setText("Cancel");
                this.ivjCancel.setMinimumSize(new Dimension(80, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCancel;
    }

    private JPanel getCreateDummies() {
        if (this.ivjCreateDummies == null) {
            try {
                this.jLabel1 = new JLabel();
                this.jLabel = new JLabel();
                this.ivjCreateDummies = new JPanel();
                this.ivjCreateDummies.setName("CreateDummies");
                this.ivjCreateDummies.setPreferredSize(new Dimension(520, 245));
                this.ivjCreateDummies.setBorder(new BevelBorder(1));
                this.ivjCreateDummies.setLayout(null);
                this.jLabel.setText("Shift range");
                this.jLabel.setSize(114, 19);
                this.jLabel.setLocation(42, 192);
                this.jLabel1.setText("Name of new series");
                this.jLabel1.setSize(120, 20);
                this.jLabel1.setLocation(42, 212);
                this.getCreateDummies().add((Component)this.getImpulseCheck(), this.getImpulseCheck().getName());
                this.getCreateDummies().add((Component)this.getJLabel1(), this.getJLabel1().getName());
                this.getCreateDummies().add((Component)this.getJLabel2(), this.getJLabel2().getName());
                this.getCreateDummies().add((Component)this.getShiftCheck(), this.getShiftCheck().getName());
                this.getCreateDummies().add((Component)this.getJLabel3(), this.getJLabel3().getName());
                this.getCreateDummies().add((Component)this.getJLabel5(), this.getJLabel5().getName());
                this.getCreateDummies().add((Component)this.getTSDateSelectorImpulse(), this.getTSDateSelectorImpulse().getName());
                this.getCreateDummies().add((Component)this.getImpulseName(), this.getImpulseName().getName());
                this.getCreateDummies().add((Component)this.getTSDateRangeSelShift(), this.getTSDateRangeSelShift().getName());
                this.getCreateDummies().add((Component)this.getShiftName(), this.getShiftName().getName());
                this.ivjCreateDummies.add((Component)this.getTrendShiftCheck(), null);
                this.ivjCreateDummies.add((Component)this.jLabel, null);
                this.ivjCreateDummies.add((Component)this.jLabel1, null);
                this.ivjCreateDummies.add((Component)this.getTrendShiftRange(), null);
                this.ivjCreateDummies.add((Component)this.getTrendShiftName(), null);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCreateDummies;
    }

    private JCheckBox getImpulseCheck() {
        if (this.ivjImpulseCheck == null) {
            try {
                this.ivjImpulseCheck = new JCheckBox();
                this.ivjImpulseCheck.setName("ImpulseCheck");
                this.ivjImpulseCheck.setText("Impulse dummy");
                this.ivjImpulseCheck.setBounds(37, 12, 120, 25);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjImpulseCheck;
    }

    private VarNameSelector getImpulseName() {
        if (this.ivjImpulseName == null) {
            try {
                this.ivjImpulseName = new VarNameSelector();
                this.ivjImpulseName.setName("ImpulseName");
                this.ivjImpulseName.setVarName("impulse");
                this.ivjImpulseName.setBounds(185, 62, 150, 20);
                this.ivjImpulseName.setEnabled(false);
                this.ivjImpulseName.setHorizontalAlignment(2);
                this.ivjImpulseName.setEditable(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjImpulseName;
    }

    private JPanel getJDialogContentPane() {
        if (this.ivjJDialogContentPane == null) {
            try {
                this.ivjJDialogContentPane = new JPanel();
                this.ivjJDialogContentPane.setName("JDialogContentPane");
                this.ivjJDialogContentPane.setLayout(new BorderLayout());
                this.getJDialogContentPane().add((Component)this.getJPanel1(), "South");
                this.getJDialogContentPane().add((Component)this.getCreateDummies(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJDialogContentPane;
    }

    private JLabel getJLabel1() {
        if (this.ivjJLabel1 == null) {
            try {
                this.ivjJLabel1 = new JLabel();
                this.ivjJLabel1.setName("JLabel1");
                this.ivjJLabel1.setText("Date of impulse");
                this.ivjJLabel1.setBounds(42, 42, 122, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel1;
    }

    private JLabel getJLabel2() {
        if (this.ivjJLabel2 == null) {
            try {
                this.ivjJLabel2 = new JLabel();
                this.ivjJLabel2.setName("JLabel2");
                this.ivjJLabel2.setText("Name of new series");
                this.ivjJLabel2.setBounds(42, 62, 122, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel2;
    }

    private JLabel getJLabel3() {
        if (this.ivjJLabel3 == null) {
            try {
                this.ivjJLabel3 = new JLabel();
                this.ivjJLabel3.setName("JLabel3");
                this.ivjJLabel3.setText("Shift range");
                this.ivjJLabel3.setBounds(42, 117, 122, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel3;
    }

    private JLabel getJLabel5() {
        if (this.ivjJLabel5 == null) {
            try {
                this.ivjJLabel5 = new JLabel();
                this.ivjJLabel5.setName("JLabel5");
                this.ivjJLabel5.setText("Name of new series");
                this.ivjJLabel5.setBounds(42, 137, 122, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel5;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setPreferredSize(new Dimension(520, 50));
                this.ivjJPanel1.setLayout(this.getJPanel1FlowLayout());
                this.ivjJPanel1.setMinimumSize(new Dimension(520, 50));
                this.ivjJPanel1.setMaximumSize(new Dimension(520, 50));
                this.getJPanel1().add((Component)this.getOK(), this.getOK().getName());
                this.getJPanel1().add((Component)this.getCancel(), this.getCancel().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private FlowLayout getJPanel1FlowLayout() {
        FlowLayout ivjJPanel1FlowLayout = null;
        try {
            ivjJPanel1FlowLayout = new FlowLayout();
            ivjJPanel1FlowLayout.setVgap(10);
            ivjJPanel1FlowLayout.setHgap(50);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjJPanel1FlowLayout;
    }

    private JButton getOK() {
        if (this.ivjOK == null) {
            try {
                this.ivjOK = new JButton();
                this.ivjOK.setName("OK");
                this.ivjOK.setPreferredSize(new Dimension(85, 27));
                this.ivjOK.setText("OK");
                this.ivjOK.setMaximumSize(new Dimension(80, 27));
                this.ivjOK.setMinimumSize(new Dimension(80, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOK;
    }

    private JCheckBox getShiftCheck() {
        if (this.ivjShiftCheck == null) {
            try {
                this.ivjShiftCheck = new JCheckBox();
                this.ivjShiftCheck.setName("ShiftCheck");
                this.ivjShiftCheck.setText("Shift dummy");
                this.ivjShiftCheck.setBounds(37, 87, 97, 25);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjShiftCheck;
    }

    private VarNameSelector getShiftName() {
        if (this.ivjShiftName == null) {
            try {
                this.ivjShiftName = new VarNameSelector();
                this.ivjShiftName.setName("ShiftName");
                this.ivjShiftName.setVarName("shift");
                this.ivjShiftName.setBounds(185, 137, 150, 20);
                this.ivjShiftName.setEnabled(false);
                this.ivjShiftName.setHorizontalAlignment(2);
                this.ivjShiftName.setEditable(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjShiftName;
    }

    private TSDateRangeSelector getTSDateRangeSelShift() {
        if (this.ivjTSDateRangeSelShift == null) {
            try {
                this.ivjTSDateRangeSelShift = new TSDateRangeSelector();
                this.ivjTSDateRangeSelShift.setName("TSDateRangeSelShift");
                this.ivjTSDateRangeSelShift.setBounds(185, 117, 150, 20);
                this.ivjTSDateRangeSelShift.setEnabled(false);
                this.ivjTSDateRangeSelShift.setEditable(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTSDateRangeSelShift;
    }

    private TSDateSelector getTSDateSelectorImpulse() {
        if (this.ivjTSDateSelectorImpulse == null) {
            try {
                this.ivjTSDateSelectorImpulse = new TSDateSelector();
                this.ivjTSDateSelectorImpulse.setName("TSDateSelectorImpulse");
                this.ivjTSDateSelectorImpulse.setBounds(185, 42, 150, 20);
                this.ivjTSDateSelectorImpulse.setEnabled(false);
                this.ivjTSDateSelectorImpulse.setEditable(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTSDateSelectorImpulse;
    }

    private void handleException(Throwable exception) {
        log.error((Object)"Unhandled Exception", exception);
    }

    private void initConnections() throws Exception {
        this.getOK().addActionListener(this.ivjEventHandler);
        this.getCancel().addActionListener(this.ivjEventHandler);
        this.getImpulseCheck().addActionListener(this.ivjEventHandler);
        this.getShiftCheck().addActionListener(this.ivjEventHandler);
        this.connPtoP1SetTarget();
        this.connPtoP3SetTarget();
        this.connPtoP2SetTarget();
        this.connPtoP4SetTarget();
    }

    private void initialize() {
        try {
            this.setName("TimeSeriesCreate");
            this.setDefaultCloseOperation(2);
            this.setTitle("Create Dummy");
            this.setSize(400, 340);
            this.setResizable(false);
            this.setContentPane(this.getJDialogContentPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JCheckBox getTrendShiftCheck() {
        if (this.trendShiftCheck == null) {
            this.trendShiftCheck = new JCheckBox();
            this.trendShiftCheck.setText("Trend shift dummy");
            this.trendShiftCheck.setLocation(37, 162);
            this.trendShiftCheck.setSize(173, 21);
            this.trendShiftCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean sel = TSDummyDialog.this.trendShiftCheck.isSelected();
                    TSDummyDialog.this.getTrendShiftRange().setEnabled(sel);
                    TSDummyDialog.this.getTrendShiftName().setEnabled(sel);
                }
            });
        }
        return this.trendShiftCheck;
    }

    private TSDateRangeSelector getTrendShiftRange() {
        if (this.trendShiftRange == null) {
            this.trendShiftRange = new TSDateRangeSelector();
            this.trendShiftRange.setEnabled(false);
            this.trendShiftRange.setSize(150, 20);
            this.trendShiftRange.setLocation(185, 192);
        }
        return this.trendShiftRange;
    }

    private VarNameSelector getTrendShiftName() {
        if (this.trendShiftName == null) {
            this.trendShiftName = new VarNameSelector();
            this.trendShiftName.setEnabled(false);
            this.trendShiftName.setLocation(185, 212);
            this.trendShiftName.setSize(150, 20);
            this.trendShiftName.setVarName("trendshift");
        }
        return this.trendShiftName;
    }

    private void oK_ActionEvents() {
        TSDateRange dateRange;
        String name;
        if (this.getImpulseCheck().isSelected()) {
            name = this.getImpulseName().getVarName();
            if (name.length() == 0) {
                StdMessages.errorInput("Impulse dummy name cannot be empty.");
                return;
            }
            TSDate date = this.getTSDateSelectorImpulse().getTSDate();
            TSHolder.getInstance().addTS(this.getTSDateSelectorImpulse().getRange().createShiftDumTS(name, new TSDateRange(date, date)));
        }
        if (this.getShiftCheck().isSelected()) {
            name = this.getShiftName().getVarName();
            if (name.length() == 0) {
                StdMessages.errorInput("Shift dummy name cannot be empty.");
                return;
            }
            dateRange = this.getTSDateRangeSelShift().getTSDateRange();
            TSHolder.getInstance().addTS(this.getTSDateRangeSelShift().getEnclosingRange().createShiftDumTS(name, dateRange));
        }
        if (this.getTrendShiftCheck().isSelected()) {
            name = this.getTrendShiftName().getVarName();
            if (name.length() == 0) {
                StdMessages.errorInput("Trend Shift dummy name cannot be empty.");
                return;
            }
            dateRange = this.getTrendShiftRange().getTSDateRange();
            TSHolder.getInstance().addTS(this.getTrendShiftRange().getEnclosingRange().createTrendShiftDumTS(name, dateRange));
        }
        this.setVisible(false);
    }

    public void setTSList(TSList newTimeSeriesList) {
        TS ts = newTimeSeriesList.getSelectedTS()[0];
        this.setTitle("Create Dummy for " + ts.range());
        this.getTSDateRangeSelShift().setEnclosingRange(ts.range());
        this.getTSDateSelectorImpulse().setEnclosingRange(ts.range());
        this.getTrendShiftRange().setEnclosingRange(ts.range());
        this.setLocationRelativeTo(TopFrameReference.getTopFrameRef());
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == TSDummyDialog.this.getOK()) {
                TSDummyDialog.this.connEtoC1();
            }
            if (e.getSource() == TSDummyDialog.this.getCancel()) {
                TSDummyDialog.this.connEtoC2();
            }
            if (e.getSource() == TSDummyDialog.this.getImpulseCheck()) {
                TSDummyDialog.this.connPtoP1SetTarget();
            }
            if (e.getSource() == TSDummyDialog.this.getShiftCheck()) {
                TSDummyDialog.this.connPtoP3SetTarget();
            }
            if (e.getSource() == TSDummyDialog.this.getImpulseCheck()) {
                TSDummyDialog.this.connPtoP2SetTarget();
            }
            if (e.getSource() == TSDummyDialog.this.getShiftCheck()) {
                TSDummyDialog.this.connPtoP4SetTarget();
            }
        }
    }
}

