/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.ts;

import com.jstatcom.component.IValTextField;
import com.jstatcom.ts.TSDate;
import com.jstatcom.ts.TSDateRange;
import org.apache.log4j.Logger;

public final class TSDateSelector
extends IValTextField {
    private static final Logger log = Logger.getLogger(TSDateSelector.class);
    private TSDateRange range = null;
    private TSDate tSDate = null;

    public TSDateSelector() {
        TSDate t1 = TSDate.valueOf("1960 q1");
        TSDate t2 = TSDate.valueOf("1982 q4");
        this.range = new TSDateRange(t1, t2);
        this.setTSDate(t1);
        this.setSize(39, this.getHeight());
    }

    public int getDateAsIndex() {
        return this.range.indexForDate(this.tSDate);
    }

    public TSDateRange getRange() {
        return this.range;
    }

    public TSDate getTSDate() {
        return this.tSDate;
    }

    @Override
    public void handleError(String msg) {
        super.handleError(msg + "\nThe previous value {" + this.tSDate + "} is restored.");
        this.setTSDate(this.tSDate);
    }

    public void setEnclosingRange(TSDate newStart, int numberOfPeriods) {
        this.setEnclosingRange(new TSDateRange(newStart, newStart.addPeriods(numberOfPeriods - 1)));
    }

    public void setEnclosingRange(TSDateRange newOverallRange) {
        if (newOverallRange == null) {
            throw new IllegalArgumentException("Range cannot be null.");
        }
        this.range = newOverallRange;
        if (this.range.encloses(this.tSDate) != null) {
            this.setTSDate(this.range.lowerBound());
        }
    }

    public void setTSDate(TSDate newTSDate) {
        String msg = this.range.encloses(newTSDate);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        TSDate oldDate = this.tSDate;
        this.tSDate = newTSDate;
        this.setTextCarefully(this.tSDate.toString());
        if (oldDate != null && !oldDate.equals(this.tSDate)) {
            this.firePropertyChange("TSDate", oldDate, this.tSDate);
        }
    }

    @Override
    public String validateInput() {
        TSDate tmpDate = null;
        String inputString = this.getText();
        try {
            tmpDate = TSDate.valueOf(inputString);
        }
        catch (Throwable ex) {
            String msg = "Input \"" + inputString + "\" is not a valid date.";
            log.warn((Object)msg, ex);
            return msg;
        }
        String error = this.range.encloses(tmpDate);
        if (error == null) {
            this.setTSDate(tmpDate);
        }
        return error;
    }
}

