/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.table;

import com.jstatcom.model.JSCData;
import com.jstatcom.model.Symbol;
import com.jstatcom.model.SymbolEvent;
import com.jstatcom.model.SymbolListener;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public abstract class JSCAbstractTableModel
extends AbstractTableModel {
    private Map<Integer, Boolean> colIndexEditableMap;
    private Map<Integer, Boolean> rowIndexEditableMap;
    private boolean editable = false;
    private Symbol currentSymbol = null;

    public JSCAbstractTableModel(Symbol symbol) {
        this.currentSymbol = symbol;
        if (symbol != null) {
            symbol.addSymbolListener(new SymbolListener(){

                @Override
                public void valueChanged(SymbolEvent evt) {
                    JSCAbstractTableModel.this.currentSymbol = evt.getSource();
                    JSCAbstractTableModel.this.fireTableStructureChanged();
                }
            });
        }
    }

    protected final Symbol getCurrentSymbol() {
        return this.currentSymbol;
    }

    public final JSCData getJSCData() {
        if (this.currentSymbol == null) {
            return null;
        }
        return this.currentSymbol.getJSCData();
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final void setEditable(boolean isEditable) {
        this.editable = isEditable;
    }

    public void setColEditableMap(Map<Integer, Boolean> colIndexEditableMap) {
        this.colIndexEditableMap = colIndexEditableMap;
    }

    public void setRowEditableMap(Map<Integer, Boolean> rowIndexEditableMap) {
        this.rowIndexEditableMap = rowIndexEditableMap;
    }

    public Map<Integer, Boolean> getColIndexEditableMap() {
        return this.colIndexEditableMap;
    }

    public Map<Integer, Boolean> getRowIndexEditableMap() {
        return this.rowIndexEditableMap;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Boolean val;
        if (this.colIndexEditableMap == null && this.rowIndexEditableMap == null) {
            return this.editable;
        }
        boolean rtn = this.editable;
        if (this.colIndexEditableMap != null) {
            val = this.colIndexEditableMap.get(columnIndex);
            boolean bl = rtn = val == null ? rtn : val;
        }
        if (this.rowIndexEditableMap != null) {
            val = this.rowIndexEditableMap.get(rowIndex);
            rtn = val == null ? rtn : val;
        }
        return rtn;
    }
}

