/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.table;

import com.jstatcom.table.BorderTableBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BorderTable
extends JTable {
    private Insets _insets = new Insets(0, 0, 0, 0);
    private int minimumColumnWidth = 30;
    private int maximumColumnWidth = 200;
    private int columnWidth = 75;
    private boolean dynamicColumnWidth = false;
    private BorderTableBorder borderTableBorder = new BorderTableBorder();
    protected Rectangle rect00 = new Rectangle();
    private EventListener eventListener = new EventListener();

    public BorderTable() {
        this(null, null, null);
    }

    public BorderTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.setColumnWidth(this.columnWidth);
        this.setAutoResizeMode(0);
        this.setOpaque(false);
        this.setBackground(Color.white);
        this.setBorder(this.borderTableBorder);
        this.addPropertyChangeListener(this.eventListener);
    }

    @Override
    public int columnAtPoint(Point point) {
        point.x -= this._insets.left;
        return super.columnAtPoint(point);
    }

    @Override
    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        this.setColumnWidth(this.columnWidth);
    }

    @Override
    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        Rectangle r = super.getCellRect(row, column, includeSpacing);
        if (this._insets != null) {
            r.x += this._insets.left;
            r.y += this._insets.top;
        }
        return r;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public int getMaximumColumnWidth() {
        return this.maximumColumnWidth;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public int getMinimumColumnWidth() {
        return this.minimumColumnWidth;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isVisible()) {
            return new Dimension(0, 0);
        }
        Dimension d = super.getPreferredSize();
        d.width += this._insets.left + this._insets.right;
        d.height += this._insets.bottom;
        return d;
    }

    public boolean isDynamicColumnWidth() {
        return this.dynamicColumnWidth;
    }

    public int maxCellLength() {
        int cols = this.getColumnCount();
        int maxWidth = 0;
        for (int i = 0; i < cols; ++i) {
            maxWidth = Math.max(maxWidth, this.maxCellLengthInColumn(i));
        }
        return maxWidth;
    }

    private int maxCellLengthInColumn(int col) {
        TableCellRenderer renderer = null;
        renderer = this.getModel().getRowCount() > 0 ? this.getCellRenderer(0, col) : this.getDefaultRenderer(this.getModel().getColumnClass(col));
        int rows = this.getRowCount();
        int maxWidth = 0;
        for (int i = 0; i < rows; ++i) {
            if (col >= this.getModel().getColumnCount()) continue;
            Component c = this.prepareRenderer(renderer, i, col);
            maxWidth = Math.max(maxWidth, c.getPreferredSize().width);
        }
        return (maxWidth += 2 * this.getIntercellSpacing().width) + 5;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle r = g.getClipBounds();
        if (this.isOpaque()) {
            Color oldColor = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(r.x, r.y, r.width, r.height);
            g.setColor(oldColor);
        }
        Dimension d = this.getPreferredSize();
        Rectangle r0 = new Rectangle(this._insets.left, this._insets.top, d.width - this._insets.left - this._insets.right, d.height - this._insets.top - this._insets.bottom);
        Rectangle r1 = r0.intersection(r);
        if (r1.isEmpty()) {
            return;
        }
        g.setClip(r1.x, r1.y, r1.width, r1.height);
        super.paintComponent(g);
        g.setClip(r.x, r.y, r.width, r.height);
    }

    @Override
    public int rowAtPoint(Point point) {
        point.y -= this._insets.top;
        return super.rowAtPoint(point);
    }

    @Override
    public void setBorder(Border border) {
        Border oldBorder = this.getBorder();
        if (oldBorder == null) {
            super.setBorder(border);
        } else {
            super.setBorder(new CompoundBorder(border, this.borderTableBorder));
        }
        ((AbstractBorder)this.getBorder()).getBorderInsets(this, this._insets);
    }

    public void setColumnWidth(int newValue) {
        if (newValue < 0) {
            throw new IllegalArgumentException("Invalid argument " + newValue + " < 0.");
        }
        int oldValue = this.columnWidth;
        newValue = Math.min(Math.max(this.minimumColumnWidth, newValue), this.maximumColumnWidth);
        try {
            this.fireVetoableChange("columnWidth", new Integer(oldValue), new Integer(newValue));
        }
        catch (PropertyVetoException pve) {
            PropertyChangeEvent e = pve.getPropertyChangeEvent();
            int vetoValue = (Integer)e.getNewValue();
            newValue = Math.min(Math.max(vetoValue, newValue), this.maximumColumnWidth);
        }
        this.columnWidth = newValue;
        TableColumnModel cm = this.getColumnModel();
        int n = cm == null ? 0 : cm.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (oldValue < newValue) {
                cm.getColumn(i).setMaxWidth(newValue);
                cm.getColumn(i).setMinWidth(newValue);
            } else {
                cm.getColumn(i).setMinWidth(newValue);
                cm.getColumn(i).setMaxWidth(newValue);
            }
            cm.getColumn(i).setPreferredWidth(newValue);
        }
        this.updateRect00();
        this.resizeAndRepaint();
    }

    public void setDynamicColumnWidth(boolean newDynamicColumnWidth) {
        this.dynamicColumnWidth = newDynamicColumnWidth;
    }

    @Override
    public void setIntercellSpacing(Dimension newSpacing) {
        Dimension oldSpacing = this.getColumnModel() == null ? new Dimension(0, this.getRowMargin()) : this.getIntercellSpacing();
        super.setIntercellSpacing(newSpacing);
        this.updateRect00();
        this.firePropertyChange("intercellSpacing", oldSpacing, newSpacing);
    }

    public void setMaximumColumnWidth(int newMaximumColumnWidth) {
        this.maximumColumnWidth = Math.max(this.minimumColumnWidth, newMaximumColumnWidth);
    }

    public void setMinimumColumnWidth(int newMinimumColumnWidth) {
        this.minimumColumnWidth = Math.min(newMinimumColumnWidth, this.maximumColumnWidth);
    }

    @Override
    public final void sizeColumnsToFit(int c) {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (this.isDynamicColumnWidth()) {
            int col = e.getColumn();
            if (col < 0 || e.getType() == -1) {
                this.setColumnWidth(this.maxCellLength());
            } else {
                int maybeNewWidth = this.maxCellLengthInColumn(col);
                if (this.columnWidth < maybeNewWidth) {
                    this.setColumnWidth(maybeNewWidth);
                } else {
                    this.setColumnWidth(this.maxCellLength());
                }
            }
        }
    }

    private void updateRect00() {
        if (this.getColumnCount() > 0 && this.getRowCount() > 0) {
            this.rect00 = this.getCellRect(0, 0, true);
        }
    }

    private class EventListener
    implements PropertyChangeListener {
        private EventListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            int w;
            if (e.getPropertyName().equals("columnModel")) {
                BorderTable.this.createDefaultColumnsFromModel();
                if (BorderTable.this.isDynamicColumnWidth()) {
                    w = BorderTable.this.maxCellLength();
                    BorderTable.this.setColumnWidth(w);
                }
            }
            if (e.getPropertyName().equals("model") && BorderTable.this.isDynamicColumnWidth()) {
                w = BorderTable.this.maxCellLength();
                BorderTable.this.setColumnWidth(w);
            }
        }
    }
}

