/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.project;

import com.jstatcom.component.CompSettings;
import com.jstatcom.component.StdMessages;
import com.jstatcom.project.ProjectDialog;
import com.jstatcom.project.ProjectManager;
import com.jstatcom.project.ProjectTree;
import com.jstatcom.project.ProjectTreeNode;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;

public final class ProjectNodePopup
extends JPopupMenu {
    private AbstractAction save = new AbstractAction("Save Current State Here"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ProjectManager.getInstance().serializeProject(ProjectNodePopup.this.currentNode.getProjectFile(), ProjectNodePopup.this.currentNode.getName(), ProjectNodePopup.this.currentNode.getDescription());
        }
    };
    private AbstractAction delete = new AbstractAction("Delete"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ProjectTree.getInstance().deleteSelectedProjects();
        }
    };
    private AbstractAction edit = new AbstractAction("Edit"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (ProjectNodePopup.this.currentNode == null) {
                return;
            }
            try {
                ProjectNodePopup.this.getProjectDialog().setProjectNode(ProjectNodePopup.this.currentNode);
                ProjectNodePopup.this.getProjectDialog().setSaveDialog(false);
                ProjectNodePopup.this.getProjectDialog().setVisible(true);
            }
            catch (Throwable ex) {
                String msg = "There was an error loading the project from\n\"" + ProjectNodePopup.this.currentNode.getProjectFile() + "\"\nThe message was:\n" + ex.getMessage();
                StdMessages.error(msg, "Project Edit Error");
            }
        }
    };
    private AbstractAction info = new AbstractAction("Project Info"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (ProjectNodePopup.this.currentNode == null) {
                return;
            }
            String msg = "Name:\n";
            msg = msg + ProjectNodePopup.this.currentNode.getName() + "\n\n";
            msg = msg + "Last edited:\n";
            msg = msg + CompSettings.getDefaultDateFormat().format(ProjectNodePopup.this.currentNode.getDate()) + "\n\n";
            msg = msg + "File:\n";
            msg = msg + ProjectNodePopup.this.currentNode.getProjectFile() + "\n\n";
            msg = msg + "Description:\n";
            msg = msg + ProjectNodePopup.this.currentNode.getDescription();
            StdMessages.info(msg, "Project Information");
        }
    };
    private static final ProjectNodePopup INSTANCE = new ProjectNodePopup();
    private ProjectTreeNode currentNode = null;

    private ProjectNodePopup() {
        this.add(this.save);
        this.addSeparator();
        this.add(this.edit);
        this.add(this.delete);
        this.addSeparator();
        this.add(this.info);
    }

    private ProjectDialog getProjectDialog() {
        return ProjectDialog.getInstance();
    }

    public static ProjectNodePopup getInstance() {
        return INSTANCE;
    }

    public void setCurrentNode(ProjectTreeNode currentNode) {
        boolean lastState = currentNode.isLastState();
        this.save.setEnabled(!lastState);
        this.edit.setEnabled(!lastState);
        this.currentNode = currentNode;
    }
}

