/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.project;

import com.jstatcom.project.ProjectData;
import com.jstatcom.project.ProjectDataHandler;
import com.jstatcom.project.ProjectDataTypes;
import java.util.HashMap;
import java.util.Map;

public final class ProjectDataManager {
    private static final ProjectDataManager INSTANCE = new ProjectDataManager();
    private final Map<ProjectDataTypes, ProjectDataHandler> handlerMap = new HashMap<ProjectDataTypes, ProjectDataHandler>();

    private ProjectDataManager() {
    }

    public static ProjectDataManager getInstance() {
        return INSTANCE;
    }

    public void setProjectData(ProjectData data) {
        if (data == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        ProjectDataHandler handler = this.handlerMap.get(data.getProjectDataType());
        handler.setProjectData(data);
    }

    public ProjectData[] getProjectData() {
        ProjectData[] rtn = new ProjectData[this.handlerMap.size()];
        int i = 0;
        for (ProjectDataHandler element : this.handlerMap.values()) {
            rtn[i++] = element.getProjectData();
        }
        return rtn;
    }

    public void register(ProjectDataHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (this.handlerMap.containsKey(handler.getProjectDataType())) {
            throw new IllegalStateException("An instance of ProjectDataHandler for the type \"" + handler.getProjectDataType() + "\" has already been registered.");
        }
        this.handlerMap.put(handler.getProjectDataType(), handler);
    }
}

