/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model;

import com.jstatcom.model.JSCDataEvent;
import com.jstatcom.model.JSCDataEventTypes;
import com.jstatcom.model.Symbol;
import com.jstatcom.model.SymbolEventTypes;

public class SymbolEvent {
    private final Symbol source;
    private final SymbolEventTypes type;
    private final Object newValue;
    private final Object oldValue;

    private SymbolEvent(Symbol source, SymbolEventTypes type, boolean isEmpty) {
        this(source, type, new Boolean(!isEmpty), new Boolean(isEmpty));
    }

    private SymbolEvent(Symbol source, SymbolEventTypes type, Object oldValue, Object newValue) {
        this.source = source;
        this.type = type;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public final Object getNewValue() {
        return this.newValue;
    }

    public final boolean isSourceEmpty() {
        if (this.newValue == null) {
            return true;
        }
        return this.source.isEmpty();
    }

    public final Object getOldValue() {
        return this.oldValue;
    }

    public final Symbol getSource() {
        return this.source;
    }

    public final SymbolEventTypes getType() {
        return this.type;
    }

    public String toString() {
        return super.toString() + " [source symbol:name=" + this.source.NAME + ",type=" + this.source.type + ";evttype=" + this.type + "]";
    }

    public static SymbolEvent valueOfEmptyState(Symbol source, boolean isEmptyNow) {
        return new SymbolEvent(source, SymbolEventTypes.EMPTY_STATE, isEmptyNow);
    }

    public static SymbolEvent valueOfJSCDataEvent(Symbol source, JSCDataEvent evt) {
        if (evt.getType() == JSCDataEventTypes.EMPTY_STATE) {
            return SymbolEvent.valueOfEmptyState(source, (Boolean)evt.getNewValue());
        }
        if (evt.getType() == JSCDataEventTypes.VALUE_CHANGED) {
            return SymbolEvent.valueOfValChanged(source, evt.getOldValue(), evt.getNewValue());
        }
        throw new IllegalArgumentException("JSCDataEvent " + evt + " could not be translated to a SymbolEvent.");
    }

    public static SymbolEvent valueOfValChanged(Symbol source, Object oldValue, Object newValue) {
        return new SymbolEvent(source, SymbolEventTypes.VALUE_CHANGED, oldValue, newValue);
    }
}

