/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model;

import com.jstatcom.model.AbstractJSCData;
import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCDataEvent;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.util.UString;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlFormat;

public final class JSCNumber
extends AbstractJSCData {
    private final String name;
    private Double value = null;
    private JSCDataEvent clearEvent = null;
    private JSCDataEvent notEmptyEvent = null;
    public static final XmlFormat<JSCNumber> JSCNumber_XML = new XmlFormat<JSCNumber>(JSCNumber.class){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void format(JSCNumber data, XmlElement xml) {
            xml.setAttribute("name", data.name);
            JSCNumber jSCNumber = data;
            synchronized (jSCNumber) {
                xml.setAttribute("value", data.value + "");
            }
        }

        @Override
        public JSCNumber parse(XmlElement xml) {
            String nam = xml.getAttribute("name") + "";
            String numberString = xml.getAttribute("value") + "";
            Double newNumber = null;
            if (!numberString.equalsIgnoreCase("null")) {
                newNumber = UString.parseToNumber(numberString);
            }
            JSCNumber num = new JSCNumber(nam, newNumber);
            return num;
        }
    };

    public JSCNumber(String name) {
        this(name, null);
    }

    public JSCNumber(String name, double value) {
        this(name, new Double(value));
    }

    public JSCNumber(String name, Double value) {
        if (name == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.name = name = JSCConstants.checkNameThrowEx(name);
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Double oldValue;
        JSCNumber jSCNumber = this;
        synchronized (jSCNumber) {
            if (this.value == null) {
                return;
            }
            oldValue = this.value;
            this.value = null;
        }
        if (this.clearEvent == null) {
            this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
        }
        if (this.eventSupport == null) {
            return;
        }
        this.getEventSupport().dispatchEvent(this.clearEvent);
        this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, null));
    }

    @Override
    public synchronized JSCNumber copy() {
        return new JSCNumber(this.name, this.value);
    }

    public synchronized double doubleVal() {
        if (this.value == null) {
            throw new IllegalStateException("JSCData is empty: " + this.toString() + ".");
        }
        return this.value;
    }

    public synchronized Double getNumber() {
        return this.value;
    }

    public synchronized int intVal() {
        if (this.value == null) {
            throw new IllegalStateException("JSCData is empty: " + this.toString() + ".");
        }
        return this.value.intValue();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.value == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isEqual(JSCData o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JSCNumber)) {
            return false;
        }
        JSCNumber otherNumber = (JSCNumber)o;
        boolean ret = true;
        JSCNumber jSCNumber = this;
        synchronized (jSCNumber) {
            JSCData jSCData = o;
            synchronized (jSCData) {
                ret = this.value != null ? this.value.equals(otherNumber.getNumber()) : otherNumber.getNumber() == null;
            }
        }
        return ret;
    }

    public synchronized boolean isNaN() {
        if (this.value == null) {
            throw new IllegalStateException("JSCData is empty: " + this.toString() + ".");
        }
        return Double.isNaN(this.value);
    }

    @Override
    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNumber(Double newValue) {
        if (newValue == null) {
            this.clear();
            return;
        }
        boolean wasEmpty = false;
        Double oldValue = null;
        JSCNumber jSCNumber = this;
        synchronized (jSCNumber) {
            if (newValue.equals(this.value)) {
                return;
            }
            wasEmpty = this.isEmpty();
            oldValue = this.value;
            this.value = newValue;
        }
        if (this.eventSupport == null) {
            return;
        }
        this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newValue));
        if (wasEmpty) {
            if (this.notEmptyEvent == null) {
                this.notEmptyEvent = JSCDataEvent.valueOfEmptyState(this, false);
            }
            this.getEventSupport().dispatchEvent(this.notEmptyEvent);
        }
    }

    public void setVal(double newDouble) {
        this.setNumber(new Double(newDouble));
    }

    @Override
    public JSCTypes type() {
        return JSCTypes.NUMBER;
    }

    @Override
    public synchronized Object value() {
        return this.value;
    }
}

