/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model;

public class JSCConstants {
    private final String name;
    public static boolean DEBUG = false;
    public static final Double NaN = new Double(Double.NaN);
    public static final long NaNLongBits = Double.doubleToLongBits(Double.NaN);
    public static final Double POS_INF = new Double(Double.POSITIVE_INFINITY);
    public static final Double NEG_INF = new Double(Double.NEGATIVE_INFINITY);

    protected JSCConstants(String name) {
        this.name = name;
    }

    public static String checkNameThrowEx(String name) {
        if (name == null) {
            return null;
        }
        name = name.trim();
        String error = null;
        error = JSCConstants.isValidName(name);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
        return name;
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public static String isValidName(String name) {
        if (name == null) {
            return "Name cannot be null.";
        }
        if (name.trim().length() == 0) {
            return "Name cannot be empty.";
        }
        char c = name.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return "\"" + name + "\" does not start with a letter or '_'.";
        }
        for (int i = 1; i < name.length(); ++i) {
            c = name.charAt(i);
            if (Character.isLetter(c) || c == '_' || Character.isDigit(c)) continue;
            return "\"" + name + "\" contains invalid characters.";
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public static String getSystemTemp() {
        String temp = System.getProperty("java.io.tmpdir");
        if (temp != null) {
            return temp;
        }
        throw new RuntimeException("Property java.io.tmpdir is empty.");
    }

    public static String getUserDir() {
        String userDir = System.getProperty("user.dir");
        if (userDir != null) {
            return userDir;
        }
        throw new RuntimeException("Property user.dir is empty.");
    }

    public static String getUserHome() {
        String userDir = System.getProperty("user.home");
        if (userDir != null) {
            return userDir;
        }
        throw new RuntimeException("Property user.home is empty.");
    }
}

