/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.engine;

import com.jstatcom.component.StdMessages;
import com.jstatcom.engine.ConfigDialog;
import com.jstatcom.engine.ConfigKeys;
import com.jstatcom.engine.EngineTypes;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javolution37.javolution.xml.ObjectReader;
import javolution37.javolution.xml.ObjectWriter;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlFormat;
import org.apache.log4j.Logger;

public final class ConfigHolder {
    private static final Logger log = Logger.getLogger(ConfigHolder.class);
    private final Map<ConfigKeys, String> configMap = new HashMap<ConfigKeys, String>();
    private static final Map<EngineTypes, ConfigHolder> configHoldersMap = new HashMap<EngineTypes, ConfigHolder>();
    private final EngineTypes engineType;
    public static final XmlFormat<ConfigHolder> ConfigHolder_XML = new XmlFormat<ConfigHolder>(ConfigHolder.class){

        @Override
        public void format(ConfigHolder data, XmlElement xml) {
            xml.setAttribute("engine", ((ConfigHolder)data).engineType.name);
            for (ConfigKeys key : data.configMap.keySet()) {
                Object value = data.configMap.get(key);
                xml.add(new KeyValPair(key.name(), value.toString()));
            }
        }

        @Override
        public ConfigHolder parse(XmlElement xml) {
            Map<String, ConfigKeys> confKeys;
            String oNam = xml.getAttribute("engine", (String)null);
            if (oNam == null) {
                return null;
            }
            EngineTypes type = EngineTypes.valueOf(oNam.toString().toUpperCase());
            if (type == null) {
                return null;
            }
            ConfigHolder conf = null;
            if (configHoldersMap.containsKey(type)) {
                conf = (ConfigHolder)configHoldersMap.get(type);
            }
            if (conf == null) {
                conf = new ConfigHolder(type);
            }
            if ((confKeys = type.getConfigKeys()) == null) {
                return conf;
            }
            while (xml.hasNext()) {
                KeyValPair pair = (KeyValPair)xml.getNext();
                ConfigKeys o = confKeys.get(pair.key);
                if (!(o instanceof ConfigKeys)) continue;
                conf.setConfig(o, pair.value);
            }
            configHoldersMap.put(type, conf);
            return conf;
        }
    };

    private ConfigHolder(EngineTypes engineType) {
        if (engineType == null) {
            throw new IllegalArgumentException("Argument was null");
        }
        this.engineType = engineType;
        if (configHoldersMap.containsKey(engineType)) {
            throw new IllegalStateException("Instance for " + engineType + " already exists.");
        }
        Map<String, ConfigKeys> confKeys = engineType.getConfigKeys();
        if (confKeys == null) {
            return;
        }
        Collection<ConfigKeys> allKeys = confKeys.values();
        for (ConfigKeys key : allKeys) {
            this.setConfig(key, key.defaultVal());
        }
    }

    public void adjustConfig() {
        if (ConfigDialog.showConfigDialog(this)) {
            this.saveConfig();
        }
    }

    public String getConfig(ConfigKeys key) {
        String o;
        if (key == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (this.configMap.containsKey(key) && (o = this.configMap.get(key)) != null) {
            return o.toString();
        }
        return null;
    }

    public Set<ConfigKeys> getConfigKeys() {
        return this.configMap.keySet();
    }

    public final EngineTypes getEngineType() {
        return this.engineType;
    }

    private void saveConfig() {
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(this.engineType.getConfigFile())));
            ObjectWriter<ConfigHolder> objectWriter = new ObjectWriter<ConfigHolder>();
            objectWriter.setPackagePrefix("", "com.jstatcom.engine");
            objectWriter.setPackagePrefix("jstatcom", "com.jstatcom");
            objectWriter.write(this, out);
        }
        catch (IOException ivjExc) {
            log.error((Object)"XML serialization failed", (Throwable)ivjExc);
        }
    }

    public void setConfig(ConfigKeys configKey, String value) {
        if (configKey == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        Map<String, ConfigKeys> confKeys = this.engineType.getConfigKeys();
        if (confKeys == null) {
            throw new IllegalArgumentException(configKey + " is not valid for " + this.engineType + ".");
        }
        if (!confKeys.containsValue(configKey)) {
            throw new IllegalArgumentException(configKey + " is not valid for " + this.engineType + ".");
        }
        this.configMap.put(configKey, value);
    }

    public static ConfigHolder valueOf(EngineTypes engineType) {
        if (engineType == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (configHoldersMap.containsKey(engineType)) {
            return configHoldersMap.get(engineType);
        }
        ConfigHolder configHolder = null;
        File file = new File(engineType.getConfigFile());
        if (file.isFile()) {
            ObjectReader constructor = new ObjectReader();
            try {
                configHolder = (ConfigHolder)constructor.read(new FileInputStream(file));
            }
            catch (Throwable ex) {
                configHolder = null;
            }
        }
        if (configHolder == null) {
            configHolder = new ConfigHolder(engineType);
        }
        String error = null;
        error = engineType.checkConfig(configHolder);
        if (error != null) {
            StdMessages.error(error, "Error in " + engineType + " Settings");
            if (!ConfigDialog.showConfigDialog(configHolder)) {
                configHoldersMap.remove(engineType);
                throw new IllegalStateException("Config settings are not in a legal state for " + engineType + ".");
            }
            configHolder.saveConfig();
        }
        configHoldersMap.put(engineType, configHolder);
        return configHolder;
    }

    public static class KeyValPair {
        final String key;
        final String value;
        public static final XmlFormat<KeyValPair> KeyValPair_XML = new XmlFormat<KeyValPair>(KeyValPair.class){

            @Override
            public void format(KeyValPair data, XmlElement xml) {
                xml.setAttribute("key", data.key);
                xml.setAttribute("value", data.value);
            }

            @Override
            public KeyValPair parse(XmlElement xml) {
                String nkey = xml.getAttribute("key") + "";
                String nvalue = xml.getAttribute("value") + "";
                return new KeyValPair(nkey, nvalue);
            }
        };

        public KeyValPair(String key, String value) {
            if (key == null || value == null) {
                throw new IllegalArgumentException("Argument was null");
            }
            this.value = value;
            this.key = key;
        }
    }
}

