/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.component;

import com.jstatcom.model.JSCTypeDef;
import com.jstatcom.model.Scope;
import com.jstatcom.model.Symbol;
import com.jstatcom.model.SymbolEvent;
import com.jstatcom.model.SymbolListener;
import com.jstatcom.model.SymbolTable;
import javax.swing.JLabel;
import javax.swing.JTextArea;

public class SymbolDisplay
extends JTextArea
implements SymbolListener {
    private Symbol symbol = null;
    private JSCTypeDef symbolDef = null;
    private Scope symbolScope = Scope.GLOBAL;

    public SymbolDisplay() {
        this.setSize(100, 20);
        this.setText("{}");
        this.setOpaque(false);
        this.setEditable(false);
        this.setSelectedTextColor(this.getForeground());
        this.setFont(new JLabel().getFont());
    }

    @Override
    public void valueChanged(SymbolEvent evt) {
        this.symbol = evt.getSource();
        this.setSymbolText();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setSelectionColor(this.getParent().getBackground());
        this.setDataForSymbolName();
    }

    private void setDataForSymbolName() {
        SymbolTable sTable = null;
        if (this.symbolDef != null) {
            sTable = this.symbolScope.getSymbolTable(this);
        }
        Symbol newSymbol = null;
        if (sTable != null && this.symbolDef != null) {
            newSymbol = sTable.get(this.symbolDef);
        }
        if (newSymbol == this.symbol) {
            return;
        }
        if (this.symbol != null) {
            this.symbol.removeSymbolListener(this);
        }
        this.symbol = newSymbol;
        if (this.symbol != null) {
            this.symbol.addSymbolListener(this);
        }
        this.setSymbolText();
    }

    public JSCTypeDef getSymbolDef() {
        return this.symbolDef;
    }

    public void setSymbolDef(JSCTypeDef newSymbolDef) {
        this.symbolDef = newSymbolDef;
        this.setDataForSymbolName();
    }

    private void setSymbolText() {
        if (this.symbol != null) {
            this.setText(this.symbol.display());
        } else {
            this.setText("{}");
        }
    }

    public Scope getSymbolScope() {
        return this.symbolScope;
    }

    public void setSymbolScope(Scope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.symbolScope = scope;
        this.setDataForSymbolName();
    }
}

