/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.component;

import com.jstatcom.component.TopFrameReference;
import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public final class StdMessages {
    private static final Logger log = Logger.getLogger(StdMessages.class);

    private StdMessages() {
    }

    public static void error(String msg, String title) {
        StdMessages.error(msg, title, TopFrameReference.getTopFrameRef());
    }

    public static void error(final String msg, final String title, final Frame parent) {
        if (SwingUtilities.isEventDispatchThread()) {
            JOptionPane.showConfirmDialog(parent, msg, title, -1, 0);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showConfirmDialog(parent, msg, title, -1, 0);
                    }
                });
            }
            catch (Throwable ex) {
                log.error((Object)"Error waiting for SwingUtilities.invokeAndWait", ex);
            }
        }
    }

    public static void error(final String msg, final String title, final Dialog parent) {
        if (SwingUtilities.isEventDispatchThread()) {
            JOptionPane.showConfirmDialog(parent, msg, title, -1, 0);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showConfirmDialog(parent, msg, title, -1, 0);
                    }
                });
            }
            catch (Throwable ex) {
                log.error((Object)"Error waiting for SwingUtilities.invokeAndWait", ex);
            }
        }
    }

    public static void errorEngine(String msg) {
        StdMessages.error(msg, "Engine Error");
    }

    public static void errorEngine(String msg, Frame parent) {
        StdMessages.error(msg, "Engine Error", parent);
    }

    public static void errorEngine(String msg, Dialog parent) {
        StdMessages.error(msg, "Engine Error", parent);
    }

    public static void errorInput(String msg) {
        StdMessages.error(msg, "Input Error");
    }

    public static void errorInput(String msg, Frame parent) {
        StdMessages.error(msg, "Input Error", parent);
    }

    public static void errorInput(String msg, Dialog parent) {
        StdMessages.error(msg, "Input Error", parent);
    }

    public static void errorSpecification(String msg) {
        StdMessages.error(msg, "Specification Error");
    }

    public static void errorSpecification(String msg, Frame parent) {
        StdMessages.error(msg, "Specification Error", parent);
    }

    public static void errorSpecification(String msg, Dialog parent) {
        StdMessages.error(msg, "Specification Error", parent);
    }

    public static void info(String msg, String title) {
        StdMessages.info(msg, title, TopFrameReference.getTopFrameRef());
    }

    public static void info(final String msg, final String title, final Frame parent) {
        if (SwingUtilities.isEventDispatchThread()) {
            JOptionPane.showConfirmDialog(parent, msg, title, -1, 1);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showConfirmDialog(parent, msg, title, -1, 1);
                    }
                });
            }
            catch (Throwable ex) {
                log.error((Object)"Error waiting for SwingUtilities.invokeAndWait", ex);
            }
        }
    }

    public static void info(final String msg, final String title, final Dialog parent) {
        if (SwingUtilities.isEventDispatchThread()) {
            JOptionPane.showConfirmDialog(parent, msg, title, -1, 1);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showConfirmDialog(parent, msg, title, -1, 1);
                    }
                });
            }
            catch (Throwable ex) {
                log.error((Object)"Error waiting for SwingUtilities.invokeAndWait", ex);
            }
        }
    }

    public static void infoGeneral(String msg) {
        StdMessages.info(msg, "Information");
    }

    public static void infoGeneral(String msg, Frame parent) {
        StdMessages.info(msg, "Information", parent);
    }

    public static void infoGeneral(String msg, Dialog parent) {
        StdMessages.info(msg, "Information", parent);
    }

    public static void infoNothingSelected(String msg) {
        StdMessages.info(msg, "Nothing Selected");
    }

    public static void infoNothingSelected(String msg, Frame parent) {
        StdMessages.info(msg, "Nothing Selected", parent);
    }

    public static void infoNothingSelected(String msg, Dialog parent) {
        StdMessages.info(msg, "Nothing Selected", parent);
    }
}

