/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.component;

import com.jstatcom.component.CompSettings;
import com.jstatcom.component.StdMessages;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.Keymap;

public abstract class IValTextField
extends JTextField {
    private Frame parentFrame = null;
    private Dialog parentDialog = null;
    private boolean isEditing = false;
    private boolean isHandlingError = false;
    protected String lastValidText = "";
    private EventHandler eventHandler = null;

    private void cancelEdit() {
        if (this.isEditing) {
            this.isEditing = false;
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.getAWTEventListener());
            this.setText(this.lastValidText);
            if (this.hasFocus()) {
                SwingUtilities.getRootPane(this).grabFocus();
            }
        }
    }

    private void errorHandleImplementation(String err) {
        this.isHandlingError = true;
        String error = err;
        this.handleError(error);
        this.isHandlingError = false;
    }

    protected void focusGained() {
        if (this.isEnabled() && !this.isEditing) {
            this.isEditing = true;
            Toolkit.getDefaultToolkit().addAWTEventListener(this.getAWTEventListener(), 16L);
        }
    }

    protected void focusLost() {
        if (this.isEditing) {
            this.isEditing = false;
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.getAWTEventListener());
            if (!this.isHandlingError) {
                String err = null;
                err = this.validateInputEx();
                if (err != null) {
                    this.errorHandleImplementation(err);
                    return;
                }
            }
        }
    }

    private AWTEventListener getAWTEventListener() {
        if (this.eventHandler == null) {
            this.eventHandler = new EventHandler();
        }
        return this.eventHandler;
    }

    public void handleError(String msg) {
        this.setBackground(CompSettings.errorBackground);
        if (this.parentFrame != null) {
            StdMessages.errorInput(msg, this.parentFrame);
        } else if (this.parentDialog != null) {
            StdMessages.errorInput(msg, this.parentDialog);
        } else {
            StdMessages.errorInput(msg);
        }
        this.setBackground(Color.WHITE);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof JFrame) {
            this.parentFrame = (JFrame)window;
        }
        if (window instanceof JDialog) {
            this.parentDialog = (JDialog)window;
        }
    }

    public final boolean isEditing() {
        return this.isEditing;
    }

    private void prepareKeyEvent(KeyEvent e) {
        String err = null;
        if (e.getKeyCode() == 9 || e.getKeyChar() == '\t') {
            err = this.validateInputEx();
            if (err != null) {
                this.errorHandleImplementation(err);
                e.consume();
                return;
            }
        } else if (e.getKeyCode() == 10 && e.getID() != 401) {
            err = this.validateInputEx();
            if (err != null) {
                this.errorHandleImplementation(err);
                e.consume();
                return;
            }
        } else if (e.getKeyCode() == 27) {
            this.cancelEdit();
        }
        boolean componentAction = false;
        Keymap binding = this.getKeymap();
        if (binding != null) {
            KeyStroke k = KeyStroke.getKeyStrokeForEvent(e);
            componentAction = binding.getAction(k) != null;
        }
        boolean maybeTriggerMenu = e.getModifiers() == 32;
        maybeTriggerMenu = maybeTriggerMenu || e.getModifiers() == 8;
        boolean bl = maybeTriggerMenu = maybeTriggerMenu || e.getModifiers() == 4;
        if (!componentAction && !e.isConsumed() && maybeTriggerMenu && (err = this.validateInputEx()) != null) {
            e.consume();
            boolean cb = Character.isLetterOrDigit(e.getKeyChar());
            if (e.getID() == 401 && cb) {
                this.errorHandleImplementation(err);
                return;
            }
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        switch (e.getID()) {
            case 1004: {
                this.focusGained();
                break;
            }
            case 1005: {
                this.focusLost();
            }
        }
    }

    @Override
    protected final void processKeyEvent(KeyEvent e) {
        this.prepareKeyEvent(e);
        super.processKeyEvent(e);
    }

    public void setTextCarefully(String text) {
        int selStart = this.getSelectionStart();
        int selEnd = this.getSelectionEnd();
        int pos = this.getCaretPosition();
        this.setText(text);
        int ll = this.getText().length();
        if (pos < ll) {
            this.setCaretPosition(pos);
        }
        if (selStart < ll) {
            this.setSelectionStart(selStart);
        }
        if (selEnd < ll) {
            this.setSelectionEnd(selEnd);
        } else {
            this.setSelectionEnd(ll);
        }
        this.lastValidText = this.getText();
    }

    public abstract String validateInput();

    private String validateInputEx() {
        if (this.lastValidText.equals(this.getText())) {
            return null;
        }
        String err = null;
        try {
            err = this.validateInput();
            if (err == null) {
                this.lastValidText = this.getText();
            }
        }
        catch (Throwable ex) {
            err = ex.getMessage();
        }
        return err;
    }

    private class EventHandler
    implements AWTEventListener {
        private EventHandler() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event.getSource().equals(IValTextField.this)) {
                return;
            }
            String err = null;
            int id = event.getID();
            switch (id) {
                case 501: {
                    err = IValTextField.this.validateInputEx();
                    if (err == null) break;
                    IValTextField.this.errorHandleImplementation(err);
                    ((InputEvent)event).consume();
                }
            }
        }
    }
}

